<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class TaskService extends MY_Service {

    # task progress
    const _OPEN         = 0;
    const _INPROGRESS   = 1;
    const _COMPLETED    = 2;
    const _CLOSED       = 3;

    # task category :: refer to TaskCategories table
    const _TASK_CUSTOMER = 1;
    const _TASK_SMARTER  = 2;

    # type of task
    const _REMOTE       = 1;
    const _SITE         = 0;

    const _PROFIT_RATE  = '60%';

    const _STATUS = ['Open', 'In Progress', 'Completed', 'Closed'];
    const _STATUS_COLOR = ['gray', 'warning', 'green', 'pink'];

    private $Services = [
        'UserService' => 'UserService',
        'operation/task/OP_TaskManagerService' => 'OP_TaskManagerService',
        'SettingService' => 'SettingService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: DEFAULT */
    	public function getTaskStatus($status){
            switch ($status) {
                case self::_INPROGRESS:
                    return '<span class="fa fa-circle text-orange"></span> In Progress';
                    break;
                case self::_COMPLETED:
                    return '<span class="fa fa-circle text-green"></span> Completed';
                    break;
                case self::_CLOSED:
                    return '<span class="fa fa-circle text-red"></span> Closed';
                    break;
                default:
                    return '<span class="fa fa-circle text-gray"></span> Open';
                    break;
            }

    		if($status == self::_OPEN){
                
            }
    	}

        public function _task_detail($task_id){
            $user_id      = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id
            ], $this->TableFieldService->Task, $this->TableService->Task);

            if(!empty($task)){
                $task['customer'] = $this->UserService->_codename_by_id($task['codename_id']);
                $task['addr']     = $this->UserService->_addr_detail($task['cust_id']);
                $task['detail']   = $this->DatabaseModel->readOneWithOptions(['user_id' => $task['cust_id']], 'company_code, branch_code', $this->TableService->Customer);
                $task['creator']  = $this->UserService->_employee_detail($task['createdby_id']);
                $task['assigned'] = $this->OP_TaskManagerService->getAssignedTo($task['id']);
                $task['internal_comment'] = $this->OP_TaskManagerService->getComment($task_id, 1);
                $task['modified_by']      = $this->OP_TaskManagerService->getUserDetail($task['modifiedby_id']);

                if(!empty($task['assigned'])){
                    $task['is_assigned'] = false;
                    foreach ($task['assigned'] as $row) {
                        if($row['user_id'] == $user_id){
                            $task['is_assigned'] = true;
                        }
                    }
                }
            }

            return $task;
        }

        public function _task_full_details($task){
            if(!empty($task)){
                foreach ($task as $k => $val) {
                    $assignedEmp = "";

                    $task[$k]['customer']     = $this->UserService->_codename_by_id($val['codename_id']);
                    $task[$k]['creator']      = $this->OP_TaskService->getUserDetail($val['createdby_id']);
                    $task[$k]['assigned']     = $this->OP_TaskService->getAssignedTo($val['id']);

                    if(!empty($task[$k]['assigned'])){
                        $assignedEmp = implode(', ', array_column(array_column($task[$k]['assigned'], 'employee'), 'username'));
                    }

                    $task[$k]['assigned_employee'] = $assignedEmp;
                    $task[$k]['category']     = isset($val['taskcategory_id']) ? $this->TaskService->_category_detail($val['taskcategory_id']) : [];
                    $task[$k]['sub_category'] = isset($val['task_subcategory_id']) ? $this->TaskService->_sub_category_detail($val['task_subcategory_id']) : [];
                    $task[$k]['duration']     = $this->_calculate_task_duration($val);
                }
            }
            return $task;
        }

        public function _task_single_full_details($task){
            $otherData = [];
            if(!empty($task)){
                $task['modified_date'] = sysDatetimeFormat($task['modified_date']);
                $attndDuration = $this->_calculate_task_duration($task);
                $assigned = $this->OP_TaskService->getAssignedTo($task['id']);
                $assignedEmp = "";

                if(!empty($assigned)){
                    $assignedEmp = implode(', ', array_column(array_column($assigned, 'employee'), 'username'));
                }

                $otherData = [
                    'customer'     => $this->UserService->_codename_by_id($task['codename_id']),
                    'creator'      => $this->OP_TaskService->getUserDetail($task['createdby_id']),
                    'assigned'     => $assigned,
                    'assigned_employee' => $assignedEmp,
                    'category'     => isset($task['taskcategory_id']) ? $this->TaskService->_category_detail($task['taskcategory_id']) : [],
                    'sub_category' => isset($task['task_subcategory_id']) ? $this->TaskService->_sub_category_detail($task['task_subcategory_id']) : [],
                    'duration'     => $attndDuration,
                    'attnd_hours'  => round($attndDuration/60, 2).' H',
                    'status_label' => TaskService::_STATUS[$task['status']],
                    'status_color' => TaskService::_STATUS_COLOR[$task['status']],
                ];
            }
            return !empty($task) ? array_merge($task, $otherData) : [];
        }

        public function _calculate_task_duration($task){
            $duration = 0;
            if($task['status'] == TaskService::_COMPLETED){
                $currentDate    = $task['completed_date'];
                $duration       = getDays($task['created_date'], $currentDate);
            } else {
                if($task['status'] != TaskService::_CLOSED){
                    $currentDate    = getCurrentTimeStamp();
                    $duration       = getDays($task['created_date'], $currentDate);
                }
            }
            
            $this->DatabaseModel->updateData(['id' => $task['id']], ['duration' => $duration], $this->TableService->Task);
            return $duration;
        }

        public function getTaskListing($tasks){
            if(!empty($tasks)){
                foreach ($tasks as $k => $val) {
                    $task[$k] = $val;
                    $task[$k]['customer']     = $this->UserService->_company_codename_detail('company', $val['codename_id']);
                    $task[$k]['creator']      = $this->OP_TaskService->getUserDetail($val['createdby_id']);
                    $task[$k]['assigned']     = $this->OP_TaskService->getAssignedTo($val['id']);
                    $task[$k]['category']     = isset($val['taskcategory_id']) ? $this->TaskService->_category_detail($val['taskcategory_id']) : [];
                    $task[$k]['sub_category'] = isset($val['task_subcategory_id']) ? $this->TaskService->_sub_category_detail($val['task_subcategory_id']) : [];
                }
            }
            return isset($task) ? $task : [];
        }

    /* START :: JOBSHEET RELATED */
        public function _comment_detail($comment_id){
            $comment = $this->DatabaseModel->readOneWithOptions(['id' => $comment_id
            ], 'js_id, refer_to, jobsheet_type, task_id, commentby_id, comment_type, comment, created_date, modified_date, is_edited, taskattnd_id, is_verified, internal_verify', $this->TableService->TaskComment);

            if(!empty($comment)){
                $comment['attnd'] = $this->getAttndDetail($comment['taskattnd_id']);
                $comment['by']    = $this->UserService->_employee_detail($comment['commentby_id']);
            }

            return $comment;
        }

        public function _lst_rate(){
            $rates = $this->DatabaseModel->readArrayOrderBy('id, min_duration, max_duration, special_charge, default_charge', 'min_duration ASC', $this->TableService->lst_Rate);
            if(!empty($rates)){
                foreach ($rates as $k => $val) {
                    $min_hour = explode(':', $val['min_duration']);
                    $max_hour = explode(':', $val['max_duration']);

                    $min_h    = $min_hour[0] > 0 ? (int)$min_hour[0].'H '.(int)$min_hour[1].'MIN' : (int)$min_hour[1].'MIN';
                    $max_h    = $max_hour[0] > 0 ? (int)$max_hour[0].'H '.(int)$max_hour[1].'MIN' : (int)$max_hour[1].'MIN';

                    $rate[$k] = $val;
                    $rate[$k]['duration'] = $min_h.' - '.$max_h;
                }
            }

            return isset($rate) ? $rate : [];
        }

        public function _all_jobsheet(){
            $jobsheets = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Jobsheet, 'created_date DESC', $this->TableService->Jobsheet);

            if(!empty($jobsheets)){
                foreach ($jobsheets as $k => $val) {
                    $js[$k]                  = $val;
                    $js[$k]['task']          = $this->_task_detail($val['task_id']);
                    $js[$k]['charges']       = $this->_charges_by_comment($val['id']);
                    $js[$k]['other_charges'] = $this->_other_charges_detail($val['id']);
                }
            }

            return isset($js) ? $js : [];
        }

        public function _jobsheet_detail($js_id){
            $js = $this->DatabaseModel->readOneWithOptions(['id' => $js_id], $this->TableFieldService->Jobsheet, $this->TableService->Jobsheet);

            if(!empty($js)){
                $js['task']          = $this->_task_detail($js['task_id']);
                $js['charges']       = $this->_charges_by_comment($js['id']);
                $js['other_charges'] = $this->_other_charges_detail($js['id']);
            }

            return $js;
        }

        public function _charges_by_comment($js_id){
            return $this->DatabaseModel->readArrayWithOptions(['js_id' => $js_id], $this->TableFieldService->JsCharge, $this->TableService->JsCharge);
        }

        public function _other_charges_detail($js_id){
            return $this->DatabaseModel->readOneWithOptions(
                ['js_id' => $js_id], 
                'id, task_id, commentby_id, charge_id, service, mileage, mileage_charge, toll, parking, delivery, delivery_charge, created_date, modified_date, is_edited, internal_verify',
                $this->TableService->JsOtherCharge
            );
        }

    /* START :: ASSIGNED TASK & DETAIL */
        # all assigned task WITHOUT date filtration
        public function _all_assigned_task($user_id){
            $assignedArr  = $this->DatabaseModel->readArrayWithOptions(['user_id' => $user_id], $this->TableFieldService->TaskAssign, $this->TableService->TaskAssign);
            if(!empty($assignedArr)){
                foreach ($assignedArr as $k => $val) {
                    $assigned[$k] = $val;
                    $assigned[$k]['task'] = $this->_simple_task_detail($val['task_id']);
                }
            }
            return isset($assigned) ? $assigned : [];
        }

        # all assigned task WITH date filtration
        public function _assigned_task($user_id){
            $new_assigned = [];
            $assignedArr  = $this->DatabaseModel->readArrayWithOptions(['user_id' => $user_id], $this->TableFieldService->TaskAssign, $this->TableService->TaskAssign);
            if(!empty($assignedArr)){
                foreach ($assignedArr as $k => $val) {
                    $assigned[$k] = $val;
                    $assigned[$k]['task'] = $this->_simple_task_detail($val['task_id']);
                }
                foreach ($assigned as $k => $val) {
                    if($val['task']['planned_date'] === currentDate() || $val['task']['planned_date'] > currentDate()){
                        $new_assigned[] = $val;
                    }
                }
            }
            return isset($new_assigned) ? $new_assigned : [];
        }

        public function _assigned_site_task($user_id){
            $assigned    = [];
            $assignedArr = $this->_assigned_task($user_id);
            if(!empty($assignedArr)){
                foreach ($assignedArr as $k => $val) {
                    if($val['task']['taskcategory_id'] == self::_TASK_CUSTOMER){
                        $assigned[] = $val;
                    }
                }
            }
            return $assigned;
        }

        public function _simple_task_detail($task_id){
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], $this->TableFieldService->Task, $this->TableService->Task);
            if(!empty($task)){
                $task['cust']           = $this->UserService->_codename_by_id($task['codename_id']);
                $task['category']       = $this->_category_detail($task['taskcategory_id']);
                $task['sub_category']   = $this->_sub_category_detail($task['task_subcategory_id']);
            }
            return $task;
        }

        public function _assigned_smarter_task($user_id){
            $assigned    = [];
            $assignedArr = $this->_assigned_task($user_id);
            if(!empty($assignedArr)){
                foreach ($assignedArr as $k => $val) {
                    if($val['task']['taskcategory_id'] == self::_TASK_SMARTER){
                        $assigned[] = $val;
                    }
                }
            }
            return $assigned;
        }

        public function _smarter_task_detail($smarter_task_id){
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $smarter_task_id], $this->TableFieldService->SmarterTask, $this->TableService->SmarterTask);
            if(!empty($task)){
                $task['cust'] = $this->UserService->_codename_by_id($task['codename_id']);
            }
            return $task;
        }

        public function _smarter_assigned($smarter_task_id){
            return $this->DatabaseModel->readArrayWithOptions(['smarter_task_id' => $smarter_task_id], $this->TableFieldService->SmarterTaskAssign, $this->TableService->SmarterTaskAssign);
        }

        public function _category_detail($taskcategory_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $taskcategory_id], $this->TableFieldService->TaskCat, $this->TableService->TaskCat);
        }

        public function _sub_category_detail($task_subcategory_id=null){
            return $this->DatabaseModel->readOneWithOptions(['id' => $task_subcategory_id], $this->TableFieldService->TaskSubCat, $this->TableService->TaskSubCat);
        }

        public function _linked_task($request_id=null){
            $linkedArr = $this->DatabaseModel->readArrayWithOptions(['request_id' => $request_id], $this->TableFieldService->OTRequestTaskLinked, $this->TableService->OTRequestTaskLinked);
            if(!empty($linkedArr)){
                foreach ($linkedArr as $k => $val) {
                    $linked[$k] = $val;
                    $linked[$k]['task'] = $this->_simple_task_detail($val['task_id']);
                    /*if($val['task_type'] === 'site'){
                        $linked[$k]['task'] = $this->TaskService->_simple_task_detail($val['task_id']);
                    } else {
                        $linked[$k]['task'] = $this->TaskService->_smarter_task_detail($val['task_id']);
                    }*/
                }
            }
            return isset($linked) ? $linked : [];
        }

        public function _linked_ot_attnd($request_id=null){
            return $this->DatabaseModel->readOneWithOptions(['request_id' => $request_id
            ], 'checkin, checkout, location_type_in, location_type_out, remark_in, remark_out, location_in, location_out', 'Attnd_OT');
        }

        public function _get_task_data_for_email($task_id=null, $createdby_id=null){
            $sql = 'SELECT ticket_id, codename_id, title, description, planned_date FROM Task WHERE Task.id = '.$task_id;
            $taskDetails  = $this->DatabaseModel->readOneQuery($sql);
            $codenameData = $this->UserService->_codename_by_id($taskDetails['codename_id']);
            $createdBy    = $this->DatabaseModel->readOneWithOptions(['user_id' => $createdby_id], 'code_name', 'Employee');

            $sql = 'SELECT Employee.code_name FROM TaskAssigned
                    LEFT JOIN Employee ON Employee.user_id = TaskAssigned.user_id
                    WHERE TaskAssigned.task_id = '.$task_id;
            $assignedStaff = $this->DatabaseModel->readArrayQuery($sql);

            $emailData = [
                'ticket_no'     => $taskDetails['ticket_id'],
                'company_name'  => !empty($codenameData) ? $codenameData['company']['company_name'] : '',
                'title'         => $taskDetails['title'],
                'description'   => $taskDetails['description'],
                'planned_date'  => sysDateFormat($taskDetails['planned_date']),
                'created_by'    => $createdBy['code_name'],
                'img_url'       => base_url('assets/images/icons/task-icon.png'),
                'assigned'      => !empty($assignedStaff) ? implode(", ", array_column($assignedStaff, 'code_name')) : null
            ];

            return $emailData;
        }

    /******************
    * PRIVATE FUNCTION
    ******************/

    private function getAttndDetail($attnd_id){
        $attnd = $this->DatabaseModel->readOneWithOptions(['id' => $attnd_id], 'check_in, check_out, date', $this->TableService->TaskAttnd);
        if(!empty($attnd)){
            /*$StartTime  = date('h:i:s', strtotime($attnd['check_in']));
            $EndTime    = date('h:i:s', strtotime($attnd['check_out']));*/

            $start_time = new DateTime($attnd['check_in']);
            $end_time   = new DateTime($attnd['check_out']);
            $duration   = $start_time->diff($end_time);

            /*$start_time = strtotime($attnd['check_in']);
            $end_time   = strtotime($attnd['check_out']);
            $duration   = $end_time - $start_time;*/

            /*echo $attnd['check_in'].'<br>';
            echo $attnd['check_out'].'<br>';
            print_array($duration); exit();*/

            $attnd['duration'] = $duration->h.' H'.' '.$duration->i.' MIN';
            //$attnd['duration'] = $duration;
        }
        return $attnd;
    }
}