<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class TaskMainService extends MY_Service {

    private $Services = [
        'UserService' => 'UserService',
        'task/TaskService'                      => 'TaskService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/CommentService'                   => 'CommentService',
        'task/JobsheetService'                  => 'JobsheetService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: DEFAULT */
        public function _only_own_task($task, $user_id){
            $taskArr = [];
            if(!empty($task)){
                foreach ($task as $k => $val) {
                    if(!empty($val['assigned'])){
                        foreach ($val['assigned'] as $assigned) {
                            if($assigned['user_id'] == $user_id){
                                $taskArr[] = $val;
                                continue;
                            }
                        }
                    }
                }
            }
            return $taskArr;
        }

        public function _only_own_company_task_all($task, $user_id, $company_id){
            $company_codename = $this->UserService->_company_codename_detail('company', $company_id);
            $codename_id      = !empty($company_codename) ? $company_codename['id'] : null;

            $taskArr = [];
            if(!empty($task)){
                foreach ($task as $k => $val) {
                    if($codename_id == $val['codename_id']){
                        $taskArr[] = $val;
                        continue;
                    }
                }
            }
            return $taskArr;
        }

        public function _only_own_company_task_individual($task, $user_id, $company_id){
            $company_codename = $this->UserService->_company_codename_detail('company', $company_id);
            $codename_id      = !empty($company_codename) ? $company_codename['id'] : null;
            $taskArr          = $this->_only_own_company_task_all($task, $user_id, $company_id);
            $taskArr          = $this->_only_own_task($taskArr, $user_id);
            return $taskArr;
        }

    /* START :: VERIFY */
        public function verify_selected($task_id, $data){
            $redirectUrl  = $data['prefixUrl'].'/view/'.$task_id;
            $comment_ids  = $this->input->post('js_id');
            $user_id      = $this->session->userLogged['id'];
            $comments     = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], $this->TableFieldService->Jobsheet, 'created_date ASC', $this->TableService->Jobsheet);

            // print_array($comment_ids); exit();

            if(!empty($comments)){
                $printData = [
                    'task_id'      => $task_id, 
                    'createdby_id' => $user_id, 
                    'created_date' => getDateToday()
                ];

                $isExist = $this->DatabaseModel->readOneWithOptions($printData, 'id', 'TaskTempPrint');
                if(!empty($isExist)){
                    $parentprint_id = $isExist['id'];
                    $this->DatabaseModel->deleteData(['taskprint_id' => $isExist['id']], 'TaskTempPrintComment');
                } else {
                    $parentprint_id = $this->DatabaseModel->createData($printData, 'TaskTempPrint');
                }

                foreach ($comments as $k => $val) {
                    if(!empty($comment_ids)){
                        if(in_array($val['id'], $comment_ids)){
                            $this->DatabaseModel->createData([
                                'taskprint_id' => $parentprint_id,
                                'comment_id'   => $val['id']
                            ], 'TaskTempPrintComment');
                            //$cmt[] = $val;
                        }
                    }
                }

                $redirectUrl = $data['prefixUrl'].'/verify-platform/'.$task_id.'?type='.JobsheetService::_CMT_JOBSHEET.'&print_id='.$parentprint_id;
            }
            echo $redirectUrl;
        }

        public function verify_platform($task_id, $data){
            $cmt            = [];
            $tempcomment_id = [];
            $comment_type   = $this->input->get('type');
            $print_id       = $this->input->get('print_id');
            $task           = $this->TaskService->_task_detail($task_id);

            if($comment_type){
                $comments = $this->JobsheetService->_jobsheet_by_task($task_id);
                if(!empty($comments)){
                    if($print_id){
                        # comment_id is the js_id
                        $tempComments = $this->DatabaseModel->readArrayWithOptions(['taskprint_id' => $print_id], 'id, comment_id', 'TaskTempPrintComment');
                        
                        if(!empty($tempComments)){
                            foreach ($tempComments as $k => $val) {
                                $tempcomment_id[] = $val['comment_id'];
                            }
                        }
                    }

                    foreach ($comments as $key => $val) {
                        if(!empty($tempcomment_id)){
                            if(in_array($val['id'], $tempcomment_id)){
                                $cmts[] = $val;
                            }
                        } else {
                            $cmts[] = $val;
                        }
                    }

                    if(isset($cmts)){
                        if(!empty($cmts)){
                            if($this->session->userLogged['role_id'] == UserService::_STAFF){
                                foreach ($cmts as $row) {
                                    if($row['commentby_id'] == $this->session->userLogged['id']){
                                        $cmt[] = $row;
                                    }
                                }
                            } else {
                                $cmt = $cmts;
                            }
                        } else {
                            $cmt = $cmts;
                        }
                    }
                }
            }

            // print_array($cmt); exit();

            $user_id = $this->session->userLogged['id'];
            $user    = $this->OP_TaskService->getEmployeeDetail($user_id);

            $TaskAttendance = $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id, 'user_id' => $user_id, 'date' => getDateToday()
            ], 'id, check_in, check_out', 'check_in DESC', $this->TableService->TaskAttnd);

            $cmtArr = [];
            if(!empty($cmt)){
                foreach ($cmt as $k => $val) {
                    // if($val['is_verified'] == 0){
                    //     $cmtArr[] = $val;
                    // }
                    $cmtArr[] = $val;
                }
            }

            return [
                'task'     => $task,
                'cmtArr'   => $cmtArr,
                'user'     => $user,
            ];
        }

}