<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class ManagerService extends MY_Service {
    private $data = array();

    const _OPEN             = 0;
    const _INPROGRESS       = 1;
    const _COMPLETED        = 2;
    const _CLOSED           = 3;

    const _CMT_INTERNAL     = 1;
    const _CMT_JOBSHEET     = 2;
    const _CMT_ALTLST       = 3;
    const _CMT_ALTLSTCHRG   = 4;
    const _CMT_CHRG         = 5;

    const _STATUS = ['Open', 'In Progress', 'Completed', 'Closed'];

    protected $tblTask          = 'Task';
    protected $tblTaskAttnd     = 'TaskAttendance';
    protected $tblAssign        = 'TaskAssigned';
    protected $tblComment       = 'TaskComments';
    protected $tblUser          = 'User';
    protected $tblCustomer      = 'Customer';
    protected $tblEmployee      = 'Employee';
    protected $tblTeam          = 'OptTeam';
    protected $tblDepartment    = 'OptDepartment';

    private static $root        = 'operation/task/';
    private static $prefix_url  = 'operation/task';

    private $Services = [
        'task/OP_TaskDeleteService' => 'OP_TaskDeleteService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        $this->data['root']      = self::$root;
        $this->data['prefixUrl'] = $this->prefixUrl = base_url(self::$prefix_url);
    }

    /* START :: MAIN */
    	public function index(){
            $task_type = $this->input->get('type');
            if($task_type){
                if($task_type === 'today'){
                    $operator = '=';
                } else if($task_type === 'previous'){
                    $operator = '<';
                } else {
                    $operator = '>';
                }
            } else {
                $operator = '=';
            }

            $sql = 'SELECT id, cust_id, pc_no, title, description, createdby_id, planned_date, created_date, modified_date, status
                    FROM Task WHERE status != '.TaskService::_CLOSED.' AND planned_date '.$operator.' "'.getDateToday().'" ORDER BY planned_date ASC';

            $tasks = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($tasks)){
                if($task_type === 'previous' || $this->uri->segment(3) === 'history'){
                    usort($tasks, function($a, $b){ return $a['planned_date'] < $b['planned_date']; });
                }
            }

            $task      = $this->getTaskListing($tasks);
            $customers = $this->DatabaseModel->readArrayOrderBy('id, user_id, code_name', 'code_name ASC', $this->tblCustomer);

            if(isset($_POST['delete_task'])){
                $this->OP_TaskDeleteService->deleteTask($this->input->post('task_id'));
                $this->session->set_flashdata('success_msg', deleteMsg());
                redirect(current_url());
            }

            if(isset($_POST['get_task'])){
                print_array($this->input->get()); exit();
            }
            
            $this->data['task']      = $task;
            $this->data['customers'] = $customers;
            $this->load->views(self::$root.'manager/list.tpl.php', $this->data);
        }

        public function getFilteredTask(){
            $customer_id = $this->input->post('customer_id');
            $title       = $this->input->post('title');
            $view        = $this->input->get('view');
            $task_type   = $this->input->post('task_type');

            $operator = !empty($view) ? '= ' : '!= ' ;

            if($task_type){
                if($task_type === 'today'){
                    $dateOperator = '=';
                } else if($task_type === 'previous'){
                    $dateOperator = '<';
                } else {
                    $dateOperator = '>';
                }
            } else {
                $dateOperator = '=';
            }

            $sql = 'SELECT id, cust_id, title, createdby_id, planned_date, created_date, modified_date, status FROM Task';
            $sql .= ' WHERE status '.$operator.TaskService::_CLOSED;

            if(!empty($customer_id) && empty($title)){
                $sql .= ' AND cust_id = '.$customer_id;
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && !empty($title)) {
                $sql .= ' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && empty($title)){
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }
            else {
                $sql .= ' AND cust_id = '.$customer_id.' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }

            $tasks = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($tasks)){
                if($task_type === 'previous' || !empty($view)){
                    usort($tasks, function($a, $b){ return $a['planned_date'] < $b['planned_date']; });
                }
            }

            $task = $this->getTaskListing($tasks);
            
            $this->data['task'] = isset($task) ? $task : null;
            $this->load->view(self::$root.'manager/ajax/ajx-task-list.tpl.php', $this->data);
        }

        public function history(){
            $sql = 'SELECT id, cust_id, pc_no, title, description, createdby_id, planned_date, created_date, modified_date, status
                    FROM Task WHERE status = '.TaskService::_CLOSED.' ORDER BY planned_date DESC';

            $tasks     = $this->DatabaseModel->readArrayQuery($sql);
            $task      = $this->getTaskListing($tasks);
            $customers = $this->DatabaseModel->readArrayOrderBy('id, user_id, code_name', 'code_name ASC', $this->tblCustomer);

            if(isset($_POST['delete_task'])){
                $this->OP_TaskDeleteService->deleteTask($this->input->post('task_id'));
                $this->session->set_flashdata('success_msg', deleteMsg());
                redirect(current_url());
            }
            
            $this->data['task']      = $task;
            $this->data['customers'] = $customers;
            $this->load->views(self::$root.'manager/list.tpl.php', $this->data);
        }

        public function getTaskListing($tasks){
            if(!empty($tasks)){
                foreach ($tasks as $k => $val) {
                    $task[$k] = $val;
                    $task[$k]['customer'] = $this->getCustomerDetail($val['cust_id']);
                    $task[$k]['creator']  = $this->getUserDetail($val['createdby_id']);
                    $task[$k]['assigned'] = $this->getAssignedTo($val['id']);
                }
            }
            return isset($task) ? $task : null;
        }

    /* START :: VIEW */
        public function view($task_id){
            $user_id        = $this->session->userLogged['id'];
            $hasSignedIn    = $this->checkHasSignedIn($task_id, $user_id);
            $task           = $this->getTaskDetail($task_id);

            $taskAttnd      = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, user_id, check_in, check_out, date', 'date DESC', $this->tblTaskAttnd);

            $comments       = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, jobsheet_type, commentby_id, comment_type, comment, created_date, modified_date, is_edited', 'created_date ASC', $this->tblComment);
            //$department = $this->DatabaseModel->readArrayOrderBy('id, title, code_name', 'title ASC', $this->tblDepartment);

            if(!empty($taskAttnd)){
                foreach ($taskAttnd as $k => $val) {
                    $attnd[$k] = $val;
                    $attnd[$k]['employee'] = $this->getEmployeeDetail($val['user_id']);
                }
            }

            $user = $this->ManagerService->getEmployeeDetail($user_id);
            if(!empty($user)){
                $user['department'] = $this->ManagerService->getDepartmentDetail($user['department_id']);
                $team = $this->getTeams($user['department_id']);
            }

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['employee'] = $this->getEmployeeDetail($val['commentby_id']);
                }
            }

            if(!empty($hasSignedIn)){
                if(!isEmptyTimestamp($hasSignedIn['check_in'])){
                    $hasCheckedIn = true;
                } else {
                    $hasCheckedIn = false;
                }
            } else {
                $hasCheckedIn = false;
            }

            $this->viewTaskActions($task_id, $user_id);

            $this->data['task']         = $task;
            $this->data['user']         = $user;
            $this->data['attnd']        = isset($attnd) ? $attnd : null;
            $this->data['comment']      = isset($comment) ? $comment : null;
            //$this->data['department'] = $department;
            $this->data['team']         = isset($team) ? $team : null;
            $this->data['hasSignedIn']  = $hasSignedIn;
            $this->data['hasCheckedIn'] = $hasCheckedIn;    // :: to enable commenting. as long as there has task signed in and commenting will be enabled
            $this->load->views(self::$root.'manager/view.tpl.php', $this->data);
        }

        public function update_jobsheet_type($comment_id){
            $jobsheet_type = $this->input->get('jobsheet_type');
            $this->DatabaseModel->updateData(['id' => $comment_id], ['jobsheet_type' => $jobsheet_type], $this->tblComment);
        }

        private function viewTaskActions($task_id, $user_id){
            if(isset($_POST['complete'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_COMPLETED
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['progress'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_INPROGRESS
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['close'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_CLOSED
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect($this->prefixUrl.'/history/view/'.$task_id);
            }

            if(isset($_POST['submit_comment'])){
                $this->form_validation->set_rules('comment', 'Comment', 'trim|required');

                if($this->form_validation->run() == true){
                    $this->DatabaseModel->createData([
                        'task_id'       => $task_id,
                        'commentby_id'  => $user_id,
                        'comment_type'  => $this->input->post('comment_type'),
                        'comment'       => $this->input->post('comment'),
                        'created_date'  => getCurrentTimeStamp()
                    ], $this->tblComment);

                    $this->session->set_flashdata('success_msg', updateMsg());
                    redirect($this->input->post('tab_url'));
                }
            }

            if(isset($_POST['update_comment'])){
                $this->form_validation->set_rules('comment', 'Comment', 'trim|required');

                if($this->form_validation->run() == true){
                    $this->DatabaseModel->updateData(['id' => $this->input->post('comment_id')], [
                        'comment'       => $this->input->post('comment'),
                        'modified_date' => getCurrentTimeStamp(),
                        'is_edited'     => 1
                    ], $this->tblComment);

                    $this->session->set_flashdata('success_msg', updateMsg());
                    redirect($this->input->post('url'));
                }
            }

            if(isset($_POST['clear_all_comment'])){
                $comment_type = $this->input->post('comment_type');
                $this->DatabaseModel->deleteData(['task_id' => $task_id, 'comment_type' => $comment_type], $this->tblComment);
                $this->session->set_flashdata('success_msg', deleteMsg());
                redirect($this->input->post('tab_url'));
            }

            if(isset($_POST['delete_comment'])){
                $comment_id = $this->input->post('delete_comment');
                $this->DatabaseModel->deleteData(['id' => $comment_id], $this->tblComment);
                $this->session->set_flashdata('success_msg', deleteMsg());
                redirect($this->input->post('tab_url'));
            }
        }

        public function print_selected($task_id=null){
            $redirectUrl  = $this->prefixUrl.'/view/'.$task_id;
            $comment_type = $this->input->post('comment_type');
            $comment_ids  = $this->input->post('comment_id');
            $user_id      = $this->session->userLogged['id'];
            $comments     = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, jobsheet_type, commentby_id, comment_type, comment, created_date, modified_date, is_edited', 'created_date ASC', $this->tblComment);

            // print_array($comment_ids); exit();

            if(!empty($comments) && $comment_type){
                $printData = [
                    'task_id'      => $task_id, 
                    'createdby_id' => $user_id, 
                    'created_date' => getDateToday()
                ];

                $isExist = $this->DatabaseModel->readOneWithOptions($printData, 'id', 'TaskTempPrint');
                if(!empty($isExist)){
                    $parentprint_id = $isExist['id'];
                    $this->DatabaseModel->deleteData(['taskprint_id' => $isExist['id']], 'TaskTempPrintComment');
                } else {
                    $parentprint_id = $this->DatabaseModel->createData($printData, 'TaskTempPrint');
                }

                foreach ($comments as $k => $val) {
                    //print_array($val); exit();
                    if($val['comment_type'] == $comment_type){
                        if(!empty($comment_ids)){
                            if(in_array($val['id'], $comment_ids)){
                                $this->DatabaseModel->createData([
                                    'taskprint_id' => $parentprint_id,
                                    'comment_id'   => $val['id']
                                ], 'TaskTempPrintComment');
                                //$cmt[] = $val;
                            }
                        }
                    }
                }

                $redirectUrl = $this->prefixUrl.'/print_platform/'.$task_id.'?type='.$comment_type.'&print_id='.$parentprint_id;
            }
            echo $redirectUrl;
        }

        public function view_history($task_id){
            $task       = $this->getTaskDetail($task_id);
            $comments   = $this->getCommentsByTask($task_id);

            if(isset($_POST['open'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $this->session->userLogged['id'],
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_OPEN
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect($this->prefixUrl.'/view/'.$task_id);
            }

            /*if(isset($_POST['print_all'])){
                $comment_type = $this->input->post('comment_type');
                if(isset($comment) && $comment_type){
                    foreach ($comment as $k => $val) {
                        if($val['comment_type'] == $comment_type){
                            $cmt[] = $val;
                        }
                    }


                }
            }*/

            if(isset($_POST['print_selected'])){
                $comment_type = $this->input->post('comment_type');
                $comment_ids  = $this->input->post('comment_id');
                $user_id      = $this->session->userLogged['id'];
                //print_array($this->input->post()); exit();

                if(!empty($comments) && $comment_type){
                    $printData = [
                        'task_id'      => $task_id, 
                        'createdby_id' => $user_id, 
                        'created_date' => getDateToday()
                    ];

                    $isExist = $this->DatabaseModel->readOneWithOptions($printData, 'id', 'TaskTempPrint');
                    if(!empty($isExist)){
                        $parentprint_id = $isExist['id'];
                        $this->DatabaseModel->deleteData(['taskprint_id' => $isExist['id']], 'TaskTempPrintComment');
                    } else {
                        $parentprint_id = $this->DatabaseModel->createData($printData, 'TaskTempPrint');
                    }

                    foreach ($comments as $k => $val) {
                        //print_array($val); exit();
                        if($val['comment_type'] == $comment_type){
                            if(!empty($comment_ids)){
                                if(in_array($val['id'], $comment_ids)){
                                    $this->DatabaseModel->createData([
                                        'taskprint_id' => $parentprint_id,
                                        'comment_id'   => $val['id']
                                    ], 'TaskTempPrintComment');
                                    //$cmt[] = $val;
                                }
                            }
                        }
                    }

                    redirect($this->prefixUrl.'/print_platform/'.$task_id.'?type='.$comment_type.'&print_id='.$parentprint_id);
                }

                $this->data['task']     = $task;
                $this->data['comments'] = isset($cmt) ? $cmt : null;
                $this->load->view(self::$root.'manager/includes/closed-comments/print-platform.tpl.php', $this->data);
            }

            $this->data['task']     = $task;
            $this->data['comment']  = $comments;
            $this->load->views(self::$root.'manager/view-history.tpl.php', $this->data);
        }

        private function getCommentsByTask($task_id){
            $comments = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, jobsheet_type, commentby_id, comment_type, comment, created_date, modified_date, is_edited', 'created_date ASC', $this->tblComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['employee'] = $this->getEmployeeDetail($val['commentby_id']);
                }
            }

            return isset($comment) ? $comment : null;
        }

        public function print_platform($task_id){
            $cmt            = [];
            $tempcomment_id = [];
            $comment_type   = $this->input->get('type');
            $print_id       = $this->input->get('print_id');
            $task           = $this->getTaskDetail($task_id);

            if($comment_type){
                $comments = $this->getCommentsByTask($task_id);
                if(!empty($comments)){
                    if($print_id){
                        $tempComments = $this->DatabaseModel->readArrayWithOptions(['taskprint_id' => $print_id], 'id, comment_id', 'TaskTempPrintComment');
                        
                        if(!empty($tempComments)){
                            foreach ($tempComments as $k => $val) {
                                $tempcomment_id[] = $val['comment_id'];
                            }
                        }
                    }

                    foreach ($comments as $key => $val) {
                        if($val['comment_type'] == $comment_type){
                            if(!empty($tempcomment_id)){
                                if(in_array($val['id'], $tempcomment_id)){
                                    $cmt[] = $val;
                                }
                            } else {
                                $cmt[] = $val;
                            }
                        }
                    }
                }
            }

            $user_id = $this->session->userLogged['id'];
            $user    = $this->getEmployeeDetail($user_id);

            $TaskAttendance = $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id, 'user_id' => $user_id, 'date' => getDateToday()
            ], 'id, check_in, check_out', 'check_in DESC', $this->tblTaskAttnd);

            /*$this->data['task']     = $task;
            $this->data['comments'] = $cmt;*/
            

            /*$dompdf = new Dompdf\Dompdf();
            $html   = $this->load->view(self::$root.'manager/includes/closed-comments/print-platform.tpl.php', $this->data, true);
            $dompdf->loadHtml($html);
            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();
            $dompdf->stream();
            exit();*/
            //$dompdf->output();

            /*$dompdf = new Dompdf\Dompdf();
            $html = $this->load->view('dashboard/essays/pdf-outline.tpl.php', $this->data, true);
            $dompdf->loadHtml($html);
            $dompdf->render();

            $pdf        = $dompdf->output();
            $pdfName    = uniqid().'.pdf';
            
            $upload_path = ESSAY_DIR.'/pdf/'.$pdfName;

            if(file_put_contents($upload_path, $pdf)){
                $this->updateEssayFiles($essay_id, $pdfName);
            }*/

            $this->data['task']     = $task;
            $this->data['comments'] = $cmt;
            $this->data['user']     = $user;
            $this->load->view(self::$root.'manager/includes/closed-comments/print-platform.tpl.php', $this->data);
        }

        public function getTaskDetail($task_id){
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'id, cust_id, requested_by, pc_no, title, description, requested_by, createdby_id, modifiedby_id, planned_date, created_date, modified_date, status', $this->tblTask);

            if(!empty($task)){
                $task['customer'] = $this->getCustomerDetail($task['cust_id']);
                $task['addr']     = $this->getUserAddr($task['cust_id']);
                $task['detail']   = $this->DatabaseModel->readOneWithOptions(['user_id' => $task['cust_id']], 'company_code, branch_code', $this->tblCustomer);
                $task['creator']  = $this->getUserDetail($task['createdby_id']);
                $task['assigned'] = $this->getAssignedTo($task['id']);
                $task['internal_comment'] = $this->getComment($task_id, 1);
                $task['modified_by']      = $this->getUserDetail($task['modifiedby_id']);

                if(!empty($task['assigned'])){
                    $task['is_assigned'] = false;
                    foreach ($task['assigned'] as $row) {
                        if($row['user_id'] == $this->session->userLogged['id']){
                            $task['is_assigned'] = true;
                        }
                    }
                }
            }

            return $task;
        }

    /* START :: TASK */
        public function startTask($task_id){
            $user_id     = $this->session->userLogged['id'];
            $hasSignedIn = $this->checkHasSignedIn($task_id, $user_id);

            if(empty($hasSignedIn)){
                $this->checkinTask($task_id, $user_id);
                echo true;
            } else {
                if(!isEmptyTimestamp($hasSignedIn['check_in']) && !isEmptyTimestamp($hasSignedIn['check_out'])){
                    // :: both check in and out done. need to start a new session.
                    $this->checkinTask($task_id, $user_id);
                    echo true;
                } else {
                    echo false;
                }
            }
        }

        private function checkinTask($task_id, $user_id){
            $this->DatabaseModel->createData([
                'task_id'   => $task_id,
                'user_id'   => $user_id,
                'check_in'  => getCurrentTimeStamp(),
                'date'      => getDateToday()
            ], $this->tblTaskAttnd);

            $taskAttnd = $this->DatabaseModel->readArrayWithOptions(['task_id' => $task_id], 'id', $this->tblTaskAttnd);
            if(!empty($taskAttnd)){
                /* :: task is already in progress */
                $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'status', $this->tblTask);
                if(!empty($task)){
                    if($task['status'] == TaskService::_COMPLETED){
                        // :: do nothing
                    } else if ($task['status'] == TaskService::_CLOSED) {
                        // :: do nothing
                    } else {
                        $this->DatabaseModel->updateData(['id' => $task_id], [
                            'status' => TaskService::_INPROGRESS
                        ], $this->tblTask);
                    }
                }
            }
        }

        public function endTask($task_id){
            $user_id     = $this->session->userLogged['id'];
            $hasSignedIn = $this->checkHasSignedIn($task_id, $user_id);

            if(!empty($hasSignedIn)){
                if(isEmptyTimestamp($hasSignedIn['check_out'])){
                    // :: if check out is empty, need to sign out
                    $this->DatabaseModel->updateData(['id' => $hasSignedIn['id']], [
                        'check_out'  => getCurrentTimeStamp()
                    ], $this->tblTaskAttnd);

                    echo true;
                } else {
                    // :: already check out, need to start a new task session
                    echo false;
                }
            } else {
                // :: hasn't check in yet, need to start a new session
                echo false;
            }
        }

        public function checkHasSignedIn($task_id, $user_id){
            return $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id, 'user_id' => $user_id, 'date' => getDateToday()
            ], 'id, check_in, check_out', 'id DESC', $this->tblTaskAttnd);
        }

    /* START :: ASSIGN TASK */
        public function assignTask($task_id){
            $this->form_validation->set_rules('team_id', 'Team', 'trim|required');
            $this->form_validation->set_rules('user_id[]', 'Assign To', 'trim|required');

            if($this->form_validation->run() == true){
                $this->AssignTaskAction($task_id);
                echo json_encode(['status' => true, 'redirect' => $this->prefixUrl.'/view/'.$task_id]);
            } else {
                $this->FormService->returnFormError($this->form_validation->error_array());
            }
        }

        public function checkHasTeam($department_id){
            $team = $this->getTeams($department_id);
            echo !empty($team) ? true : false;
        }

        public function getTeamsByDepartment($department_id){
            $team = $this->getTeams($department_id);

            $this->data['res']   = 'get-team';
            $this->data['team'] = isset($team) ? $team : null;
            $this->load->view(self::$root.'manager/includes/modal-ajax.tpl.php', $this->data);
        }

        public function getEmployeeByDepartment($department_id=null){
            $task_id = $this->input->get('task_id');

            $sql = 'SELECT User.id, is_active, code_name FROM Employee 
                    LEFT JOIN User ON User.id = Employee.user_id
                    WHERE is_active = 1 AND department_id = '.$department_id.' ORDER BY code_name ASC';
            $employees = $this->DatabaseModel->readArrayQuery($sql);

            if($task_id){
                if(!empty($employees)){
                    foreach ($employees as $k => $val) {
                        $hasAssigned = $this->DatabaseModel->readOneWithOptions(['task_id' => $task_id, 'user_id' => $val['id']
                        ], 'id', $this->tblAssign);

                        if(empty($hasAssigned)){
                            $employee[$k] = $val;
                        }
                    }
                }
            }

            $this->data['res']      = 'get-staff';
            $this->data['employee'] = isset($employee) ? $employee : null;
            $this->load->view(self::$root.'manager/includes/modal-ajax.tpl.php', $this->data);
        }

        public function getEmployeeByTeam($team_id=null){
            $task_id = $this->input->get('task_id');

            if($task_id){
                $sql = $this->filterTeamQuery($team_id);
                $employees = $this->DatabaseModel->readArrayQuery($sql);
                
                if(!empty($employees)){
                    foreach ($employees as $k => $val) {
                        $hasAssigned = $this->DatabaseModel->readOneWithOptions(['task_id' => $task_id, 'user_id' => $val['id']
                        ], 'id', $this->tblAssign);

                        if(empty($hasAssigned)){
                            $employee[] = $val;
                        }
                    }
                }
            }

            /*$this->data['res']      = 'get-staff';
            $this->data['employee'] = isset($employee) ? $employee : null;
            $this->load->view(self::$root.'manager/includes/modal-ajax.tpl.php', $this->data);*/

            if(isset($employee) && !empty($employee)){
                foreach ($employee as $row) {
                    echo '<option value="'.$row['id'].'">'.$row['code_name'].'</option>';
                }
            }
        }

        public function removeAssigned($assign_id){
            $this->DatabaseModel->deleteData(['id' => $assign_id], $this->tblAssign);
        }

        public function filterTeamQuery($team_id){
            return 'SELECT User.id, is_active, code_name FROM Employee 
                    LEFT JOIN User ON User.id = Employee.user_id
                    WHERE is_active = 1 AND team_id = '.$team_id.'
                    AND role_id IN('.UserService::_STAFF.', '.UserService::_MANAGER.') ORDER BY code_name ASC';
        }

        public function AssignTaskAction($task_id){
            $user_ids = $this->input->post('user_id');
            if(!empty($user_ids)){
                foreach ($user_ids as $user_id) {
                    $hasAssigned = $this->DatabaseModel->readOneWithOptions(['task_id' => $task_id, 'user_id' => $user_id
                    ], 'id', $this->tblAssign);

                    if(empty($hasAssigned)){
                        $this->DatabaseModel->createData([
                            'task_id' => $task_id,
                            'user_id' => $user_id
                        ], $this->tblAssign);
                    }
                }
            }
        }

    /* START :: CREATE */
        public function create(){
            $user_id = $this->session->userLogged['id'];

            $customer = $this->DatabaseModel->readArray('user_id, company_name, code_name', $this->tblCustomer);
            $user     = $this->ManagerService->getEmployeeDetail($user_id);
            if(!empty($user)){
                $user['department'] = $this->ManagerService->getDepartmentDetail($user['department_id']);
                $team = $this->getTeams($user['department_id']);
            }

            $this->data['customer'] = $customer;
            $this->data['user']     = $user;
            $this->data['team']     = isset($team) ? $team : null;
            $this->load->views(self::$root.'manager/create.tpl.php', $this->data);
        }

        public function getEmpByTeam($team_id){
            $sql = $this->filterTeamQuery($team_id);
            $employees = $this->DatabaseModel->readArrayQuery($sql);

            //$this->data['res']      = 'get-staff';
            // $this->data['employee'] = $employees;
            // $this->load->view(self::$root.'manager/ajax/ajx-assign-task.tpl.php', $this->data);

            if(!empty($employees)){
                foreach ($employees as $row) {
                    echo '<option value="'.$row['id'].'">'.$row['code_name'].'</option>';
                }
            }
        }

        public function createTask(){
            $this->form_validation
                ->set_rules('cust_id', 'Customer Name', 'trim|required')
                ->set_rules('requested_by', 'Requested By', 'trim|required')
                ->set_rules('pc_no', 'Device ID', 'trim|required')
                ->set_rules('title', 'Title', 'trim|required')
                ->set_rules('description', 'Description', 'trim|required')
                ->set_rules('planned_date', 'Plan Date', 'trim|required')
                ->set_rules('team_id', 'Team', 'trim|required')
                ->set_rules('user_id[]', 'Assign To', 'trim|required');

            if($this->form_validation->run() == true){
                $taskData = [
                    'cust_id'       => $this->input->post('cust_id'),
                    'requested_by'  => $this->input->post('requested_by'),
                    'pc_no'         => $this->input->post('pc_no'),
                    'title'         => $this->input->post('title'),
                    'description'   => $this->input->post('description'),
                    'createdby_id'  => $this->session->userLogged['id'],
                    'planned_date'  => date('Y-m-d', strtotime($this->input->post('planned_date'))),
                    'created_date'  => getCurrentTimeStamp()
                ];

                $task_id = $this->DatabaseModel->createData($taskData, $this->tblTask);
                if(!empty($task_id)){
                    $this->AssignTaskAction($task_id);
                }
                echo json_encode(['status' => true, 'redirect' => $this->prefixUrl]);
            } else {
                $this->FormService->returnFormError($this->form_validation->error_array());
            }
        }

    /* START :: EDIT */
        public function edit($task_id=null){
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'cust_id, requested_by, pc_no, title, description, planned_date', $this->tblTask);
            if(!empty($task)){
                $task['customer'] = $this->getCustomerDetail($task['cust_id']);
            }

            /*if(isset($_POST['submit'])){
                $this->updateTask();
            }*/

            $this->data['task'] = $task;
            $this->load->views(self::$root.'manager/edit.tpl.php', $this->data);
        }

        public function updateTask($task_id=null){
            $this->form_validation
                ->set_rules('requested_by', 'Requested By', 'trim|required')
                ->set_rules('pc_no', 'Device ID', 'trim|required')
                ->set_rules('title', 'Title', 'trim|required')
                ->set_rules('description', 'Description', 'trim|required')
                ->set_rules('planned_date', 'Plan Date', 'trim|required');

            if($this->form_validation->run() == true){
                $taskData = [
                    'requested_by'  => $this->input->post('requested_by'),
                    'pc_no'         => $this->input->post('pc_no'),
                    'title'         => $this->input->post('title'),
                    'description'   => $this->input->post('description'),
                    'modifiedby_id' => $this->session->userLogged['id'],
                    'planned_date'  => date('Y-m-d', strtotime($this->input->post('planned_date'))),
                    'modified_date' => getCurrentTimeStamp()
                ];

                $this->DatabaseModel->updateData(['id' => $task_id], $taskData, $this->tblTask);
                echo json_encode(['status' => true, 'redirect' => $this->prefixUrl.'/view/'.$task_id]);
            } else {
                $this->FormService->returnFormError($this->form_validation->error_array());
            }
        }

    /* START :: OTHERS */
        public function getTeams($department_id){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id
            ], 'id, title', 'title ASC', $this->tblTeam);
        }

        public function getCustomerDetail($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'company_name, code_name, phone_no', $this->tblCustomer);
        }

        public function getEmployeeDetail($user_id){
            $sql = 'SELECT User.id, role_id, fullname, code_name, department_id, team_id FROM Employee
                    LEFT JOIN User ON User.id = Employee.user_id
                    WHERE User.id = '.$user_id;
            $employee = $this->DatabaseModel->readOneQuery($sql);

            if(!empty($employee)){
                $employee['team'] = $this->getTeamDetail($employee['team_id']);
                if(!empty($employee['team'])){
                    if($employee['role_id'] == UserService::_STAFF)
                    {
                        $employee['position'] = $employee['team']['title'];
                    } else {
                        $employee['position'] = $employee['team']['title'].' '.UserService::_ROLE[$employee['role_id']];
                    }
                } else {
                    $employee['position'] = null;
                }
            }
            return $employee;
        }

        public function getDepartmentDetail($department_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $department_id], 'title', $this->tblDepartment);
        }

        public function getTeamDetail($team_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $team_id], 'title', $this->tblTeam);
        }

        public function getUserAddr($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id
            ], 'addr_line1, addr_line2, postcode, city, state, country', 'UserAddr');
        }

        public function getUserDetail($user_id){
            $acc = $this->DatabaseModel->readOneWithOptions(['id' => $user_id], 'role_id', $this->tblUser);
            if(!empty($acc)){
                if($acc['role_id'] == UserService::_CUSTOMER){
                    $cust = $this->getCustomerDetail($user_id);
                    $fullname = $cust['code_name'];
                } else {
                    $employee = $this->getEmployeeDetail($user_id);
                    $fullname = $employee['code_name'];
                }
            }
            return isset($fullname) ? $fullname : null;
        }

        public function getAssignedTo($task_id){
            $assigned = $this->DatabaseModel->readArrayWithOptions(['task_id' => $task_id], 'id, team_id, user_id', $this->tblAssign);
            if(!empty($assigned)){
                foreach ($assigned as $k => $val) {
                    $assign[$k]             = $val;
                    $assign[$k]['team']     = $this->getTeamDetail($val['team_id']);
                    $assign[$k]['employee'] = $this->getEmployeeDetail($val['user_id']);
                }
            }
            return isset($assign) ? $assign : null;
        }

        public function getComment($task_id, $comment_type){
            $comments = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id, 'comment_type' => $comment_type
            ], 'id, commentby_id, comment, created_date, modified_date', 'created_date DESC', $this->tblComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['by'] = $this->getUserDetail($val['commentby_id']);
                }
            }
            return isset($comment) ? $comment : null;
        }
}