<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class LST_Service extends MY_Service {
    private $data             = [];

    public static $conf_role  = '';
    public static $conf_dep   = '';
    private static $file_view = '';

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/JobsheetService'                   => 'JobsheetService',
        'SettingService'                        => 'SettingService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('deparment');

        if($this->session->userLogged['department_id'] == UserService::DEP_HR){
            self::$file_view = 'default/hr/task/default/comments/';
        } else {
            self::$file_view = 'default/operation/task/default/comments/';
        }
    }

    /* START :: MAIN */
        public function _load_main_component($task_id, $task, $js, $js_id){
            $commentby_id   = !empty($js['commentby_id']) ? $js['commentby_id'] : 0;
            $rate           = $this->TaskService->_lst_rate();

            $charge = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id,
            ], $this->TableFieldService->JsCharge, 'id ASC', $this->TableService->JsCharge);

            $this->JobsheetService->_calculate_service_charge($js, $js_id, $rate, 'lst');

            $otherCharge = $this->loadOtherChargeDetail($js_id);
            $svcCharge   = $this->JobsheetService->_all_service_charge($js_id);
            $totalCharge = $this->JobsheetService->_total_charge_detail($js_id);

            # do calculation just in case the system failed to update from the previous session
            $this->JobsheetService->_calculate_total_amount($js_id);
            $this->JobsheetService->_calculate_total_charge($js_id, 'lst');
            $refresh = $this->lstAction($otherCharge, $js_id, $js, $commentby_id);

            return [
                'js'          => $js,
                'charge'      => $charge,
                'otherCharge' => $otherCharge,
                'svcCharge'   => $svcCharge,
                'rate'        => $rate,
                'totalCharge' => $totalCharge,
                'refresh'     => $refresh
            ];
        }

        private function lstAction($otherCharge, $js_id, $js, $commentby_id){
            $refresh = false;

            if(isset($_POST['save_all'])){
                $price_input    = $this->input->post('price');
                $cost_input     = $this->input->post('cost');

                if($price_input){
                    foreach ($price_input as $charge_id => $price) {
                        $this->DatabaseModel->updateData(['id' => $charge_id], ['price' => $price], $this->TableService->JsCharge);
                    }
                }

                $this->update_js_charge($cost_input, $js_id);
                $this->update_other_charge($js['task_id'], $js_id, $otherCharge);
                $this->update_js_service_charge();

                $this->JobsheetService->_calculate_total_charge($js_id, 'lst');
                $this->session->set_flashdata('success_msg', updateMsg());
                $refresh = true;
            }

            if(isset($_POST['return_js'])){
                $this->DatabaseModel->updateData(['id' => $js_id], [
                    'internal_verify'       => 0,
                    'manager_verify'        => 0,
                    'admin_verify'          => 0,
                    'account_verify'        => 0,
                    'verification_status'   => 0
                ], $this->TableService->Jobsheet);

                $verifyData = [
                    'manager_verify' => 0,
                    'admin_verify'   => 0,
                    'account_verify' => 0
                ];

                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsCharge);
                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsOtherCharge);

                $this->session->set_flashdata('success_msg', 'Jobsheet has been returned. LST can now edit this jobsheet.');
                $refresh = true;
            }

            return $refresh;
        }

        public function update_other_charge($task_id, $js_id, $otherCharge){
            $mileage        = $this->input->post('mileage');
            $mileage_charge = 0;

            if($mileage > 0){
                $mileage_charge = $mileage * (1.95 / 13);
            }

            $otherChargeData = [
                'mileage'        => $mileage*100,
                'mileage_charge' => $mileage_charge*100
            ];

            if($this->input->post('delivery_charge')){
                $otherChargeData['delivery_charge'] = $this->input->post('delivery_charge')*100;
            } else {
                $otherChargeData['delivery_charge'] = 0;
            }

            if(!empty($otherCharge)){
                $this->DatabaseModel->updateData(['id' => $otherCharge['id']], $otherChargeData, $this->TableService->JsOtherCharge);
            } else {
                $otherChargeData['task_id'] = $task_id;
                $otherChargeData['js_id']   = $js_id;
                $this->DatabaseModel->createData($otherChargeData, $this->TableService->JsOtherCharge);
            }
        }

        private function update_js_service_charge(){
            if(isset($_POST['svc_name'])){
                $svc_name_input          = $this->input->post('svc_name');
                $svc_selling_price_input = $this->input->post('svc_selling_price');
                $svc_total_input         = $this->input->post('svc_total');

                foreach ($svc_name_input as $svc_chargeid => $svc) {
                    $svc_selling_price = $svc_selling_price_input[$svc_chargeid];
                    $svc_total         = $svc_total_input[$svc_chargeid];

                    $this->DatabaseModel->updateData(['id' => $svc_chargeid], [
                        'name'          => $svc,
                        'selling_price' => $svc_selling_price,
                        'total'         => $svc_total,
                        'modified_date' => getCurrentTimeStamp(),
                        'is_edited'     => true
                    ], $this->TableService->JsServiceCharge);
                }
            }
        }

        private function update_js_charge($cost_input, $js_id){
            # second update of js charge
            $charge = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id
            ], $this->TableFieldService->JsCharge, 'id ASC', $this->TableService->JsCharge);

            if(isset($cost_input) && !empty($cost_input)){
                foreach ($cost_input as $charge_id => $cost) {
                    $index          = array_search($charge_id, array_column($charge, 'id'));
                    $total_cost     = $charge[$index]['qty'] * $cost;
                    $margin_profit  = (60/100);
                    $profit_sharing = ($charge[$index]['amount'] > $total_cost) ? ($charge[$index]['amount'] - $total_cost) * (60/100) : 0;
                    $total          = $profit_sharing + $total_cost;

                    $costData = [
                        'cost'           => $cost,
                        'margin_profit'  => $margin_profit,
                        'profit_sharing' => $profit_sharing,
                        'total'          => $total
                    ];
                    // print_array($costData); exit();
                    $this->DatabaseModel->updateData(['id' => $charge_id], $costData, $this->TableService->JsCharge);
                }
            }
        }

    /* START :: PRIVATE FUNCTION */
        private function loadOtherChargeDetail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], '*', $this->TableService->JsOtherCharge);
        }

}