<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class JobsheetService extends MY_Service {
    private $data             = [];

    public static $conf_role  = '';
    public static $conf_dep   = '';
    private static $file_view = '';

    const _SERVICE  = 0;
    const _HARDWARE = 1;    // is the ITEM, previously called HARDWARE

    const _JS_PENDING_VERIFY = 0;
    const _JS_SUBMIT_VERIFY  = 1;
    const _JS_MANAGER_VERIFY = 2;
    const _JS_ADMIN_VERIFY   = 3;
    const _JS_ACC_VERIFY     = 4;

    const _CMT_INTERNAL     = 1;
    const _CMT_JOBSHEET     = 2;
    # start :: deprecated
    const _CMT_ALTLST       = 3;
    const _CMT_ALTLSTCHRG   = 4;
    const _CMT_CHRG         = 5;
    # ./ end :: deprecated
    const _CMT_ALT          = 6;
    const _CMT_LST          = 7;
    const _CMT_CUST         = 8;

    const _ALT_SETING = [5];    // team setting index
    const _LST_SETING = [4];

    const _ALT_HOURLY_RATE = 12.50;

    const _CMT_TYPE = [
        [
            'id' => 1,
            'type' => 'internal'
        ],
        [
            'id' => 2,
            'type' => 'jobsheet'
        ],
        [
            'id' => 6,
            'type' => 'alt-comment'
        ],
        [
            'id' => 7,
            'type' => 'lst-comment'
        ],
        [
            'id' => 8,
            'type' => 'customer-comment'
        ]
    ];

    private $Services = [
        'UserService'         => 'UserService',
        'task/ManagerService' => 'ManagerService',
        'task/StaffService'   => 'StaffService',
        'task/SettingService' => 'SettingService',
        'media/MediaService'  => 'MediaService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('deparment');

        // if($this->session->userLogged['department_id'] == UserService::DEP_HR){
        //     self::$file_view = 'default/hr/task/default/comments/';
        // } else {
        //     self::$file_view = 'default/operation/task/default/comments/';
        // }
    }

    /* START :: DEFAULT FUNCTIONS (TO FETCH DATA) */
        public function _all_jobsheet(){
            $jobsheet = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Jobsheet, 'created_date DESC', $this->TableService->Jobsheet);

            if(!empty($jobsheet)){
                foreach ($jobsheet as $k => $val) {
                    $js[$k] = $val;
                    $js[$k]['by'] = $this->UserService->_employee_detail($val['commentby_id']);
                }
            }
            return isset($js) ? $js : [];
        }

        public function _jobsheet_by_task($task_id){
            $jobsheet = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id], '*', 'code ASC', 'Jobsheet');

            if(!empty($jobsheet)){
                foreach ($jobsheet as $k => $val) {
                    $js[$k] = $val;
                    $js[$k]['by'] = $this->UserService->_employee_detail($val['commentby_id']);
                    $js[$k]['attnd'] = $this->DatabaseModel->readOneWithOptions(['id' => $val['taskattnd_id']], 'check_in, check_out', $this->TableService->TaskAttnd);
                    $js[$k]['charges']       = $this->loadJsCharges($val['id']);
                    $js[$k]['total_charges'] = $this->_total_charge_detail($val['id']);
                    $js[$k]['service_charge'] = $this->_all_service_charge($val['id']);
                    $js[$k]['sign_url']      = SIGN_URL.$val['sign'];
                    $js[$k]['verified_by']   = !empty($val['verifier']) ? json_decode($val['verifier']) : null;

                    // $sql = 'SELECT id FROM Invoice_Sales 
                    //         LEFT JOIN ';
                    // $invoices = $this->DatabaseModel->readOneWithOptions(['js_id' => $val['id']], 'id', 'Invoice_Sales');
                    // print_array($invoices); exit();
                    // if(!empty($invoices)){

                    // }
                }
            }
            return isset($js) ? $js : [];
        }

        private function loadJsCharges($js_id=null){
            $sales = $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], '*', 'Invoice_Sales');
            if(!empty($sales)){
                $sql = 'SELECT 
                        Item.id, 
                        Item.sn,
                        Item.item_desc,
                        Item.cust_item_desc,
                        Item.selling_price,
                        Item.qty,
                        ItemSales.discount,
                        ItemSales.sub_total, 
                        ItemSales.sub_total_after_discount 
                    FROM Item
                    LEFT JOIN ItemSales ON ItemSales.item_id = Item.id
                    LEFT JOIN Invoice_Sales ON Invoice_Sales.id = ItemSales.invoice_id
                    WHERE ItemSales.invoice_id = '.$sales['id'];
                $items = $this->DatabaseModel->readArrayQuery($sql);
                $sales['agent'] = $this->DatabaseModel->readOneWithOptions(['user_id' => $sales['agent_id']], 'code_name', 'Employee');
                $sales['terms'] = $this->DatabaseModel->readOneWithOptions(['id' => $sales['credit_terms_id']], 'description', 'CompanySetting_CreditTerms');
            }

            // if(!empty($charges)){
            //     foreach ($charges as $k => $val) {
            //         $charge[$k] = $val;
            //         $charge[$k]['others'] = $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id
            //         ], 'id, service, mileage, mileage_charge, toll, parking, delivery, delivery_charge', $this->TableService->JsOtherCharge);
            //     }
            // }

            $charge = [
                'sales' => $sales,
                'items' => isset($items) ? $items : []
            ];

            // print_array($charge); exit();

            return isset($charge) ? $charge : [];
        }

        public function _jobsheet_detail($js_id){
            $js = $this->DatabaseModel->readOneWithOptions(['id' => $js_id], $this->TableFieldService->Jobsheet, $this->TableService->Jobsheet);

            if(!empty($js)){
                $js['by']            = $this->UserService->_employee_detail($js['commentby_id']);
                $js['attnd']         = $this->_task_attnd_detail($js['taskattnd_id']);
                $js['charges']       = $this->loadJsCharges($js['id']);
                $js['total_charges'] = $this->_total_charge_detail($js['id']);
                $js['service_charge'] = $this->_all_service_charge($js['id']);
                $js['sign_url']      = !empty($js['sign']) ? SIGN_URL.$js['sign'] : null;
                $js['verified_by']   = !empty($js['verifier']) ? json_decode($js['verifier']) : null;
            }
            return isset($js) ? $js : [];
        }

        public function _jobsheet_charges($js_id){
            return $this->DatabaseModel->readArrayWithOptions(['id' => $js_id], $this->TableFieldService->Jobsheet, $this->TableService->Jobsheet);
        }

        public function _jobsheet_charge_listing($js_id){
            return $this->DatabaseModel->readArrayWithOptions(['js_id' => $js_id], $this->TableFieldService->JsCharge, $this->TableService->JsCharge);
        }

        public function _jobsheet_charge_detail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], $this->TableFieldService->JsCharge, $this->TableService->JsCharge);
        }

        public function _charge_detail($charge_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $charge_id], $this->TableFieldService->JsCharge, $this->TableService->JsCharge);
        }

        public function _other_charge_detail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], $this->TableFieldService->JsOtherCharge, $this->TableService->JsOtherCharge);
        }

        public function _all_service_charge($js_id){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id], $this->TableFieldService->JsServiceCharge, 'id ASC', $this->TableService->JsServiceCharge);
        }

        public function _service_charge_detail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], $this->TableFieldService->JsServiceCharge, $this->TableService->JsServiceCharge);
        }

        public function _total_charge_detail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], $this->TableFieldService->JsTotalCharge, $this->TableService->JsTotalCharge);
        }

        public function _task_attnd_detail($attnd_id){
            $attnd = $this->DatabaseModel->readOneWithOptions(['id' => $attnd_id], 'check_in, check_out, date', $this->TableService->TaskAttnd);
            if(!empty($attnd)){
                $start_time = new DateTime($attnd['check_in']);
                $end_time   = new DateTime($attnd['check_out']);
                $duration   = $start_time->diff($end_time);

                $attnd['duration'] = $duration->h.' H'.' '.$duration->i.' MIN';
            }
            return $attnd;
        }

        public function _time_diff($check_in, $check_out){
            $start_time = new DateTime($check_in);
            $end_time   = new DateTime($check_out);
            $duration   = $start_time->diff($end_time);

            return $duration->h.' H'.' '.$duration->i.' MIN';
        }

        public function _alt_service_charge_detail($task_id, $js_id, $created_date){
            // $altServiceCharge = $this->DatabaseModel->readOneWithOptions(['js_ids' => $js_id], 'id', 'JobsheetAltServiceCharge');
            // if(empty($altServiceCharge)){
            //     $this->DatabaseModel->createData([
            //         'task_id'   => $task_id,
            //         'js_ids'    => $js_id,
            //         'date'      => date('y-m-d', strtotime($created_date)),
            //         'total'     => 50
            //     ], 'JobsheetAltServiceCharge');
            // }
            return $this->DatabaseModel->readOneWithOptions([
                'task_id' => $task_id, 
                'date'    => date('y-m-d', strtotime($created_date))
            ], '*', $this->TableService->JsAltServiceCharge);
        }

        public function _attc_list($js_id){
            $AttcArr['toll']    = [];
            $AttcArr['parking'] = [];

            $attc = $this->DatabaseModel->readArrayWithOptions(['js_id' => $js_id], $this->TableFieldService->JsAttc, $this->TableService->JsAttc);

            if(!empty($attc)){
                foreach ($attc as $k => $val) {
                    if($val['attc_type'] === 'toll'){
                        $AttcArr['toll'][$k] = $val;
                        $AttcArr['toll'][$k]['url'] = LIB_URL.'receipt/'.$val['file_src'];
                    } else {
                        $AttcArr['parking'][$k] = $val;
                        $AttcArr['parking'][$k]['url'] = LIB_URL.'receipt/'.$val['file_src'];
                    }
                }
            }

            return $AttcArr;
        }

        public function _attc_detail($attc_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $attc_id], $this->TableFieldService->JsAttc, $this->TableService->JsAttc);
        }

    /* START :: COMMENTING FUNCTIONS */
        public function displayCommentTabContent($comment, $tab, $tab_url, $comment_type){
            $this->data['comment']      = $comment;
            $this->data['tab']          = $tab;
            $this->data['tab_url']      = $tab_url;
            $this->data['comment_type'] = $comment_type;
            $this->load->view(VERSION.'/task/open-comments/comment-tab-content.tpl.php', $this->data);
        }

        public function displayClosedCommentTabContent($comment, $tab, $tab_url, $comment_type){
            $this->data['comment']      = $comment;
            $this->data['tab']          = $tab;
            $this->data['tab_url']      = $tab_url;
            $this->data['comment_type'] = $comment_type;
            $this->load->view(VERSION.'/task/closed-comments/comment.tpl.php', $this->data);
        }

        public function isPermitted($permit_type=null, $commentby_id){
            if($permit_type === 'task_type'){
                if($this->session->userLogged['role_id'] == UserService::_STAFF){
                    if($this->session->userLogged['id'] == $commentby_id){
                        return null;
                    } else {
                        return 'disabled';
                    }
                } else {
                    return null;
                }
            }
        }

        public function notifyMsg($msg_type){
            if($msg_type === 'verify'){
                return 'You have to start jobsheet in order to verify jobsheet.';
            }
            if($msg_type === 'comment'){
                return 'You have to start jobsheet in order to write a new comment or verify jobsheet.';
            }
        }

        public function verifiedMsg(){
            return 'This jobsheet has been verified.';
        }

        public function _get_team_setting(){
            $department_id = $this->session->userLogged['department_id'];
            $team_id       = $this->session->userLogged['team_id'];
            $isPermitted   = FALSE;

            if($this->session->userLogged['role_id'] == UserService::_STAFF){
                if($department_id == UserService::DEP_OPERATION){
                    $SettingTeam = $this->DatabaseModel->readOneWithOptions([
                        'department_id' => $department_id, 
                        'optteam_id'    => $team_id,
                        'type_id'       => SettingService::_OP_SET_ALTLST_COMMENT
                    ], 'id', $this->TableService->SetTeam);

                    $isPermitted = !empty($SettingTeam) ? TRUE : FALSE;
                }
            } else {
                $isPermitted = TRUE;
            }

            return $isPermitted;
        }

        public function _is_internal_permitted(){
            $department_id = $this->session->userLogged['department_id'];
            $team_id       = $this->session->userLogged['team_id'];
            $isPermitted   = FALSE;

            if($this->session->userLogged['role_id'] == UserService::_STAFF){
                if($department_id == UserService::DEP_OPERATION){
                    $SettingTeam = $this->DatabaseModel->readOneWithOptions([
                        'department_id' => $department_id, 
                        'optteam_id'    => $team_id,
                        'type_id'       => SettingService::_OP_SET_ALTLST_COMMENT
                    ], 'id', $this->TableService->SetTeam);

                    $isPermitted = !empty($SettingTeam) ? FALSE : TRUE;
                }
            } else {
                $isPermitted = TRUE;
            }

            return $isPermitted;
        }

        public function updateChargeType($comment_id){
            echo $comment_id;
        }

    /* THE FUNCTIONS BELOW ARE DEPRECATED. WE ARE NOW USING THE WEBVIEW FROM THE MAIN SERVER [2022-08-02] */
    /* START :: SHARED FUNCTIONS */
    /* Any functions that can be shared by ALT/LST, such as to update the total charges 
     * @param: $js = LST duration use the task attend CHECK IN / OUT
     * @param: $js = ALT duration use the 1st JS CHECK IN && last JS CHECK OUT
    */
        public function _calculate_service_charge($js, $js_id, $rate, $team){
            if($team === 'alt'){
                $rateDuration     = [];
                $duration         = isset($js['js_durations']) ? $js['js_durations'] : 0;
                $hours            = $duration/60;
                // $workingDuration  = explode(' ', $duration);

                // $hours = (int)$workingDuration[0];
                // $min   = (int)$workingDuration[2];

                $js_ids = null;
                if(!empty($js['related_js'])){
                    $first = true;
                    foreach ($js['related_js'] as $row) {
                        if($first){
                            $js_ids .= $row['id'];
                        } else {
                            $js_ids .= ', '.$row['id'];
                        }
                        $first = false;
                    }
                }

                $altServiceCharge = $this->JobsheetService->_alt_service_charge_detail($js['task_id'], $js_ids, $js['created_date']);

                if(!empty($altServiceCharge)){
                    if($altServiceCharge['service_type'] == 0){
                        //$serviceRate = ($hours.'.'.$min) * self::_ALT_HOURLY_RATE;
                        $serviceRate = 4 * self::_ALT_HOURLY_RATE;
                    } else {
                        if($hours < 4){
                            // $serviceRate = ($hours.'.'.$min) * self::_ALT_HOURLY_RATE;
                            $serviceRate = $hours * self::_ALT_HOURLY_RATE;
                        } else {
                            $serviceRate = 4 * self::_ALT_HOURLY_RATE;
                        }
                        // print_array($hours); exit();
                    }
                } else {
                    // $serviceRate = ($hours.'.'.$min) * self::_ALT_HOURLY_RATE;
                    $serviceRate = $hours * self::_ALT_HOURLY_RATE;
                }

                if(!empty($altServiceCharge)){
                    $this->DatabaseModel->updateData(['id' => $altServiceCharge['id']], ['total' => $serviceRate], $this->TableService->JsAltServiceCharge);
                } else {
                    $this->DatabaseModel->createData([
                        'task_id' => $js['task_id'], 
                        'js_ids'  => $js_ids,
                        'date'    => date('y-m-d', strtotime($js['created_date'])),
                        'total'   => $serviceRate
                    ], $this->TableService->JsAltServiceCharge);
                }
            } else {
                $rateDuration    = [];
                $duration        = isset($js['attnd']['duration']) ? $js['attnd']['duration'] : 0;
                $workingDuration = str_replace(['h','min'], ['',''], getString($duration));

                foreach ($rate as $row) {
                    $rateDuration[] = explode('-', str_replace(['h','min'], ['',''], getString($row['duration'])));
                }

                $key = $this->findRate($rateDuration, $workingDuration);
                $serviceRateData = $rate[$key];
                $serviceRate     = $serviceRateData['default_charge'];

                $charge = $this->_jobsheet_charge_detail($js_id);
                if(empty($charge)){
                    $serviceRate = 0;
                }

                $this->DatabaseModel->updateData(['js_id' => $js_id], ['service' => $serviceRate], $this->TableService->JsOtherCharge);
            }
        }

        private function findRate($rateDuration, $workingDuration){
            $arrKey = 0;
            foreach ($rateDuration as $k => $row) {
                if($workingDuration >= $row[0] && $workingDuration <= $row['1']){
                    $arrKey = $k;
                    continue;
                }
            }
            return $arrKey;
        }

        /*
        * @params: $total = total to pay to ALT/LST
        */
        public function _calculate_total_charge($js_id, $team){
            $options       = 'js_id = '.$js_id;
            $other_field   = $team === 'alt' || $team === 'other' ? 'mileage_charge + toll + parking + delivery_charge' : 'service + mileage_charge + toll + parking + delivery_charge';
            //$charges       = $this->DatabaseModel->readOneQuery('SELECT SUM(price) AS selling_price_total, SUM(total) AS total FROM '.$this->TableService->JsCharge.' WHERE '.$options);
            $charges       = $this->DatabaseModel->readOneQuery('SELECT SUM(amount) AS selling_price_total, SUM(total) AS total FROM '.$this->TableService->JsCharge.' WHERE '.$options);
            $otherCharges  = $this->DatabaseModel->readOneQuery('SELECT SUM('.$other_field.') AS service_charge_total FROM '.$this->TableService->JsOtherCharge.' WHERE '.$options);
            $serviceCharge = $this->DatabaseModel->readOneQuery('SELECT SUM(selling_price) AS selling_price_total, SUM(total) AS total FROM '.$this->TableService->JsServiceCharge.' WHERE '.$options);

            $selling_price_total = 0;
            $other_total = 0;
            $total = 0;

            if(!empty($charges)){
                $selling_price_total = $charges['selling_price_total'];
                $total = $charges['total'];
            }

            if(!empty($otherCharges)){
                $total = $otherCharges['service_charge_total'] + $total;
            }

            if(!empty($serviceCharge)){
                $selling_price_total = $selling_price_total + $serviceCharge['selling_price_total'];
                $total = $total + $serviceCharge['total'];
            }

            $totalCharge     = $this->JobsheetService->_total_charge_detail($js_id);
            $totalChargeData = [
                'selling_price' => $selling_price_total,
                'total'         => $total,
            ];

            if($team === 'alt'){
                $js = $this->_jobsheet_detail($js_id);
                $altServiceCharge = $this->_alt_service_charge_detail($js['task_id'], $js_id, $js['created_date']);
                $totalChargeData['grand_total'] = $total + $altServiceCharge['total'];
            }

            if(!empty($totalCharge)){
                $this->DatabaseModel->updateData(['js_id' => $js_id], $totalChargeData, $this->TableService->JsTotalCharge);
            } else {
                $totalChargeData['js_id'] = $js_id;
                $this->DatabaseModel->createData($totalChargeData, $this->TableService->JsTotalCharge);
            }
        }

        public function _calculate_total_amount($js_id){
            $charges = $this->_jobsheet_charge_listing($js_id);
            if(!empty($charges)){
                //print_array($charges); exit();
                foreach ($charges as $row) {
                    $this->DatabaseModel->updateData(['id' => $row['id']], [
                        'amount'     => $row['price'] * $row['qty'],
                        'total_cost' => $row['cost'] * $row['qty']
                    ], $this->TableService->JsCharge);
                }
            }
        }

        public function _check_team_name($js_id){
            $js = $this->_jobsheet_detail($js_id);

            $department_id = !empty($js) ? $js['by']['department_id'] : 0;
            $team_id       = !empty($js) ? $js['by']['team_id'] : 0;
            $teamSettings  = $this->SettingService->_team_setting_listing($department_id, $team_id);

            $is_alt = false;
            $is_lst = false;

            if(!empty($teamSettings)){
                foreach ($teamSettings as $set) {
                    if(in_array($set['type_id'], self::_ALT_SETING)){
                        $is_alt = true;
                    }
                    if(in_array($set['type_id'], self::_LST_SETING)){
                        $is_lst = true;
                    }
                }
            }

            return $is_alt ? 'alt' : 'lst';
        }

        public function _delete_attc($attc_id){
            $attc = $this->_attc_detail($attc_id);
            if(!empty($attc) && !empty($attc['file_src'])){
                $this->MediaService->unlinkFile(UPLOAD_PATH.'/receipt/'.$attc['file_src']);
            }
            $this->DatabaseModel->deleteData(['id' => $attc_id], $this->TableService->JsAttc);
        }

}