<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class ClaimService extends MY_Service {
    private $data             = [];

    const _CLAIM_CO_RECEIPT = 'coreceipt';
    const _CLAIM_RECEIPT    = 'claimreceipt';

    const _STAT_DRAFT           = 0;
    const _STAT_SUBMITTED       = 1;
    const _STAT_WAITING_PAYMENT = 2;
    const _STAT_PAID            = 3;

    const _RECEIPT_NO_STAT      = 0;
    const _RECEIPT_CAN_CLAIM    = 1;
    const _RECEIPT_CANNOT_CLAIM = 2;

    const STAT = [ 'Draft', 'Submitted for verification', 'Waiting for payment', 'Paid' ];
    const RECEIPT_STAT = [ '', 'Yes', 'No' ];

    public static $conf_role  = '';
    public static $conf_dep   = '';
    private static $file_view = '';

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/JobsheetService'                   => 'JobsheetService',
        'SettingService'                        => 'SettingService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('deparment');

        // if($this->session->userLogged['department_id'] == UserService::DEP_HR){
        //     self::$file_view = 'default/hr/task/default/comments/';
        // } else {
        //     self::$file_view = 'default/operation/task/default/comments/';
        // }
    }

    /* START :: GENERAL CLAIM - SHARED FUNCTIONS */
        public function _claim_prefix(){
            return $this->DatabaseModel->readOne($this->TableFieldService->ClaimPrefix, $this->TableService->ClaimPrefix);
        }

        public function _generate_voucher_no(){
            $voucherNo   = 0;
            $config      = $this->_claim_prefix();
            $lastVoucher = $this->_last_voucher_no();
            if(!empty($config)){
                $lastVoucherNo = !empty($lastVoucher) ? extract_integer($lastVoucher) : 0;
                $voucherNo     = str_pad(($lastVoucherNo+1), strlen($config['voucher_no']), $config['voucher_no'], STR_PAD_LEFT);
            }
            return 'V'.$voucherNo;
        }

        public function _voucher_detail($voucher_no){
            $voucher = $this->DatabaseModel->readOneWithOptions(['voucher_no' => $voucher_no
            ], $this->TableFieldService->ClaimVoucher, $this->TableService->ClaimVoucher);
            $voucher['is_disabled'] = $voucher['status'] == self::_STAT_PAID ? 'disabled' : null;
            return $voucher;
        }

        public function _last_voucher_no(){
            $sql     = 'SELECT MAX(voucher_no) AS voucher_no FROM '.$this->TableService->ClaimVoucher;
            $voucher = $this->DatabaseModel->readOneQuery($sql);
            return !empty($voucher) ? $voucher['voucher_no'] : 0;
        }

        public function _generate_pc_no(){
            $pcNo   = 0;
            $config = $this->_claim_prefix();
            $lastPc = $this->_last_pc_no();
            if(!empty($config)){
                $lastPcNo = !empty($lastPc) ? $lastPc : 0;
                $pcNo     = str_pad(($lastPcNo+1), strlen($config['pc_no']), $config['pc_no'], STR_PAD_LEFT);
            }
            return $pcNo;
        }

        public function _last_pc_no(){
            $sql   = 'SELECT MAX(pc_no) AS pc_no FROM '.$this->TableService->Claim;
            $claim = $this->DatabaseModel->readOneQuery($sql);
            return !empty($claim) ? $claim['pc_no'] : 0;
        }

        public function _claim_cat_listing(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->ClaimCat, 'title ASC', $this->TableService->ClaimCat);
        }

        public function _claim_acc_listing(){
            return $this->DatabaseModel->readArray($this->TableFieldService->ClaimAcc, $this->TableService->ClaimAcc);
        }

        public function _claim_listing($voucher_no){
            $claims = $this->DatabaseModel->readArrayWithOptionsOrderBy(['voucher_no' => $voucher_no
            ], $this->TableFieldService->Claim, 'pc_no ASC', $this->TableService->Claim);

            if(!empty($claims)){
                foreach ($claims as $k => $val) {
                    $claim[$k] = $val;
                    $claim[$k]['category'] = $this->_claim_category_detail($val['claimcategory_id']);
                    $claim[$k]['attc']     = $this->_claim_attc($val['pc_no']);
                    $claim[$k]['cust']     = $this->_claim_linked_customer_listing($val['pc_no']);
                    $claim[$k]['project']  = $this->SettingService->_project_detail($val['project_id']);
                    $claim[$k]['acc']      = $this->_claim_account_detail($val['claimaccount_id']);
                    $claim[$k]['company']  = $this->SettingService->_company_on_receipt_detail($val['claimcompany_id']);
                }
            }
            return isset($claim) ? $claim : [];
        }

        public function _claim_detail($pc_no){
            $claim = $this->DatabaseModel->readOneWithOptions(['pc_no' => $pc_no
            ], $this->TableFieldService->Claim, $this->TableService->Claim);

            if(!empty($claim)){
                $claim['category'] = $this->_claim_category_detail($claim['claimcategory_id']);
                $claim['attc']     = $this->_claim_attc($claim['pc_no']);
                $claim['cust']     = $this->_claim_linked_customer_listing($claim['pc_no']);
                $claim['project']  = $this->SettingService->_project_detail($claim['project_id']);
                $claim['acc']      = $this->_claim_account_detail($claim['claimaccount_id']);
                $claim['company']  = $this->SettingService->_company_on_receipt_detail($claim['claimcompany_id']);
            }
            return isset($claim) ? $claim : [];
        }

        public function _claim_related_field($pc_no){
            $claim = $this->DatabaseModel->readOneWithOptions(['pc_no' => $pc_no
            ], $this->TableFieldService->Claim, $this->TableService->Claim);
            
            if(!empty($claim)){
                $details = [
                    'category' => $this->_claim_category_detail($claim['claimcategory_id']),
                    'attc'     => $this->_claim_attc($claim['pc_no']),
                    'cust'     => $this->_claim_linked_customer_listing($claim['pc_no']),
                    'project'  => $this->SettingService->_project_detail($claim['project_id']),
                    'acc'      => $this->_claim_account_detail($claim['claimaccount_id']),
                    'company'  => $this->SettingService->_company_on_receipt_detail($claim['claimcompany_id']),
                ];
                return $details;
            }
            return [];
        }

        public function _claim_attc($pc_no){
            $attcArr = $this->DatabaseModel->readArrayWithOptions(['pc_no' => $pc_no
            ], $this->TableFieldService->ClaimAttc, $this->TableService->ClaimAttc);
            if(!empty($attcArr)){
                foreach ($attcArr as $k => $val) {
                    $attc[$k] = $val;
                    $attc[$k]['url'] = LIB_URL.'receipt/'.$val['file_src'];
                }
            }
            return isset($attc) ? $attc : [];
        }

        # to be DEPRECATED!
        public function _claim_list($claim_id){
            $claimListArr = $this->DatabaseModel->readArrayWithOptions(['claim_id' => $claim_id], $this->TableFieldService->ClaimList, $this->TableService->ClaimList);
            if(!empty($claimListArr)){
                foreach ($claimListArr as $k => $val) {
                    $claimList[$k] = $val;
                    $claimList[$k]['category'] = $this->_claim_category_detail($val['claimcategory_id']);
                    $claimList[$k]['attc']     = $this->_claim_list_attc($val['id'], self::_CLAIM_RECEIPT);
                }
            }
            return isset($claimList) ? $claimList : [];
        }

        public function _claim_category_detail($claimcategory_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $claimcategory_id], $this->TableFieldService->ClaimCat, $this->TableService->ClaimCat);
        }

        public function _claim_account_detail($claimaccount_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $claimaccount_id], $this->TableFieldService->ClaimAcc, $this->TableService->ClaimAcc);
        }

        # to be DEPRECATED!
        public function _claim_list_attc($ref_id, $claim_receipt_type){
            if($claim_receipt_type == self::_CLAIM_RECEIPT){
                $opt = ['claimlist_id' => $ref_id, 'attc_type' => $claim_receipt_type];
            } else {
                $opt = ['claim_id' => $ref_id, 'attc_type' => $claim_receipt_type];
            }
            $attcArr = $this->DatabaseModel->readArrayWithOptions($opt, $this->TableFieldService->ClaimAttc, $this->TableService->ClaimAttc);
            if(!empty($attcArr)){
                foreach ($attcArr as $k => $val) {
                    $attc[$k] = $val;
                    $attc[$k]['url'] = LIB_URL.'receipt/'.$val['file_src'];
                }
            }
            return isset($attc) ? $attc : [];
        }

        public function _claim_linked_customer_listing($pc_no){
            $linkedCustArr = $this->DatabaseModel->readArrayWithOptions(['pc_no' => $pc_no
            ], $this->TableFieldService->ClaimLinkedCust, $this->TableService->ClaimLinkedCust);

            if(!empty($linkedCustArr)){
                foreach ($linkedCustArr as $k => $val) {
                    $linkedCust[$k] = $val;
                    $linkedCust[$k]['cust'] = $this->UserService->_codename_by_id($val['cust_id']);
                }
            }

            return isset($linkedCust) ? $linkedCust : [];
        }

        public function _claim_linked_customer_detail($claim_linked_cust_id){
            $linkedCust = $this->DatabaseModel->readArrayWithOptions(['id' => $claim_linked_cust_id
            ], $this->TableFieldService->ClaimLinkedCust, $this->TableService->ClaimLinkedCust);

            if(!empty($linkedCust)){
                $linkedCust['cust'] = $this->UserService->_customer_detail($linkedCust['cust_id']);
            }

            return $linkedCust;
        }

        public function _claim_by_pc_no($pc_no){
            $claim = $this->DatabaseModel->readOneWithOptions(['pc_no' => $pc_no], $this->TableFieldService->Claim, $this->TableService->Claim);
            if(!empty($claim)){
                $claim['attc']        = $this->_claim_attc($pc_no);
                $claim['linked_cust'] = $this->_claim_linked_customer_listing($pc_no);
                $claim['acc']         = $this->_claim_account_detail($claim['claimaccount_id']);
                $claim['cat']         = $this->_claim_category_detail($claim['claimcategory_id']);
            }
            return $claim;
        }

        public function _calculate_spc($km=null){
            $spc    = 0;
            $config = $this->SettingService->_claim_spc();
            if(!empty($config)){
                $spc = calculateSPC($config['spc'], $config['petrol_price'], $km);
            }
            return $spc;
        }

        public function _update_claim_total($voucher_no, $claim_amt, $action){
            $voucher = $this->_voucher_detail($voucher_no);

            if(!empty($voucher)){
                if($action === 'add'){
                    $new_total = $voucher['total_claim'] + $claim_amt;
                } else {
                    $new_total = $voucher['total_claim'] - $claim_amt;
                }
                
                $this->DatabaseModel->updateData(['voucher_no' => $voucher_no], [
                    'total_claim' => $new_total
                ], $this->TableService->ClaimVoucher);
            }
        }
    
    /* START :: MAIN */
        public function _load_main_component($task_id, $task, $js, $js_id){
            $commentby_id   = !empty($js['commentby_id']) ? $js['commentby_id'] : 0;
            $otherCharge      = $this->loadOtherChargeDetail($js_id);
            $svcCharge        = $this->JobsheetService->_all_service_charge($js_id);
            $totalCharge      = $this->JobsheetService->_total_charge_detail($js_id);
            $attc             = $this->JobsheetService->_attc_list($js_id);

            $charge = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id,
            ], $this->TableFieldService->JsCharge, 'id ASC', $this->TableService->JsCharge);

            # do calculation just in case the system failed to update from the previous session
            $this->JobsheetService->_calculate_total_amount($js_id);
            $this->JobsheetService->_calculate_total_charge($js_id, 'other');
            $this->action($otherCharge, $js_id, $js, $commentby_id);

            if(isset($_POST['submit_verify'])){
                $this->DatabaseModel->updateData(['id' => $js_id], [
                    'internal_verify' => JobsheetService::_JS_SUBMIT_VERIFY,
                    'verification_status' => JobsheetService::_JS_SUBMIT_VERIFY,
                ], $this->TableService->Jobsheet);
                $this->session->set_flashdata('success_msg', 'Charges have been submitted for verification.');
                redirect(current_url());
            }

            return [
                'commentby_id'  => $commentby_id,
                'js'            => $js,
                'charge'        => $charge,
                'otherCharge'   => $otherCharge,
                'svcCharge'     => $svcCharge,
                'totalCharge'   => $totalCharge,
                'attc'          => $attc
            ];
        }

        private function action($otherCharge, $js_id, $js, $commentby_id){
            if(isset($_POST['save_all'])){
                $price_input    = $this->input->post('price');

                if($price_input){
                    # first update of js charge
                    foreach ($price_input as $charge_id => $price) {
                        $charge = $this->JobsheetService->_charge_detail($charge_id);
                        $this->DatabaseModel->updateData(['id' => $charge_id], [
                            'price'  => $price,
                            'amount' => $price * $charge['qty']
                        ], $this->TableService->JsCharge);
                    }
                }

                $this->update_other_charge($js['task_id'], $js_id, $otherCharge);
                $this->update_js_service_charge($js_id);
                $this->upload_attc($js_id);

                $this->JobsheetService->_calculate_total_charge($js_id, 'other');
                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['SaveAltServiceCharge'])){
                $this->update_service_type($js['task_id'], $js_id, $js, $commentby_id);
                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['return_js'])){
                $this->DatabaseModel->updateData(['id' => $js_id], [
                    'internal_verify'       => 0,
                    'manager_verify'        => 0,
                    'admin_verify'          => 0,
                    'account_verify'        => 0,
                    'verification_status'   => 0
                ], $this->TableService->Jobsheet);

                $verifyData = [
                    'manager_verify' => 0,
                    'admin_verify'   => 0,
                    'account_verify' => 0
                ];

                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsCharge);
                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsOtherCharge);

                $this->session->set_flashdata('success_msg', 'Jobsheet has been returned. ALT can now edit this jobsheet.');
                redirect(current_url());
            }

            if(isset($_POST['del_toll'])){
                $attc_id = $this->input->post('del_toll');
                $this->JobsheetService->_delete_attc($attc_id);
                redirect(current_url());
            }

            if(isset($_POST['del_parking'])){
                $attc_id = $this->input->post('del_parking');
                $this->JobsheetService->_delete_attc($attc_id);
                redirect(current_url());
            }
        }

        private function update_other_charge($task_id, $js_id, $otherCharge){
            $toll           = $this->input->post('toll');
            $parking        = $this->input->post('parking');

            $otherChargeData = [
                'toll'           => $toll,
                'parking'        => $parking,
            ];

            if(!empty($otherCharge)){
                $this->DatabaseModel->updateData(['id' => $otherCharge['id']], $otherChargeData, $this->TableService->JsOtherCharge);
            } else {
                $otherChargeData['task_id'] = $task_id;
                $otherChargeData['js_id']   = $js_id;
                $this->DatabaseModel->createData($otherChargeData, $this->TableService->JsOtherCharge);
            }
        }

        private function upload_attc($js_id){
            $upload_path = UPLOAD_PATH.'/receipt';

            if(!empty($_FILES['toll_file']['name'][0])){
                $TollFiles = $this->MediaService->_upload_multi_images($upload_path, $_FILES['toll_file'], 'toll_file');
                if(!empty($TollFiles)){
                    foreach ($TollFiles as $row) {
                        $this->DatabaseModel->createData([
                            'js_id'     => $js_id,
                            'attc_type' => 'toll',
                            'file_src'  => $row['file_name']
                        ], $this->TableService->JsAttc);
                    }
                }
            }

            if(!empty($_FILES['parking_file']['name'][0])){
                $ParkingFiles = $this->MediaService->_upload_multi_images($upload_path, $_FILES['parking_file'], 'parking_file');
                if(!empty($ParkingFiles)){
                    foreach ($ParkingFiles as $row) {
                        $this->DatabaseModel->createData([
                            'js_id'     => $js_id,
                            'attc_type' => 'parking',
                            'file_src'  => $row['file_name']
                        ], $this->TableService->JsAttc);
                    }
                }
            }
        }

        private function update_js_service_charge($js_id){
            if(isset($_POST['svc_name'])){
                $svc_name_input          = $this->input->post('svc_name');
                $svc_selling_price_input = $this->input->post('svc_selling_price');

                foreach ($svc_name_input as $svc_chargeid => $svc) {
                    $svc_selling_price = $svc_selling_price_input[$svc_chargeid];

                    $SvcChargeData = [
                        'name'          => $svc,
                        'selling_price' => $svc_selling_price,
                    ];

                    $ServiceCharge = $this->JobsheetService->_service_charge_detail($js_id);
                    if(!empty($ServiceCharge)){
                        $SvcChargeData['modified_date'] = getCurrentTimeStamp();
                        $SvcChargeData['is_edited']     = true;

                        $this->DatabaseModel->updateData(['id' => $svc_chargeid], $SvcChargeData, $this->TableService->JsServiceCharge);
                    } else {
                        $SvcChargeData['created_date'] = getCurrentTimeStamp();
                        $this->DatabaseModel->createData($SvcChargeData, $this->TableService->JsServiceCharge);
                    }
                }
            }
        }

        private function update_service_type($task_id, $js_id, $js, $commentby_id){
            $service_type     = $this->input->post('service_type');
            $remark           = $this->input->post('remark');
            $altServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);
            
            $this->DatabaseModel->updateData(['id' => $altServiceCharge['id']], [
                'service_type' => (int)$service_type,
            ], $this->TableService->JsAltServiceCharge);

            $all_today_js = $this->loadAllTodayJs($task_id, $js, $commentby_id);

            $first_js           = $all_today_js[0];
            $last_js            = $all_today_js[getLastKey($all_today_js)];
            $js['related_js']   = $all_today_js;
            $js['js_durations'] = $this->JobsheetService->_time_diff($first_js['attnd']['check_in'], $last_js['attnd']['check_out']);

            $this->JobsheetService->_calculate_service_charge($js, $js_id, $rate=null, 'alt');
            $this->JobsheetService->_calculate_total_charge($js_id, 'other');
            $this->DatabaseModel->updateData(['js_id' => $js_id], [
                'remark' => $remark
            ], $this->TableService->JsTotalCharge);

            $AltServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);
        }

    /* START :: PRIVATE FUNCTION */
        private function loadOtherChargeDetail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], $this->TableFieldService->JsOtherCharge, $this->TableService->JsOtherCharge);
        }

        private function loadAllTodayJs($task_id, $js, $commentby_id){
            $sql = 'SELECT '.$this->TableFieldService->Jobsheet.' FROM '.$this->TableService->Jobsheet.'
                    WHERE task_id = '.$task_id.'
                    AND commentby_id = '.$commentby_id.'
                    AND DATE_FORMAT(created_date, "%Y-%m-%d") = "'.date('Y-m-d', strtotime($js['created_date'])).'"
                    ORDER BY code ASC';
            $AllTodayJs   = $this->DatabaseModel->readArrayQuery($sql);

            $all_today_js = [];
            if(!empty($AllTodayJs)){
                foreach ($AllTodayJs as $k => $val) {
                    $all_today_js[$k] = $val;
                    $all_today_js[$k]['attnd'] = $this->JobsheetService->_task_attnd_detail($val['taskattnd_id']);
                }
            }

            return $all_today_js;
        }

}