<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class ALT_Service extends MY_Service {
    private $data             = [];

    public static $conf_role  = '';
    public static $conf_dep   = '';
    private static $file_view = '';

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/JobsheetService'                   => 'JobsheetService',
        'SettingService'                        => 'SettingService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('deparment');

        if($this->session->userLogged['department_id'] == UserService::DEP_HR){
            self::$file_view = 'default/hr/task/default/comments/';
        } else {
            self::$file_view = 'default/operation/task/default/comments/';
        }
    }
    
    /* START :: MAIN */
        public function _load_main_component($task_id, $task, $js, $js_id){
            $commentby_id   = !empty($js['commentby_id']) ? $js['commentby_id'] : 0;
            $rate           = $this->TaskService->_lst_rate();

            $charge = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id,
            ], $this->TableFieldService->JsCharge, 'id ASC', $this->TableService->JsCharge);

            $all_today_js = $this->loadAllTodayJs($task_id, $js, $commentby_id);

            $first_js           = $all_today_js[0];
            $last_js            = $all_today_js[getLastKey($all_today_js)];
            $js['related_js']   = $all_today_js;
            // $js['js_durations'] = $this->JobsheetService->_time_diff($first_js['attnd']['check_in'], $last_js['attnd']['check_out']);
            $js['js_durations'] = 0;

            if(!empty($all_today_js)){
                foreach ($all_today_js as $k => $val) {
                    $js['js_durations'] = $js['js_durations'] + $val['attnd']['duration'];
                }
            }

            $this->JobsheetService->_calculate_service_charge($js, $js_id, $rate=null, 'alt');

            $otherCharge      = $this->loadOtherChargeDetail($js_id);
            $svcCharge        = $this->JobsheetService->_all_service_charge($js_id);
            $totalCharge      = $this->JobsheetService->_total_charge_detail($js_id);
            $altServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);
            $attc             = $this->JobsheetService->_attc_list($js_id);

            // print_array($altServiceCharge); exit();

            # do calculation just in case the system failed to update from the previous session
            $this->JobsheetService->_calculate_total_amount($js_id);
            $this->JobsheetService->_calculate_total_charge($js_id, 'alt');
            $refresh = $this->altAction($otherCharge, $js_id, $js, $commentby_id);  // true : false

            return [
                'commentby_id'  => $commentby_id,
                'rate'          => $rate,
                'charge'        => $charge,
                'all_today_js'  => $all_today_js,
                'first_js'      => $first_js,
                'last_js'       => $last_js,
                'js'            => $js,
                'otherCharge'   => $otherCharge,
                'svcCharge'     => $svcCharge,
                'totalCharge'   => $totalCharge,
                'altServiceCharge' => $altServiceCharge,
                'attc'          => $attc,
                'refresh'       => $refresh
            ];
        }

        private function altAction($otherCharge, $js_id, $js, $commentby_id){
            $refresh = false;

            if(isset($_POST['save_all'])){
                $price_input    = $this->input->post('price');
                $cost_input     = $this->input->post('cost');

                if($price_input){
                    # first update of js charge
                    foreach ($price_input as $charge_id => $price) {
                        $this->DatabaseModel->updateData(['id' => $charge_id], ['price' => $price], $this->TableService->JsCharge);
                    }
                }

                $this->update_js_charge($cost_input, $js_id);
                $this->update_other_charge($js['task_id'], $js_id, $otherCharge);
                $this->update_js_service_charge($js_id);
                $this->upload_attc($js_id);

                $this->JobsheetService->_calculate_total_charge($js_id, 'alt');
                $this->session->set_flashdata('success_msg', updateMsg());
                $refresh = true;
            }

            if(isset($_POST['SaveAltServiceCharge'])){
                $this->update_service_type($js['task_id'], $js_id, $js, $commentby_id);
                $this->session->set_flashdata('success_msg', updateMsg());
                $refresh = true;
            }

            if(isset($_POST['return_js'])){
                $this->DatabaseModel->updateData(['id' => $js_id], [
                    'internal_verify'       => 0,
                    'manager_verify'        => 0,
                    'admin_verify'          => 0,
                    'account_verify'        => 0,
                    'verification_status'   => 0
                ], $this->TableService->Jobsheet);

                $verifyData = [
                    'manager_verify' => 0,
                    'admin_verify'   => 0,
                    'account_verify' => 0
                ];

                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsCharge);
                $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, $this->TableService->JsOtherCharge);

                $this->session->set_flashdata('success_msg', 'Jobsheet has been returned. ALT can now edit this jobsheet.');
                $refresh = true;
            }

            if(isset($_POST['del_toll'])){
                $attc_id = $this->input->post('del_toll');
                $this->JobsheetService->_delete_attc($attc_id);
                $refresh = true;
            }

            if(isset($_POST['del_parking'])){
                $attc_id = $this->input->post('del_parking');
                $this->JobsheetService->_delete_attc($attc_id);
                $refresh = true;
            }

            return $refresh;
        }

        public function update_other_charge($task_id, $js_id, $otherCharge){
            $toll           = $this->input->post('toll');
            $parking        = $this->input->post('parking');
            $mileage        = $this->input->post('mileage');
            $mileage_charge = 0;

            if($mileage > 0){
                $mileage_charge = $mileage * (1.95 / 13);
            }

            $otherChargeData = [
                'mileage'        => $mileage*100,
                'mileage_charge' => $mileage_charge*100,
                'toll'           => $toll*100,
                'parking'        => $parking*100,
                'net_total_charges' => ($mileage_charge + $toll + $parking)*100
            ];

            if(!empty($otherCharge)){
                $this->DatabaseModel->updateData(['id' => $otherCharge['id']], $otherChargeData, $this->TableService->JsOtherCharge);
            } else {
                $otherChargeData['task_id'] = $task_id;
                $otherChargeData['js_id']   = $js_id;
                $this->DatabaseModel->createData($otherChargeData, $this->TableService->JsOtherCharge);
            }
        }

        public function upload_attc($js_id){
            $upload_path = UPLOAD_PATH.'/receipt';

            if(!empty($_FILES['toll_file']['name'][0])){
                $TollFiles = $this->MediaService->_upload_multi_images($upload_path, $_FILES['toll_file'], 'toll_file');
                if(!empty($TollFiles)){
                    foreach ($TollFiles as $row) {
                        $this->DatabaseModel->createData([
                            'js_id'     => $js_id,
                            'attc_type' => 'toll',
                            'file_src'  => $row['file_name']
                        ], $this->TableService->JsAttc);
                    }
                }
            }

            if(!empty($_FILES['parking_file']['name'][0])){
                $ParkingFiles = $this->MediaService->_upload_multi_images($upload_path, $_FILES['parking_file'], 'parking_file');
                if(!empty($ParkingFiles)){
                    foreach ($ParkingFiles as $row) {
                        $this->DatabaseModel->createData([
                            'js_id'     => $js_id,
                            'attc_type' => 'parking',
                            'file_src'  => $row['file_name']
                        ], $this->TableService->JsAttc);
                    }
                }
            }
        }

        private function update_js_service_charge($js_id){
            if(isset($_POST['svc_name'])){
                $svc_name_input          = $this->input->post('svc_name');
                $svc_selling_price_input = $this->input->post('svc_selling_price');
                $svc_total_input         = $this->input->post('svc_total');

                foreach ($svc_name_input as $svc_chargeid => $svc) {
                    $svc_selling_price = $svc_selling_price_input[$svc_chargeid];
                    $svc_total         = $svc_total_input[$svc_chargeid];

                    $SvcChargeData = [
                        'name'          => $svc,
                        'selling_price' => $svc_selling_price,
                        'total'         => $svc_total,
                    ];

                    $ServiceCharge = $this->JobsheetService->_service_charge_detail($js_id);
                    if(!empty($ServiceCharge)){
                        $SvcChargeData['modified_date'] = getCurrentTimeStamp();
                        $SvcChargeData['is_edited']     = true;

                        $this->DatabaseModel->updateData(['id' => $svc_chargeid], $SvcChargeData, $this->TableService->JsServiceCharge);
                    } else {
                        $SvcChargeData['created_date'] = getCurrentTimeStamp();
                        $this->DatabaseModel->createData($SvcChargeData, $this->TableService->JsServiceCharge);
                    }
                }
            }
        }

        private function update_js_charge($cost_input, $js_id){
            # second update of js charge
            $charge = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id' => $js_id
            ], $this->TableFieldService->JsCharge, 'id ASC', $this->TableService->JsCharge);

            if(isset($cost_input) && !empty($cost_input)){
                foreach ($cost_input as $charge_id => $cost) {
                    $index          = array_search($charge_id, array_column($charge, 'id'));
                    $total_cost     = $charge[$index]['qty'] * $cost;
                    $margin_profit  = (60/100);
                    $profit_sharing = ($charge[$index]['amount'] > $total_cost) ? ($charge[$index]['amount'] - $total_cost) * (60/100) : 0;
                    $total          = $profit_sharing + $total_cost;

                    $costData = [
                        'cost'           => $cost,
                        'margin_profit'  => $margin_profit,
                        'profit_sharing' => $profit_sharing,
                        'total'          => $total
                    ];
                    // print_array($costData); exit();
                    $this->DatabaseModel->updateData(['id' => $charge_id], $costData, $this->TableService->JsCharge);
                }
            }
        }

        private function update_service_type($task_id, $js_id, $js, $commentby_id){
            $service_type     = $this->input->post('service_type');
            $remark           = $this->input->post('remark');
            $altServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);
            
            $this->DatabaseModel->updateData(['id' => $altServiceCharge['id']], [
                'service_type' => (int)$service_type,
            ], $this->TableService->JsAltServiceCharge);

            $all_today_js = $this->loadAllTodayJs($task_id, $js, $commentby_id);

            $first_js           = $all_today_js[0];
            $last_js            = $all_today_js[getLastKey($all_today_js)];
            $js['related_js']   = $all_today_js;
            $js['js_durations'] = $this->JobsheetService->_time_diff($first_js['attnd']['check_in'], $last_js['attnd']['check_out']);

            $this->JobsheetService->_calculate_service_charge($js, $js_id, $rate=null, 'alt');
            $this->JobsheetService->_calculate_total_charge($js_id, 'alt');
            $this->DatabaseModel->updateData(['js_id' => $js_id], [
                'remark' => $remark
            ], $this->TableService->JsTotalCharge);

            $AltServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);
        }

    /* START :: PRIVATE FUNCTION */
        private function loadOtherChargeDetail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], '*', $this->TableService->JsOtherCharge);
        }

        public function loadAllTodayJs($task_id, $js, $commentby_id){
            $sql = 'SELECT * FROM Jobsheet
                    WHERE task_id = '.$task_id.'
                    AND commentby_id = '.$commentby_id.'
                    AND DATE_FORMAT(created_date, "%Y-%m-%d") = "'.date('Y-m-d', strtotime($js['created_date'])).'"
                    ORDER BY code ASC';
            $AllTodayJs   = $this->DatabaseModel->readArrayQuery($sql);

            $all_today_js = [];
            if(!empty($AllTodayJs)){
                foreach ($AllTodayJs as $k => $val) {
                    $all_today_js[$k] = $val;

                    # duration is in minutes 
                    $all_today_js[$k]['attnd'] = $this->DatabaseModel->readOneQuery(
                        'SELECT *, TIMESTAMPDIFF(MINUTE, check_in, check_out) AS duration 
                         FROM TaskAttendance 
                         WHERE id = '.$val['taskattnd_id']
                    );
                    $all_today_js[$k]['totalCharge'] = $this->JobsheetService->_total_charge_detail($val['id']);
                    $all_today_js[$k]['altServiceCharge'] = $this->JobsheetService->_alt_service_charge_detail(
                        $val['task_id'], $val['id'], $val['created_date']
                    );
                }
            }

            return $all_today_js;
        }

}