<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class TableFieldService extends MY_Service {
    # ACCESS GROUPS
    public $Access                  = 'id, group_id, group_index, access_code, access_level, created_date, created_by';
    public $AccessGrp               = 'id, department_id, name, created_date, created_by, modified_date';
    public $AccessGroup_Supplier    = '*';

    # ATTENDANCE
    public $Attnd                   = 'id, attnddate_id, user_id, checkin, checkout, shift_id, platform, checkout_platform, ip_address, location_type_in, location_type_out, office_id, customer_id, remark_in, remark_out, location_in, location_out';
    public $AttndDate               = 'id, user_id, created_date';
    public $OT                      = 'id, attnd_otdate_id, request_id, user_id, checkin, checkout, shift_id, platform, checkout_platform, ip_address, location_type_in, location_type_out, office_id, customer_id, remark_in, remark_out, location_in, location_out, is_remote';
    public $OTDate                  = 'id, user_id, created_date';
    public $OTRequest               = 'id, user_id, department_id, description, rq_date, duration, start_time, is_approved, manager_remark, approval_date, approvedby_id, status, created_date, completed_date, is_remote, is_midnight';
    public $OTRequestTaskLinked     = 'id, request_id, task_type, task_id';
    public $OTSetting               = 'id, min_gap';

    # CALENDAR 
    public $CalendarHols            = 'id, holiday_type, iCalUID, status, created, updated, summary, description, region, start, end, month, year';

    # TIME TABLE CHARGES
    public $lst_Rate                = 'ChargeRateLST';
    public $alt_Rate                = 'ChargeRateALT';

    # GENERAL CLAIM
    public $Claim                   = 'id, user_id, department_id, claim_source, task_id, cust_id, claimcompany_id, company_receipt_name, receipt_date, receipt_amt, remarks, created_date, days, voucher_date, voucher_no, actual_paid_date, can_claim, pc_no, work_area, spc, receipt_no, toll_in, toll_out, remark, tx_code, oc, sql_vn, project_id, claimcategory_id, claimaccount_id, claim_amt, account_remark, verifiedby_id';
    public $ClaimAcc                = 'id, claimcategory_id, department_id, code, remark';
    public $ClaimAttc               = 'id, pc_no, attc_type, claim_id, claimlist_id, file_src';
    public $ClaimCat                = 'id, title, acc_code, remark, is_spc';
    public $ClaimLinkedCust         = 'id, pc_no, claim_id, cust_id';
    public $ClaimList               = 'id, claim_id, claimcategory_id, claim_amt';
    public $ClaimPayment            = 'voucher_no, pay_voucher_no, pay_date,bank_name, ref_no, created_date';
    public $ClaimVoucher            = 'voucher_no, user_id, voucher_date, created_date, modified_date, status, total_claim, total_claimable';

    # CONFIG
    public $ClaimCompany            = 'id, name, remark';
    public $ClaimPrefix             = 'id, pc_no, voucher_no';
    public $ClaimSPC                = 'id, state_id, standard_litre, spc, petrol_price';
    public $ClaimSPC_price          = '*';

    # COMPANY 
    public $Company                 = '*';
    public $Branch                  = '*';
    public $CompanyCodeName         = 'id, ref, ref_id, code_name, is_active';

    # COMPANY SETTING
    public $CompanySetting_ControlAccCode   = '*';
    public $CompanySetting_CreditTerms      = '*';
    public $CompanySetting_SupplierCategory = '*';

    # CUSTOMER
    public $Customer                = 'id, user_id, company_name, code_name, acc_code, hq_id, company_code, branch_code, email, phone_no, hp_no';

    # DASHBOARD SETTING
    public $DashSet                 = 'id, user_id, module, prio';

    # EMPLOYEE
    public $Emp                     = 'id, user_id, fullname, code_name, ic, email, phone_no, hp_no, profile_img, upperline_id, department_id, team_id, employment_type_id, shift_id, date_joined, basic_salary, daily_rate, hourly_rate, epf, socso, sip, staff_fund, staff_fund_effective, location';
    public $EmpShift                = 'id, user_id, shift_id';

    # DUTY
    public $DutyCalendar            = 'id, dutyconfig_id, year, date, start_time, end_time, start_break, end_break, holiday_id, is_off, shift_id, weekday, start_date, end_date';
    public $DutyConfig              = 'id, user_id, effective_date, duty_code, working_days, working_hours, setting_type, is_default, rotation_days';

    # HARDWARE
    public $HardwareListing         = 'id, category_id, SSN, item_desc, cost';

    # INVOICE
    public $Invoice_Purchase        = '*';

    #ITEM
    public $Item                    = '*';
    public $ItemGroup               = '*';
    public $ItemLocation            = '*';

    # JOBSHEET
    public $Jobsheet                = '*';
    public $JsAltServiceCharge      = 'id, task_id, js_ids, date, total, service_type';
    public $JsAttc                  = 'id, js_id, attc_type, file_src';
    public $JsCharge                = 'id, task_id, js_id, charge_type, category_id, ssn, description, qty, price, amount, cost, total_cost, margin_profit, profit_sharing, total, total_amount, invoice_src, created_date, modified_date, is_edited, internal_verify, manager_verify, admin_verify, account_verify';
    public $JsItem                  = '*';
    public $JsOtherCharge           = 'id, task_id, js_id, service, mileage, mileage_charge, toll, parking, delivery, delivery_charge, created_date, modified_date, is_edited, internal_verify, manager_verify, admin_verify, account_verify';
    public $JsServiceCharge         = 'id, task_id, js_id, name, charge, selling_price, total, created_date, modified_date, is_edited';
    public $JsTotalCharge           = 'id, js_id, selling_price, total, grand_total, remark, is_locked';

    # LEAVE
    public $LeaveApp                = 'id, user_id, entitlements_id, leave_date, from_date, to_date, start_datetime, end_datetime, days, reason, cancel_reason, status, approvedby_id, comment, director_comment, management_remark, director_remark, modified_date, created_date, last_balance, is_half_day, session';
    public $Entitlements            = 'id, user_id, leave_id, days, month, initial_balance, used_type, used, balance, year, is_expired';

    # NOTIFICATIONS
    public $Notifications           = '*';
    public $NotificationsReceiver   = '*';

    # OPTIONS
    public $ClientType              = 'OptClientType';
    public $Dept                    = 'id, title, code_name';
    public $EmpType                 = 'id, title';
    public $HardwareCat             = 'id, name';
    public $Leave                   = 'id, title, code_name, category, days, month, is_default, is_payslip_ref, sequence, salary_deduction_applied';
    public $Nationality             = 'id, code, altcode, numeric_code, country_name, nationality_title, status, priority_order';
    public $Office                  = 'id, name, is_default';
    public $PermissionSetting       = 'id, department_id, permission_type, permission_code, remark';
    public $Project                 = 'id, title, remark, createdby_id, created_date';
    public $Role                    = 'id, title, remarks, position';
    public $RoleCategory            = 'id, role_id, title';
    public $Shift                   = 'id, title, start_time, end_time, start_break, end_break';
    public $State                   = 'id, nationality_id, code, state_name, status';
    public $Team                    = 'id, department_id, title, description';
    public $UserType                = 'id, title';

    # PAYSLIP
    public $Payslip                 = '*';
    public $PayslipAdditional       = 'id, payslip_id, item_type, item_name, amount, amount_type';
    public $PayslipConfig           = 'id, epf, socso, sip, pcb';
    public $PayslipConfig_allowance = 'id, user_id, travel_p3_check, travel_p3, travel_c_check, travel_c, shift_rotation_check, shift_rotation, attnd_check, attnd, special_check, special, special_name, staff_fund';

    # ATT!! WE WILL USE THE RATE INSTEAD
    public $PayslipConfig_epf       = 'id, min, max, employer, employee, tota_contribution';
    public $PayslipConfig_EpfRate   = 'id, employee, employer';
    public $PayslipConfig_pcb       = 'id, min, max, rate';
    public $PayslipConfig_PcbRate   = 'id, min, max, employee, employer, employee2, employer2, is_exceed';
    public $PayslipConfig_sip       = 'id, more_than, less_than, wages_up_to, employer, employee, tota_contribution';
    public $PayslipConfig_SipRate   = 'id, employee, employer';
    public $PayslipConfig_socso     = 'id, more_than, less_than, wages_up_to, employer, employee, tota_contribution, by_employer_only';
    public $PayslipConfig_SocsoRate = 'id, employee, employer';
    public $PayslipDeduction        = '*';
    public $PayslipNote             = 'id, user_id, payslip_id, leave_id, days';

    # SETTINGS
    public $SetEmp                  = 'id, user_id, permission_id, is_permitted';
    public $SetTeam                 = 'id, department_id, optteam_id, type_id, config_name';

    # SMARTER TASK
    public $SmarterTask             = 'id, ticket_id, cust_id, title, description, requested_by, createdby_id, modifiedby_id, submittedby_id, approvedby_id, planned_date, planned_time, created_date, modified_date, status';
    public $SmarterTaskAssign       = 'id, smarter_task_id, user_id';

    # TASK
    public $Task                    = 'id, ticket_id, taskcategory_id, task_subcategory_id, cust_id, company_code, branch_code, pc_no, title, description, requested_by, createdby_id, modifiedby_id, submittedby_id, approvedby_id, planned_date, planned_time, created_date, modified_date, submit_date, approval_date, status, is_checkin_attnd, codename_id, group_id, customer_temp_name, duration, completed_date, closed_date, task_minutes_duration';
    public $TaskAssign              = 'id, task_id, department_id, team_id, user_id';
    public $TaskAttnd               = 'id, task_id, user_id, check_in, check_out, date, sys_remark';
    public $TaskCat                 = 'id, title';
    public $TaskComment             = 'id, js_id, refer_to, jobsheet_type, task_id, commentby_id, comment_type, comment, created_date, modified_date, is_edited, taskattnd_id, is_verified, internal_verify';
    public $TaskSubCat              = 'id, taskcategory_id, title';
    # PRINTING
    public $TaskTempPrint           = 'id, task_id, createdby_id, created_date';
    public $TaskTempPrintComment    = 'id, taskprint_id, comment_id';

    # USERS DETAILS
    public $User                    = 'id, company_id, role_id, username, is_active, reg_by, created_date, with_employment, group_id';
    public $UserAddr                = 'id, ref, ref_id, user_id, addr_line1, addr_line2, postcode, city, state, country';
    public $UserRecovery            = '';

    public function __construct(){
        parent::__construct();
    }
}