<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class PurchaseService extends MY_Service {
    private $data = [];
    protected static $tbl;

	function __construct(){
        parent::__construct();
    }
    
    public function _all_invoices_by_supplier($supplier_codename_id=null){
        $invoices = $this->DatabaseModel->readArrayWithOptionsOrderBy([
            'supplier_codename_id' => $supplier_codename_id
        ], '*', 'created_date DESC', 'Invoice_Purchase');

        if(!empty($invoices)){
            foreach($invoices as $k => $val){
                $invoices[$k]['terms'] = $this->SettingService->_credit_terms_by_id($val['credit_terms_id']);
                $invoices[$k]['agent'] = $this->UserService->_employee_detail($val['agent_id']);
                $invoices[$k]['location'] = $this->SettingService->_location_by_id($val['location_id']);
                $invoices[$k]['files'] = $this->_all_invoice_files($val['id']);
            }
        }

        return $invoices;
    }

    public function _all_invoice_files($invoice_id=null){
        $files = $this->DatabaseModel->readArrayWithOptions([
            'invoice_id' => $invoice_id, 
            'invoice_type' => 'purchase'
        ], '*', 'Invoice_Files');

        if(!empty($files)){
            foreach($files as $k => $val){
                $files[$k]['url'] = !empty($val['file_name']) ? LIB_URL.'receipt/'.$val['file_name'] : '#';
            }
        }

        return $files;
    }
}