<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class OP_TaskService extends MY_Service {

    private $data            = [];

    public static $conf_role = '';
    public static $conf_dep  = '';

    const _OPEN         = 0;
    const _INPROGRESS   = 1;
    const _COMPLETED    = 2;
    const _CLOSED       = 3;

    const _STATUS = ['Open', 'In Progress', 'Completed', 'Closed'];

    private $Services = [
        'task/TaskService' => 'TaskService',
    ];

	function __construct(){
        parent::__construct();
        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('deparment');
    }

	public function getTaskStatus($status){
        switch ($status) {
            case self::_INPROGRESS:
                return '<span class="fa fa-circle text-orange"></span> In Progress';
                break;
            case self::_COMPLETED:
                return '<span class="fa fa-circle text-green"></span> Completed';
                break;
            case self::_CLOSED:
                return '<span class="fa fa-circle text-red"></span> Closed';
                break;
            default:
                return '<span class="fa fa-circle text-gray"></span> Open';
                break;
        }
	}

    /**
     * THIS SECTION IS TO BE RE-ORGANISED
     * standardise all variable naming to start with _
     */

    /* START :: VIEW */
        public function _last_attnd_record($task_id, $user_id){
            return $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id, 'user_id' => $user_id], 'id, check_in, check_out', 'id DESC', $this->TableService->TaskAttnd);
        }












    /************************************************************************************************************************************************/
    /************************************************************************************************************************************************/





    /* START :: DEFAULT */
        public function getOperator($task_type=null){
            if($task_type){
                if($task_type === 'today'){
                    $operator = '=';
                } else if($task_type === 'previous'){
                    $operator = '<';
                } else {
                    $operator = '>';
                }
            } else {
                $operator = '=';
            }
            return $operator;
        }

        public function getTaskListing($tasks){
            if(!empty($tasks)){
                foreach ($tasks as $k => $val) {
                    $task[$k] = $val;
                    $task[$k]['customer']     = $this->OP_TaskService->getCustomerDetail($val['cust_id']);
                    $task[$k]['creator']      = $this->OP_TaskService->getUserDetail($val['createdby_id']);
                    $task[$k]['assigned']     = $this->OP_TaskService->getAssignedTo($val['id']);
                    $task[$k]['category']     = isset($val['taskcategory_id']) ? $this->TaskService->_category_detail($val['taskcategory_id']) : [];
                    $task[$k]['sub_category'] = isset($val['task_subcategory_id']) ? $this->TaskService->_sub_category_detail($val['task_subcategory_id']) : [];
                }
            }
            return isset($task) ? $task : [];
        }

        public function getCustomerListing(){
            return $this->DatabaseModel->readArrayOrderBy('id, user_id, code_name', 'code_name ASC', $this->TableService->Customer);
        }

        /**
        * Filter by select customer name || search title
        * @param $title = Task title in string
        * @param $view = uri segment(4) in URL (read in string)
        * @param $task_type = today || previous || upcoming (read in string)
        */
        public function _filter_task(){
            $customer_id = $this->input->post('customer_id');
            $title       = $this->input->post('title');
            $view        = $this->input->get('view');
            $task_type   = $this->input->post('task_type');
            $user_id     = $this->session->userLogged['id'];
            $tasks       = [];

            $operator       = !empty($view) ? '= ' : '!= ' ;
            $dateOperator   = $this->getOperator($task_type);

            $sql = 'SELECT '.$this->TableFieldService->Task.' FROM '.$this->TableService->Task;
            $sql .= ' WHERE status '.$operator.TaskService::_CLOSED;

            if(!empty($customer_id) && empty($title)){
                $sql .= ' AND cust_id = '.$customer_id;
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && !empty($title)) {
                $sql .= ' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && empty($title)){
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }
            else {
                $sql .= ' AND cust_id = '.$customer_id.' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }

            $tasks = $this->DatabaseModel->readArrayQuery($sql);

            if(!empty($tasks)){
                if($task_type === 'previous' || !empty($view)){
                    usort($tasks, function($a, $b){ return $a['planned_date'] < $b['planned_date']; });
                }

                if($this->session->userLogged['role_id'] == UserService::_STAFF){
                    $taskArr = $this->OP_TaskService->getTaskListing($tasks);

                    foreach ($taskArr as $k => $val) {
                        if(!empty($val['assigned'])){
                            foreach ($val['assigned'] as $k2 => $assigned) {
                                if($assigned['user_id'] == $user_id || $val['createdby_id'] == $user_id){
                                    $task[] = $val;
                                }
                            }
                        }
                    }
                } else {
                    $task = $this->OP_TaskService->getTaskListing($tasks);
                }
            }

            return isset($task) ? $task : [];
        }

    /* START :: CREATE */
        public function create(){
            $user_id = $this->session->userLogged['id'];

            $customer = $this->DatabaseModel->readArray('user_id, company_name, code_name', $this->TableService->Customer);
            $user     = $this->getEmployeeDetail($user_id);
            if(!empty($user)){
                $user['department'] = self::$conf_dep[$user['department_id']];
                $team               = $this->getTeams($user['department_id']);
            }

            $this->data['customer'] = $customer;
            $this->data['user']     = $user;
            $this->data['team']     = isset($team) ? $team : null;

            return $this->data;
        }

        public function getTeams($department_id){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id
            ], 'id, title', 'title ASC', $this->TableService->Team);
        }

        public function getEmployeeDetail($user_id){
            $sql = 'SELECT '.$this->TableService->User.'.id, role_id, username, fullname, code_name, department_id, team_id FROM Employee
                    LEFT JOIN '.$this->TableService->User.' ON '.$this->TableService->User.'.id = Employee.user_id
                    WHERE '.$this->TableService->User.'.id = '.$user_id;
            $employee = $this->DatabaseModel->readOneQuery($sql);

            if(!empty($employee)){
                $employee['team'] = $this->getTeamDetail($employee['team_id']);
                if(!empty($employee['team'])){
                    if($employee['role_id'] == UserService::_STAFF)
                    {
                        $employee['position'] = $employee['team']['title'];
                    } else {
                        $employee['position'] = $employee['team']['title'].' '.self::$conf_role[$employee['role_id']]['title'];
                    }
                } else {
                    $employee['position'] = null;
                }
            }
            return $employee;
        }

        public function getTeamDetail($team_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $team_id], 'title', $this->TableService->Team);
        }

        public function getUserDetail($user_id){
            $acc = $this->DatabaseModel->readOneWithOptions(['id' => $user_id], 'role_id', $this->TableService->User);
            if(!empty($acc)){
                if($acc['role_id'] == UserService::_CUSTOMER){
                    $cust = $this->getCustomerDetail($user_id);
                    $fullname = $cust['code_name'];
                } else {
                    $employee = $this->getEmployeeDetail($user_id);
                    $fullname = $employee['code_name'];
                }
            }
            return isset($fullname) ? $fullname : null;
        }

        public function getCustomerDetail($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'company_name, code_name, phone_no', $this->TableService->Customer);
        }

        public function getAssignedTo($task_id){
            $assigned = $this->DatabaseModel->readArrayWithOptions(['task_id' => $task_id], 'id, team_id, user_id', $this->TableService->TaskAssign);
            if(!empty($assigned)){
                foreach ($assigned as $k => $val) {
                    $assign[$k]             = $val;
                    $assign[$k]['team']     = $this->getTeamDetail($val['team_id']);
                    $assign[$k]['employee'] = $this->getEmployeeDetail($val['user_id']);
                }
            }
            return isset($assign) ? $assign : null;
        }

        public function getComment($task_id, $comment_type){
            $comments = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id, 'comment_type' => $comment_type
            ], 'id, commentby_id, comment, created_date, modified_date, is_verified', 'created_date DESC', $this->TableService->TaskComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['by'] = $this->getUserDetail($val['commentby_id']);
                }
            }
            return isset($comment) ? $comment : null;
        }

    /* START :: EDIT */
        public function getTaskDetail($task_id){
            $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], $this->TableFieldService->Task, $this->TableService->Task);

            if(!empty($task)){
                $task['category']           = $this->TaskService->_category_detail($task['taskcategory_id']);
                $task['sub_category']       = $this->TaskService->_sub_category_detail($task['task_subcategory_id']);
                $task['customer']           = $this->UserService->_codename_by_id($task['codename_id']);
                $task['addr']               = $this->getUserAddr($task['cust_id']);
                $task['detail']             = $this->getCompanyDetail($task['cust_id']);
                $task['creator']            = $this->getUserDetail($task['createdby_id']);
                $task['assigned']           = $this->getAssignedTo($task['id']);
                $task['internal_comment']   = $this->getComment($task_id, 1);
                $task['modified_by']        = $this->getUserDetail($task['modifiedby_id']);

                if(!empty($task['assigned'])){
                    $task['is_assigned'] = false;
                    foreach ($task['assigned'] as $row) {
                        if($row['user_id'] == $this->session->userLogged['id']){
                            $task['is_assigned'] = true;
                        }
                    }
                }
            }

            return $task;
        }

        public function getCompanyDetail($cust_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $cust_id], 'company_code, branch_code', $this->TableService->Customer);
        }

        public function getUserAddr($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id
            ], 'addr_line1, addr_line2, postcode, city, state, country', 'UserAddr');
        }

    /* START :: VIEW */
        public function getCommentListing($task_id){
            $comments = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], $this->TableFieldService->TaskComment, 'created_date DESC', $this->TableService->TaskComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['employee'] = $this->UserService->_employee_detail($val['commentby_id']);
                }
            }
            return isset($comment) ? $comment : [];
        }

        public function getTaskAttndListing($task_id){
            $taskAttnd = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, user_id, check_in, check_out, date', 'date DESC', $this->TableService->TaskAttnd);

            if(!empty($taskAttnd)){
                foreach ($taskAttnd as $k => $val) {
                    $attnd[$k] = $val;
                    $attnd[$k]['employee'] = $this->getEmployeeDetail($val['user_id']);
                    $attnd[$k]['js'] = $this->DatabaseModel->readOneWithOptions(['taskattnd_id' => $val['id']], 'code', 'Jobsheet');
                }
            }
            return isset($attnd) ? $attnd : [];
        }

        public function checkHasSignedIn($task_id, $user_id){
            return $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id, 'user_id' => $user_id, 'date' => getDateToday()
            ], 'id, check_in, check_out', 'id DESC', $this->TableService->TaskAttnd);
        }

        public function _get_signin_status($hasSignedIn){
            if(!empty($hasSignedIn)){
                if(!isEmptyTimestamp($hasSignedIn['check_in'])){
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }

        public function getCommentsByTask($task_id){
            $comments = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, js_id, jobsheet_type, commentby_id, comment_type, comment, created_date, modified_date, is_edited, taskattnd_id, is_verified', 'created_date ASC', $this->TableService->TaskComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k]             = $val;
                    $comment[$k]['employee'] = $this->getEmployeeDetail($val['commentby_id']);
                    $comment[$k]['attnd']    = $this->DatabaseModel->readOneWithOptions(['id' => $val['taskattnd_id']], 'check_in, check_out', $this->TableService->TaskAttnd);

                    if($val['comment_type'] == ManagerService::_CMT_JOBSHEET){
                        $comment[$k]['charges']       = $this->loadJsCharges($task_id, $val['id'], $val['commentby_id']);
                        $comment[$k]['total_charges'] = $this->loadJsTotalCharge($task_id, $val['id'], $val['commentby_id']);
                    }
                }
            }

            return isset($comment) ? $comment : [];
        }

        private function loadJsCharges($task_id, $comment_id, $commentby_id){
            $charges = $this->DatabaseModel->readArrayWithOptionsOrderBy([
                'task_id'       => $task_id,
                'comment_id'    => $comment_id,
                'commentby_id'  => $commentby_id
            ], 'id, ssn, description, qty, price, amount', 'id ASC', $this->TableService->JsCharge);

            if(!empty($charges)){
                foreach ($charges as $k => $val) {
                    $charge[$k] = $val;
                    $charge[$k]['others'] = $this->DatabaseModel->readOneWithOptions(['charge_id' => $val['id']
                    ], 'id, service, mileage, mileage_charge, toll, parking, delivery, delivery_charge', $this->TableService->JsOtherCharge);
                }
            }

            return isset($charge) ? $charge : [];
        }

        private function loadJsTotalCharge($task_id, $comment_id, $commentby_id){
            $totalCharge = $this->DatabaseModel->readOneWithOptions([
                'task_id'       => $task_id, 
                'comment_id'    => $comment_id, 
                'commentby_id'  => $commentby_id
            ], 'id, total', $this->TableService->JsTotalCharge);

            return !empty($totalCharge) ? $totalCharge['total'] : '0.00';
        }

    /* START :: ASSIGN */
        public function filterTeamQuery($team_id){
            return 'SELECT '.$this->TableService->User.'.id, is_active, code_name, department_id, team_id FROM Employee 
                    LEFT JOIN '.$this->TableService->User.' ON '.$this->TableService->User.'.id = Employee.user_id
                    WHERE is_active = 1 AND team_id = '.$team_id.'
                    AND role_id IN('.UserService::_STAFF.', '.UserService::_MANAGER.') ORDER BY code_name ASC';
        }

        public function AssignTaskAction($task_id){
            $user_ids = $this->input->post('user_id');
            if(!empty($user_ids)){
                foreach ($user_ids as $user_id) {
                    $hasAssigned = $this->DatabaseModel->readOneWithOptions(['task_id' => $task_id, 'user_id' => $user_id
                    ], 'id', $this->TableService->TaskAssign);

                    if(empty($hasAssigned)){
                        $emailData  = null;
                        $task       = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'ticket_id, title, description, planned_date', 'Task');
                        if(!empty($task)){
                            $emailData = [
                                'ticket_no'     => $task['ticket_id'],
                                'title'         => $task['title'],
                                'description'   => $task['description'],
                                'planned_date'  => sysDateFormat($task['planned_date']),
                                'img_url'       => base_url('assets/images/icons/task-icon.png')
                            ];
                        }
                        $user = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'email, code_name', 'Employee');
                        if(!empty($user) && !empty($user['email'])){
                            $this->notifyEmail($emailData, [
                                'to_email' => $user['email'],
                                'to_name'  => $user['code_name']
                            ]);
                        }
                        $this->DatabaseModel->createData([
                            'task_id' => $task_id,
                            'user_id' => $user_id
                        ], $this->TableService->TaskAssign);
                    }
                }
            }
        }

        private function notifyEmail($emailData=null, $toData=null){
            if(!empty($emailData)){
                $this->load->library('email');

                $message = $this->load->view(ROOT_TPL.'email/new-task.email.php', $emailData, true);

                $this->email->initialize(sendgridConfig());
                $this->email->from('noreply@smarter.com.my', 'SSMS Automail');
                // $this->email->to('testing.mael@gmail.com', $codenameDetails['company']['company_name']);
                $this->email->to($toData['to_email'], $toData['to_name']);

                $this->email->subject('NEW TASK #'.$emailData['ticket_no']);
                $this->email->message($message);
                $this->email->send();
            }
        }

    /* START :: START & END TASK ACTIVITY */
        public function _record_checkin_task($task_id, $user_id){
            $attndData = [
                'task_id'   => $task_id,
                'user_id'   => $user_id,
                'check_in'  => getCurrentTimeStamp(),
                'date'      => getDateToday()
            ];
            $attnd_id = $this->DatabaseModel->createData($attndData, $this->TableService->TaskAttnd);

            // $this->session->set_userdata('attnd_id', $attnd_id);

            $sql = 'SELECT 
                        Task.ticket_id, 
                        Task.codename_id,
                        Task.createdby_id, 
                        Employee.code_name 
                    FROM Task
                    LEFT JOIN Employee ON Employee.user_id = Task.createdby_id
                    WHERE Task.id = '.$task_id;
            $taskDetails = $this->DatabaseModel->readOneQuery($sql);
            
            if(!empty($taskDetails)){
                $this->NotificationsService->_notify_js_start_attendance(
                    $task_id, $taskDetails['ticket_id'], $this->profile['code_name'], $taskDetails['codename_id']
                );
            }

            $taskAttnd = $this->DatabaseModel->readArrayWithOptions(['task_id' => $task_id], 'id', $this->TableService->TaskAttnd);
            if(!empty($taskAttnd)){
                /* :: task is already in progress */
                $task = $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'status', $this->TableService->Task);
                if(!empty($task)){
                    if($task['status'] == TaskService::_COMPLETED){
                        // :: do nothing
                    } else if ($task['status'] == TaskService::_CLOSED) {
                        // :: do nothing
                    } else {
                        $this->DatabaseModel->updateData(['id' => $task_id], [
                            'status' => TaskService::_INPROGRESS
                        ], $this->TableService->Task);
                    }
                }
            }
        }

        public function _record_checkout_task($hasSignedIn){
            $this->session->unset_userdata('attnd_id');

            if(!empty($hasSignedIn)){
                if(isEmptyTimestamp($hasSignedIn['check_out'])){
                    // :: if check out is empty, need to sign out
                    $this->DatabaseModel->updateData(['id' => $hasSignedIn['id']], [
                        'check_out'  => getCurrentTimeStamp()
                    ], $this->TableService->TaskAttnd);

                    return true;
                } else {
                    // :: already check out, need to start a new task session
                    return false;
                }
            } else {
                // :: hasn't check in yet, need to start a new session
                return false;
            }
        }
}