<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class MediaService extends MY_Service {

    const _IMAGE   = 0;
    const _VIDEO   = 1;

    public $video_types = [ '.MP4', '.MP3', '.WMA', '.MPG', '.MP2', '.MPEG', '.MPE', '.MPV', '.OGG', '.M4P', '.M4V', '.AVI', '.WMV', '.MOV', '.QT', '.FLV', '.SWF', '.AVCHD' ];

	function __construct()
	{
		// $this->AllOptions = $this->GetAllOptions();
	}

    /* START :: IMAGE SECTION */
    	public function upload_external_image($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 110000;

            $config['file_name'] = uniqid();

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $this->load->library('image_lib');

                if($_FILES['file_name']['size'] > $config['max_size']){
                    $configer = array(
                        'image_library'   => 'gd2',
                        'source_image'    => $uploadData['full_path'],
                        'create_thumb'    => FALSE,
                        'maintain_ratio'  => TRUE,
                        'width'           => 950,
                        'height'          => 950,
                    );

                    $this->image_lib->clear();
                    $this->image_lib->initialize($configer);
                    $this->image_lib->resize();
                }

                $configer = array(
                    'image_library'   => 'gd2',
                    'source_image'    => $uploadData['full_path'],
                    'create_thumb'    => TRUE,
                    'maintain_ratio'  => TRUE,
                    'width'           => 300,
                    'height'          => 300,
                );

                $this->image_lib->clear();
                $this->image_lib->initialize($configer);
                $this->image_lib->resize();

                $thumbName = $uploadData['raw_name'].'_thumb'.$uploadData['file_ext'];
                rename($uploadData['file_path'].$thumbName, $uploadData['file_path'].'thumb/'.$thumbName);

                return $file_name;
            } else {
                // return $this->upload->display_errors();
                return null;
            }
        }

        public function _upload_multi_images($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 110000;

            $filesCount = count($file['name']);

            if($filesCount > 0){
                $uploadedFile = null;
                for($i = 0; $i < $filesCount; $i++){
                    $_FILES['userFile']['name']     = $file['name'][$i];
                    $_FILES['userFile']['type']     = $file['type'][$i];
                    $_FILES['userFile']['tmp_name'] = $file['tmp_name'][$i];
                    $_FILES['userFile']['error']    = $file['error'][$i];
                    $_FILES['userFile']['size']     = $file['size'][$i];   

                    $config['file_name'] = uniqueId();

                    $this->load->library('image_lib');
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if($this->upload->do_upload('userFile')){
                        $uploadData = $this->upload->data();
                        $uploadedFile[$i]['file_name'] = $uploadData['file_name'];

                        if($_FILES['userFile']['size'] > $config['max_size']){
                            $this->load->library('image_lib');
                            $configer = array(
                                'image_library'   => 'gd2',
                                'source_image'    => $uploadData['full_path'],
                                'create_thumb'    => FALSE,
                                'maintain_ratio'  => TRUE,
                                'width'           => 950,
                                'height'          => 950,
                            );

                            $this->image_lib->clear();
                            $this->image_lib->initialize($configer);
                            $this->image_lib->resize();
                        }
                    }
                }
                return $uploadedFile;
            } else {
                // return $this->upload->display_errors();
                return null;
            }
        }

        /*public function upload_external_files($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 110000;

            $config['file_name'] = uniqid();

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                return $file_name;
            } else {
                // return $this->upload->display_errors();
                return null;
            }
        }*/

        public function upload_external_files($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 110000;

            $filesCount = count($file['name']);

            if($filesCount > 0){
                for($i = 0; $i < $filesCount; $i++){
                    $_FILES['userFile']['name']     = $file['name'][$i];
                    $_FILES['userFile']['type']     = $file['type'][$i];
                    $_FILES['userFile']['tmp_name'] = $file['tmp_name'][$i];
                    $_FILES['userFile']['error']    = $file['error'][$i];
                    $_FILES['userFile']['size']     = $file['size'][$i];

                    $config['file_name'] = uniqueId();

                    $this->load->library('image_lib');
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if($this->upload->do_upload('userFile')){
                        $uploadData                     = $this->upload->data();
                        $uploadedFile[$i]['file_name']  = $uploadData['file_name'];

                        if(!in_array(strtoupper($uploadData['file_ext']), $this->video_types)){
                            if($_FILES['userFile']['size'] > $config['max_size']){
                                $this->load->library('image_lib');
                                $configer = array(
                                    'image_library'   => 'gd2',
                                    'source_image'    => $uploadData['full_path'],
                                    'create_thumb'    => FALSE,
                                    'maintain_ratio'  => TRUE,
                                    'width'           => 950,
                                    'height'          => 950,
                                );

                                $this->image_lib->clear();
                                $this->image_lib->initialize($configer);
                                $this->image_lib->resize();
                            }

                            $configer = array(
                                'image_library'   => 'gd2',
                                'source_image'    => $uploadData['full_path'],
                                'create_thumb'    => TRUE,
                                'maintain_ratio'  => TRUE,
                                'width'           => 200,
                                'height'          => 200,
                            );

                            $this->image_lib->clear();
                            $this->image_lib->initialize($configer);
                            $this->image_lib->resize();

                            $thumbName = $uploadData['raw_name'].'_thumb'.$uploadData['file_ext'];
                            rename($upload_path.'/'.$thumbName, $upload_path.'/thumb/'.$uploadData['file_name']);
                        }
                    } else {
                        $err = $this->upload->display_errors();
                        // print_array($err); exit();
                    }
                }
                return isset($uploadedFile) ? $uploadedFile : null;
            } else {
                return null;
            }
        }

    /* START :: VIDEOS SECTION */
        public function upload_video($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = 'mp4';
            $config['max_size']             = 0;

            $newFileName = seoUrl(removeExt($file['name']).'-'.uniqueId());
            $new_name = $newFileName.getExt($file['name']);
            $config['file_name'] = $new_name;

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $result = array( 'status'  => TRUE, 'file_name' => $file_name );
                return $result;
            } else {
                $result = array( 'status'  => FALSE, 'details' => $this->upload->display_errors() );
                return $result;
            }
        }

        public function upload_external_video($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 0;

            $config['file_name'] = uniqid();

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                return $file_name;
            } else {
                return null;
            }
        }

        public function upload_video_thumbnail($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path.'/thumbnail';
            $config['allowed_types']        = 'jpg|jpeg|png|gif';
            $config['max_size']             = 0;

            $newFileName = seoUrl(removeExt($file['name']).'-'.uniqueId());
            $new_name = $newFileName.getExt($file['name']);
            $config['file_name'] = $new_name;

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $this->load->library('image_lib');
                $configer = array(
                    'image_library'   => 'gd2',
                    'source_image'    => $uploadData['full_path'],
                    'create_thumb'    => FALSE,
                    'maintain_ratio'  => TRUE,
                    'width'           => 500,
                    'height'          => 500,
                );

                $this->image_lib->clear();
                $this->image_lib->initialize($configer);
                $this->image_lib->resize();

                $result = array( 'status' => TRUE, 'file_name' => $file_name );
                return $result;
            } else {
                $result = array( 'status'  => FALSE, 'details' => $this->upload->display_errors() );
                return $result;
            }
        }

    /* START :: UNLINK SECTION */
        public function unlinkFile($file_path){
            if(file_exists($file_path)){ unlink($file_path); }
        }
}