<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class PayslipService extends MY_Service {

    const _FULL_WORKING_DAYS    = 26;
    const _FULL_WORKING_HOURS   = 8;  # deduct 1 hour for rest hour (working hours per day)
    const _FULL_WORKING_MIN     = 480;  # 1 hour = 60 min, 8 hours = (60 min * 8 hour) = 480 min (total working hours/day in minutes)

    private $Services = [
        'UserService'           => 'UserService',
        'LeaveService'          => 'LeaveService',
        'CalendarService'       => 'CalendarService',
        'hr/HrConfigService'    => 'HrConfigService',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: CONFIG */
    	public function _config(){
    		return $this->DatabaseModel->readOne($this->TableFieldService->PayslipConfig, $this->TableService->PayslipConfig);
    	}

    /* START :: PAYSLIP */
        public function _payslip_listing(){
            $payArr = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Payslip, 'created_date DESC', $this->TableService->Payslip);

            if(!empty($payArr)){
                foreach ($payArr as $k => $val) {
                    $pay[$k] = $val;
                    $pay[$k]['emp'] = $this->UserService->_employee_detail($val['user_id']);
                }
            }

            return isset($pay) ? $pay : [];
        }

        public function _payslip_detail($payslip_id){
            $pay = $this->DatabaseModel->readOneWithOptions(['id' => $payslip_id
            ], $this->TableFieldService->Payslip, $this->TableService->Payslip);

            if(!empty($pay)){
                $pay['emp']                 = $this->UserService->_employee_detail($pay['user_id']);
                $pay['deduct']              = $this->_pay_deduction_detail($pay['id']);
                $pay['earn']                = $this->_pay_earning_detail($pay['user_id']);
                $pay['additional']          = $this->_pay_additional($pay['id']);
                $pay['additional_earn']     = $this->_pay_additional_item($pay['id'], 'earn');
                $pay['additional_deduct']   = $this->_pay_additional_item($pay['id'], 'deduct');
                // $pay['hourly']              = number_format((($pay['emp']['basic_salary'] / 26) / 8), 2);
                // $pay['daily']               = number_format(($pay['emp']['basic_salary'] / 26), 2);
            }

            //print_array($pay); exit();

            return isset($pay) ? $pay : [];
        }

        public function _pay_deduction_detail($payslip_id){
            return $this->DatabaseModel->readOneWithOptions(['payslip_id' => $payslip_id], $this->TableFieldService->PayslipDeduction, $this->TableService->PayslipDeduction);
        }

        public function _pay_earning_detail($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], $this->TableFieldService->PayslipConfig_allowance, $this->TableService->PayslipConfig_allowance);
        }

        public function _pay_additional($payslip_id){
            return $this->DatabaseModel->readArrayWithOptions(['payslip_id' => $payslip_id], $this->TableFieldService->PayslipAdditional, $this->TableService->PayslipAdditional);
        }

        public function _pay_additional_item($payslip_id, $item_type){
            $sql = 'SELECT SUM(amount) AS amount FROM PayslipAdditional WHERE payslip_id = '.$payslip_id.' AND item_type = "'.$item_type.'"';
            return $this->DatabaseModel->readOneQuery($sql);
        }

    /* START :: CONTRIBUTION */
        public function _epf_rate(){
            return $this->DatabaseModel->readOne($this->TableFieldService->PayslipConfig_EpfRate, $this->TableService->PayslipConfig_EpfRate);
        }
        public function _socso_rate(){
            return $this->DatabaseModel->readOne($this->TableFieldService->PayslipConfig_SocsoRate, $this->TableService->PayslipConfig_SocsoRate);
        }
        public function _sip_rate(){
            return $this->DatabaseModel->readOne($this->TableFieldService->PayslipConfig_SipRate, $this->TableService->PayslipConfig_SipRate);
        }
        public function _pcb_rate(){
            return $this->DatabaseModel->readOne($this->TableFieldService->PayslipConfig_PcbRate, $this->TableService->PayslipConfig_PcbRate);
        }
    
    /* START :: LEAVE CALCULATION */
        public function _monthly_leave($payslip_month, $payslip_year, $staff_id){
            $this->_holiday_by_payslip($payslip_month, $payslip_year, $staff_id);
        }

        public function _range_date($month, $year){
            $fromYear  = $month == 1 ? $year-1 : $year;
            $fromMonth = $month == 1 ? 12 : $month-1;
            $fromDate  = $fromYear.'-'.$fromMonth.'-26';
            $toDate    = $year.'-'.$month.'-25';
            return [ 'fromDate' => $fromDate, 'toDate' => $toDate ];
        }

        private function _get_holiday($user_id, $fromDate, $toDate){
            $sql = 'SELECT COUNT(CalendarHolidays.id) AS total 
                    FROM CalendarHolidays
                    LEFT JOIN UserAddr ON UserAddr.state LIKE CONCAT("%", CONCAT(CalendarHolidays.region, "%"))
                    WHERE (DATE(start) BETWEEN "'.$fromDate.'" AND "'.$toDate.'")
                    AND UserAddr.ref = "user"
                    AND UserAddr.ref_id = '.$user_id;
            $ph = $this->DatabaseModel->readOneQuery($sql);
            return !empty($ph) ? $ph['total'] : 0;
        }

        public function _all_attnd_days_for_payslip($month, $year, $user_id, $user = null){
            $attnd      = [];
            $range_date = $this->_range_date($month, $year);
            $ph         = $this->_get_holiday($user_id, $range_date['fromDate'], $range_date['toDate']);

            # total days of the month from 26th-25th. always +1 because the getDays doesn't calculate the 1st day
            $totalDaysOfTheMonth = getDays($range_date['fromDate'], $range_date['toDate']) + 1;

            $totalSundayOT = $this->_get_sunday_ot($range_date, $user_id);

            # number of attendance record before deduction (with checkin record && >= 1 hour) includes sunday
            # this total also includes the incomplete working hours
            $totalAttndDays = $this->_get_total_attnd_days($range_date, $user_id);
            # need to filter out sunday
            $totalAttndDays = $totalAttndDays - $totalSundayOT;
            
            # the number of attendance without checkout or < 1 hour record (to + with $totalNonRecordedAttndDays later)
            $incompleteAttndDays = $this->_get_incomplete_attnd_days($range_date, $user_id);

            # the number all approved leave (AL, MC, special, unpaid)
            $approvedLeaveCount = $this->_get_leaves($range_date, $user_id);
            # we need the number of days of unpaid and paid leave because it is not included in the punch in/out attendance
            $totalUnpaidLeave = !empty($approvedLeaveCount) ? $approvedLeaveCount['total_unpaid'] : 0;
            $totalPaidLeave   = !empty($approvedLeaveCount) ? 
                $approvedLeaveCount['total_al'] + $approvedLeaveCount['total_mc'] + $approvedLeaveCount['total_special'] 
                : 0;

            $dateArr = [];
            $period  = new DatePeriod(
                new DateTime($range_date['fromDate']),
                new DateInterval('P1D'),
                new DateTime($range_date['toDate'])
            );
            foreach ($period as $date) { $dateArr[] = $date->format('Y-m-d'); }

            $totalSundays = array_filter($dateArr, function($date){
                $dayName = date('l', strtotime($date));
                return $dayName === 'Sunday';
            });

            # calculate the non recorded attendance (unallocated attendance)
            # which is working days but user did not checkin so database is unable to record it
            $totalAllAttndBeforeDeduction = $totalAttndDays + $totalPaidLeave + $totalUnpaidLeave + $ph + $incompleteAttndDays;
            $totalNonRecordedAttndDays = $totalDaysOfTheMonth - $totalAllAttndBeforeDeduction - count($totalSundays);
            $incompleteAttndDays = $incompleteAttndDays + $totalNonRecordedAttndDays;
            $finalTotalAttndDays = self::_FULL_WORKING_DAYS - $incompleteAttndDays - $totalUnpaidLeave;

            $incompleteAttndCharges = !empty($incompleteAttndDays) ? $incompleteAttndDays * $user['daily_rate'] : 0;

            $minRate = 0;
            $incompleteWorkingHoursInMins = 0;
            $netBasicSalary = 0;
            $totalMonthlyWorkingHoursInMin = 0;

            if(isset($user['hourly_rate'])){
                # $minRate = is the amount for 1 min
                # hourly_rate divide by 60 mins to get 1 min rate
                $minRate = $user['hourly_rate'] / 60;
            }

            # Get all daily working hours in minutes with date range
            $sql  = 'SELECT 
                        DISTINCT(AttendanceDate.created_date),
                        AttendanceDate.id, 
                        AttendanceDate.created_date, 
                        Attendance.checkin,
                        Attendance.checkout,
                        TIMESTAMPDIFF(MINUTE, Attendance.checkin, Attendance.checkout) AS duration -- duration is in minutes
                    FROM AttendanceDate
                    LEFT JOIN Attendance ON Attendance.attnddate_id = AttendanceDate.id
                    WHERE (DATE(Attendance.checkin) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'")
                    AND (DATE(Attendance.checkout) != "0000-00-00 00:00:00" AND Attendance.checkout IS NOT NULL)
                    AND AttendanceDate.user_id = '.$user_id;

            $monthlyWorkingHours = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($monthlyWorkingHours)){
                foreach ($monthlyWorkingHours as $k => $val) {
                    $day = date('l', strtotime($val['created_date']));
                    # rate_in_min = daily rate based on the daily working hours completed
                    if(!empty($val['duration'])){
                        if($val['duration'] >= self::_FULL_WORKING_MIN){
                            # we only take 8 hours
                            # duration = daily working hours in minutes
                            $monthlyWorkingHours[$k]['duration'] = self::_FULL_WORKING_MIN;
                            $monthlyWorkingHours[$k]['rate_in_min'] = self::_FULL_WORKING_MIN * $minRate;
                        } else {
                            if($day === 'Saturday'){
                                # 240 minutes = 4 hours
                                # full working hours on saturday is 4 hours equivalent to 8 hours
                                if($val['duration'] >= 240){
                                    $monthlyWorkingHours[$k]['duration'] = self::_FULL_WORKING_MIN;
                                    $monthlyWorkingHours[$k]['rate_in_min'] = self::_FULL_WORKING_MIN * $minRate;
                                } else {
                                    # if working hours less than 4 h, we will take the current value
                                    # eg: 2h, rate_in_min is equals to 2h (in mins)
                                    $monthlyWorkingHours[$k]['rate_in_min'] = $val['duration'] * $minRate;
                                    $incompleteWorkingHoursInMins = $incompleteWorkingHoursInMins + (self::_FULL_WORKING_MIN - $val['duration']);
                                }
                            } else {
                                $monthlyWorkingHours[$k]['rate_in_min'] = $val['duration'] * $minRate;
                                $incompleteWorkingHoursInMins = $incompleteWorkingHoursInMins + (self::_FULL_WORKING_MIN - $val['duration']);
                            }
                        }
                    } else {
                        $monthlyWorkingHours[$k]['duration'] = 0;
                        $monthlyWorkingHours[$k]['rate_in_min'] = 0;
                    }
                }

                $totalMonthlyWorkingHoursInMin = array_sum(array_column($monthlyWorkingHours, 'duration'));
                $totalMonthlyWorkingHoursInMin = ($totalMonthlyWorkingHoursInMin + (self::_FULL_WORKING_MIN * $totalPaidLeave)) - (self::_FULL_WORKING_MIN * $totalUnpaidLeave);

                $netBasicSalary = array_sum(array_column($monthlyWorkingHours, 'rate_in_min'));
                $netBasicSalary = ($netBasicSalary + ($totalPaidLeave * $user['daily_rate']) + ($ph * $user['daily_rate'])) - ($totalUnpaidLeave * $user['daily_rate']);
            } else {
                $netBasicSalary = ($netBasicSalary + ($totalPaidLeave * $user['daily_rate']) + ($ph * $user['daily_rate'])) - ($totalUnpaidLeave * $user['daily_rate']);
            }

            return [
                'normal_day'  => $finalTotalAttndDays,
                'sunday_ot'   => $totalSundayOT,
                'ot_duration' => $this->_filter_ot_hours($range_date, $user_id),
                'net_basic_salary'      => $netBasicSalary,
                'working_hours_in_min'  => $totalMonthlyWorkingHoursInMin,
                'leave_count'           => $approvedLeaveCount,
                'incomplete_attnd'      => $incompleteAttndCharges,
                'incomplete_working_hours' => $incompleteWorkingHoursInMins,
                'unpaid_leave_charges'  => $totalUnpaidLeave * $user['daily_rate'],
                'incompleteAttndDays'   => $incompleteAttndDays
            ];
        }

        private function _get_total_attnd_days($range_date, $user_id){
            $sql = 'SELECT COUNT(*) AS days FROM (
                SELECT DISTINCT(created_date) FROM (
                    SELECT AttendanceDate.* FROM AttendanceDate
                    LEFT JOIN Attendance ON Attendance.attnddate_id = AttendanceDate.id
                    WHERE (DATE(Attendance.checkin) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'")
                    AND (DATE(Attendance.checkout) != "0000-00-00 00:00:00" AND Attendance.checkout IS NOT NULL)
                    AND TIMESTAMPDIFF(HOUR, Attendance.checkin, Attendance.checkout) >= 1
                    AND AttendanceDate.user_id = '.$user_id.'
                ) attnd_days
            ) attnd_days_count';
            $totalAttndDaysRecord = $this->DatabaseModel->readOneQuery($sql);
            return !empty($totalAttndDaysRecord) ? $totalAttndDaysRecord['days'] : 0;
        }

        private function _get_incomplete_attnd_days($range_date, $user_id){
            $sql = 'SELECT COUNT(*) AS days FROM (
                SELECT DISTINCT(created_date) FROM (
                    SELECT AttendanceDate.* FROM AttendanceDate
                    LEFT JOIN Attendance ON Attendance.attnddate_id = AttendanceDate.id
                    WHERE (DATE(Attendance.checkin) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'")
                    AND 
                        (
                            (DATE(Attendance.checkout) = "0000-00-00 00:00:00" OR Attendance.checkout IS NULL OR Attendance.checkout = "")
                            OR TIMESTAMPDIFF(HOUR, Attendance.checkin, Attendance.checkout) < 1
                        )
                    AND AttendanceDate.user_id = '.$user_id.'
                ) incomplete_attnd
            ) incomplete_attnd_count';
            $incompleteAttndDaysRecord = $this->DatabaseModel->readOneQuery($sql);
            return !empty($incompleteAttndDaysRecord) ? $incompleteAttndDaysRecord['days'] : 0;
        }

        private function _get_leaves($range_date, $user_id){
            $sql  = 'SELECT * FROM (
                        SELECT SUM(LeaveApplication.days) AS total_al FROM LeaveApplication 
                        LEFT JOIN LeaveEntitlements ON LeaveEntitlements.id = LeaveApplication.entitlements_id
                        LEFT JOIN OptLeave ON OptLeave.id = LeaveEntitlements.leave_id
                        WHERE LeaveApplication.user_id = '.$user_id.' 
                        AND LeaveApplication.status = 5
                        AND OptLeave.code_name = "AL"
                        AND (DATE(LeaveApplication.from_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                        AND (DATE(LeaveApplication.to_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                    ) AS leave_al,
                    (
                        SELECT SUM(LeaveApplication.days) AS total_unpaid FROM LeaveApplication 
                        LEFT JOIN LeaveEntitlements ON LeaveEntitlements.id = LeaveApplication.entitlements_id
                        LEFT JOIN OptLeave ON OptLeave.id = LeaveEntitlements.leave_id
                        WHERE LeaveApplication.user_id = '.$user_id.' 
                        AND LeaveApplication.status = 5
                        AND OptLeave.code_name = "UNPAID"
                        AND (DATE(LeaveApplication.from_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                        AND (DATE(LeaveApplication.to_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                    ) AS leave_unpaid,
                    (
                        SELECT SUM(LeaveApplication.days) AS total_mc FROM LeaveApplication 
                        LEFT JOIN LeaveEntitlements ON LeaveEntitlements.id = LeaveApplication.entitlements_id
                        LEFT JOIN OptLeave ON OptLeave.id = LeaveEntitlements.leave_id
                        WHERE LeaveApplication.user_id = '.$user_id.' 
                        AND LeaveApplication.status = 5
                        AND OptLeave.code_name = "MC"
                        AND (DATE(LeaveApplication.from_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                        AND (DATE(LeaveApplication.to_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                    ) AS leave_mc,
                    (
                        SELECT SUM(LeaveApplication.days) AS total_special FROM LeaveApplication 
                        LEFT JOIN LeaveEntitlements ON LeaveEntitlements.id = LeaveApplication.entitlements_id
                        LEFT JOIN OptLeave ON  OptLeave.id = LeaveEntitlements.leave_id
                        WHERE LeaveApplication.user_id = '.$user_id.' 
                        AND LeaveApplication.status = 5
                        AND OptLeave.code_name = "SPECIAL"
                        AND (DATE(LeaveApplication.from_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                        AND (DATE(LeaveApplication.to_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                    ) AS leave_special';
            return $this->DatabaseModel->readOneQuery($sql);
        }

        private function _get_sunday_ot($range_date, $user_id){
            $totalSundayOT = 0;

            $sql  = 'SELECT
                        Attnd_OT.attnd_otdate_id, 
                        Attnd_OTDate.created_date,
                        COUNT(*) AS totalOT
                    FROM Attnd_OT 
                    LEFT JOIN Attnd_OTDate ON Attnd_OTDate.id = Attnd_OT.attnd_otdate_id 
                    WHERE (
                        DATE(Attnd_OTDate.created_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'"
                    )
                    AND Attnd_OT.user_id = '.$user_id.'
                    GROUP BY Attnd_OT.attnd_otdate_id';
            $otAttndArr = $this->DatabaseModel->readArrayQuery($sql);

            if(!empty($otAttndArr)){
                foreach ($otAttndArr as $k => $val) {
                    if(isWeekend($val['created_date'])){
                        $totalSundayOT = $totalSundayOT + 1;    # OT day on sunday, not working day of attendance
                    }
                }
            }

            return $totalSundayOT;
        }

        private function _filter_ot_hours($range_date, $user_id){
            $sql  = 'SELECT 
                        Attnd_OTDate.id AS attnd_otdate_id, 
                        Attnd_OTDate.created_date, 
                        Attnd_OT.checkin, 
                        Attnd_OT.checkout, 
                        Attnd_OTRequest.duration,
                        TIMESTAMPDIFF(MINUTE, Attnd_OT.checkin, Attnd_OT.checkout) AS duration_taken -- duration is in minutes 
                    FROM Attnd_OT 
                    LEFT JOIN Attnd_OTDate ON Attnd_OTDate.id = Attnd_OT.attnd_otdate_id 
                    LEFT JOIN Attnd_OTRequest ON Attnd_OTRequest.id = Attnd_OT.request_id 
                    WHERE (DATE(Attnd_OTDate.created_date) BETWEEN "'.$range_date['fromDate'].'" AND "'.$range_date['toDate'].'") 
                    AND Attnd_OTDate.user_id = '.$user_id;

            $otArr = $this->DatabaseModel->readArrayQuery($sql);

            // print_array($sql);
            // print_array($otArr); exit();

            $newOT = null;
            if(!empty($otArr)){
                // $minRate = 0;
                // if(isset($user['hourly_rate'])){
                //     # $minRate = is the amount for 1 min
                //     # hourly_rate divide by 60 mins to get 1 min rate
                //     $minRate = $user['hourly_rate'] / 60;
                // }
                foreach ($otArr as $k => $val) {
                    $rqDuration     = explode(':', $val['duration']);
                    $rqDuration_h   = (int)$rqDuration[0];
                    $rqDuration_m   = (int)$rqDuration[1];
                    $rqDuration     = ($rqDuration_h * 60) + $rqDuration_m;     # convert time hours in minutes
                    $completed_dur  = 0;
                    
                    if(!empty($val['duration_taken'])){
                        if($val['duration_taken'] > $rqDuration){
                            # we only take the requested duration
                            $completed_dur = $rqDuration;
                            // $monthlyWorkingHours[$k]['rate_in_min'] = $val['duration'] * $minRate;
                        } else {
                            $completed_dur = $val['duration_taken'];
                            // $monthlyWorkingHours[$k]['rate_in_min'] = $val['duration_taken'] * $minRate;
                        }
                    } else {
                        // $val['duration_taken'] = 0;
                        // $monthlyWorkingHours[$k]['rate_in_min'] = 0;
                    }
                    // $totalMonthlyWorkingHoursInMin = array_sum(array_column($monthlyWorkingHours, 'duration_taken'));
                    // $netBasicSalary = array_sum(array_column($monthlyWorkingHours, 'rate_in_min'));

                    $newOT[$k] = $val;
                    $newOT[$k]['time'] = getTimeData($val['checkin'], $val['checkout']);
                    // $newOT[$k]['completed_dur'] = $approved_duration;    # old code
                    $newOT[$k]['completed_dur'] = $completed_dur;   # in minutes
                }
            }

            // print_array($newOT); exit();

            $ot_duration = $ot_h = $ot_m = $total_ot_duration = 0;
            if(!empty($newOT)){
                # OT duration need to get the sum of the completed duration (in minutes)
                $total_ot_duration = array_sum(array_column($newOT, 'completed_dur'));

                # start :: old code 2020/08/06
                /*foreach ($newOT as $k => $val) {
                    // $ot_duration = plusTimeDuration($ot_duration, $val['completed_dur']);    # old code
                    $ot_h = floor($val['completed_dur'] / 60);
                    $ot_m = fmod($val['completed_dur'], 60);
                    $ot_m = !is_nan($ot_m) ? $ot_m : 0;
                    $ot_duration = $ot_h.':'.$ot_m;
                }*/
                # end :: old code 2020/08/06

                $ot_h = floor($total_ot_duration / 60);
                $ot_m = fmod($total_ot_duration, 60);
                $ot_m = !is_nan($ot_m) ? $ot_m : 0;
                $ot_duration = $ot_h.':'.$ot_m;
            }

            return $ot_duration;
        }

        public function _leave_applied($user_id){
            $leave_ref      = [];
            $entitlements   = $this->LeaveService->_employee_entitlements_listing($user_id);
            $applied        = $this->LeaveService->_leave_applied_listing($user_id);
            if(!empty($applied)){
                foreach($applied as $row){
                    unset($row['approved_by']);
                    unset($row['view_url']);
                    if($row['entitlements']['leave']['is_payslip_ref']){
                        $leave_ref[] = $row;
                    }
                }
            }
            return $leave_ref;
        }

        # $month in single digit
        public function _holiday_by_payslip($month, $year, $staff_id){
            $allDays   = 0;
            $holsArr   = [];
            $hols      = [];
            $fromYear  = $month == 1 ? $year-1 : $year;
            $fromMonth = $month == 1 ? 12 : $month-1;
            $fromDate  = $fromYear.'-'.$fromMonth.'-26';
            $toDate    = $year.'-'.$month.'-25';
            $addr      = $this->UserService->_addr_detail($staff_id);

            $sql = 'SELECT * FROM '.$this->TableService->CalendarHols.' WHERE (start BETWEEN "'.$fromDate.'" AND "'.$toDate.'") AND status = "confirmed"';
            $ph  = $this->DatabaseModel->readArrayQuery($sql);

            if(!empty($ph)){
                # get number of PH
                foreach ($ph as $k => $val) {
                    $holsArr[$k] = $val;
                    $holsArr[$k]['region_listing'] = $this->CalendarService->_explode_region($val['region']);
                    $holsArr[$k]['days']           = getDays($val['start'], $val['end']);
                }
            }

            if(!empty($holsArr)){
                foreach ($holsArr as $k => $val) {
                    if(!empty($val['region_listing'])){
                        # if included in regional holiday, add this PH
                        if(in_array($addr['state'], $val['region_listing'])){
                            $hols[] = $val;
                        }
                    } else {
                        # all PH without regional restriction
                        $hols[] = $val;
                    }
                }
            }

            if(!empty($hols)){
                foreach ($hols as $val) {
                    $allDays = getDays($val['start'], $val['end']) + $allDays;
                }
            }

            return $allDays;
        }

        public function _leave_by_payslip($month, $year, $user_id){
            $MC = $AL = $UNPAID = [];

            $entitle        = [];
            $fromYear       = $month == 1 ? $year-1 : $year;
            $fromMonth      = $month == 1 ? 12 : $month-1;
            $fromDate       = $fromYear.'-'.$fromMonth.'-26';
            $toDate         = $year.'-'.$month.'-25';

            /*$sql = 'SELECT * FROM '.$this->TableService->LeaveApp.' WHERE (from_date BETWEEN "'.$fromDate.'" AND "'.$toDate.'") AND status = '.LeaveService::_LEAVE_HR_APPROVED.' AND user_id = '.$user_id;
            $leaveApplied = $this->DatabaseModel->readArrayQuery($sql);

            if(!empty($leaveApplied)){
                foreach ($leaveApplied as $k => $val) {
                    $leaveApp[$k] = $val;
                    $leaveApp[$k]['entitlements'] = $this->LeaveService->_employee_entitlements($val['entitlements_id']);
                }
            }*/

            $entitlements = $this->LeaveService->_employee_entitlements_listing($user_id);
            if(!empty($entitlements)){
                foreach ($entitlements as $k => $val) {
                    if($val['leave']['is_payslip_ref']){
                        $sql = 'SELECT SUM(days) AS total FROM '.$this->TableService->LeaveApp.' WHERE (from_date BETWEEN "'.$fromDate.'" AND "'.$toDate.'") AND status = '.LeaveService::_LEAVE_HR_APPROVED.' AND entitlements_id = '.$val['id'];
                        $total_days = $this->DatabaseModel->readOneQuery($sql);

                        $entitle[$k] = $val;
                        $entitle[$k]['total_days'] = !empty($total_days['total']) ? $total_days['total'] : 0;
                    }
                }
            }

            usort($entitle, function($a, $b){ return $a['leave']['sequence'] < $b['leave']['sequence']; });
            if(!empty($entitle)){
                foreach ($entitle as $k => $val) {
                    if(in_array($val['leave_id'], HrConfigService::_ALL_AL)){
                        $AL = $val;
                    }
                    if($val['leave_id'] == HrConfigService::_LEAVE_UNPAID){
                        $UNPAID = $val;
                    }
                    if($val['leave_id'] == HrConfigService::_LEAVE_MEDICAL){
                        $MC = $val;
                    }
                }
            }

            return [
                'MC'     => $MC,
                'AL'     => $AL,
                'UNPAID' => $UNPAID
            ];
        }

    /* START :: SALARY CALCULATION */
        private function _calculate_fix_pay($pay){
            $non_fix = $staff_fund = 0 - $pay['emp']['staff_fund'];
            $fix     = $net_salary = $pay['basic_salary'];

            if(!empty($pay)){
                # added new logic : 22/05/2021
                if(!empty($pay['additional'])){
                    foreach ($pay['additional'] as $k => $val) {
                        # item_type = deduct / earn
                        if($val['item_type'] === 'earn'){
                            if($val['amount_type'] === 'fix'){
                                $fix = $fix + $val['amount'];
                            } else {
                                # $val['amount_type'] === 'nonfix'
                                $non_fix = $non_fix + $val['amount'];
                            }
                            $net_salary = $net_salary + $val['amount'];
                            continue;
                        } else {
                            if($val['amount_type'] === 'fix'){
                                $fix = $fix - $val['amount'];
                            } else {
                                # $val['amount_type'] === 'nonfix'
                                $non_fix = $non_fix - $val['amount'];
                            }
                            $net_salary = $net_salary - $val['amount'];
                            continue;
                        }
                    }
                }

                $non_fix = $non_fix + $pay['ot_pay'];

                if(!empty($pay['earn'])){
                    $earn = $pay['earn'];

                    # the earning payment amount is following the amount that is already get calculated based on the attendance that get saved in payslip table

                    if($earn['travel_p3_check']){
                        $non_fix = $non_fix + $pay['travel_p3'];
                    }
                    if($earn['travel_c_check']){
                        $non_fix = $non_fix + $pay['travel_c'];
                    }
                    if($earn['shift_rotation_check']){
                        $non_fix = $non_fix + $pay['shift_rotation'];
                    }
                    if($earn['attnd_check']){
                        $non_fix = $non_fix + $pay['attnd'];
                    }
                    if($earn['special_check']){
                        $non_fix = $non_fix + $pay['special'];
                    }
                }

                if(!empty($pay['deduct'])){
                    $deduct         = $pay['deduct'];   // containing all item for deduction
                    $fix_deduction  = $deduct['epf'] + $deduct['socso'] + $deduct['sip'] + $deduct['pcb'] + $deduct['incomplete_attnd'] + $deduct['incomplete_working_hours'] + $deduct['unpaid_leave_charges'];
                    $fix            = $fix - $fix_deduction;
                }
            }

            $net_salary     = $fix + $non_fix;

            return [
                'fix'     => only_decimal($fix, 2),
                'non_fix' => only_decimal($non_fix, 2),
                'net'     => only_decimal($net_salary, 2)
            ];
        }

        public function _update_salary_calculation($payslip_id){
            $pay           = $this->_payslip_detail($payslip_id);
            $calculate_fix = $this->_calculate_fix_pay($pay);
            // print_array($calculate_fix); exit();
            $this->DatabaseModel->updateData(['id' => $payslip_id], [
                'fix'           => $calculate_fix['fix'],
                'non_fix'       => $calculate_fix['non_fix'],
                'net_salary'    => $calculate_fix['net']
            ], $this->TableService->Payslip);
        }

        public function _calculate_ot_pay($basic_salary, $ot_hours, $hourly_rate){
            # convert all to minutes first
            $parts   = explode(':',$ot_hours);
            $ot_mins = ((int)$parts[0])*60+(int)$parts[1];

            if($basic_salary >= 3000){
                $hourly_rate = (3000/self::_FULL_WORKING_DAYS)/self::_FULL_WORKING_HOURS;
            }

            $min_rate = $hourly_rate/60;
            
            // print_array('OT hours: '.$ot_hours);
            // print_array('Hourly Rate: '.$hourly_rate);
            // print_array($ot_mins);
            // print_array($min_rate); exit();
            return $ot_mins * $min_rate;
        }

}