<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class HrConfigService extends MY_Service {

	function __construct(){
        parent::__construct();
    }

    const _ALL_AL = [1, 2, 3];      // Use for payslip only!

    # CHECK DATABASE TABLE OptLeave
    const _LEAVE_TYPE = [
    	1 => 'Annual Leave',		// Less than two years
    	2 => 'Annual Leave', 		// Two years to less than five years
    	3 => 'Annual Leave',		// Five years and above
    	4 => 'Unpaid Leave',
    	5 => 'Medical Leave',
    	6 => 'Hospitalization',
    	7 => 'Compassionate Leave',
        8 => 'Special Leave',
        9 => 'Advance Leave'
    ];

    const _LEAVE_ANNUAL_CAT_1 	 = 1;
    const _LEAVE_ANNUAL_CAT_2 	 = 2;
    const _LEAVE_ANNUAL_CAT_3 	 = 3;
    const _LEAVE_UNPAID 		 = 4;
    const _LEAVE_MEDICAL 		 = 5;
    const _LEAVE_HOSPITALIZATION = 6;
    const _LEAVE_COMPASSIONATE 	 = 7;
    const _LEAVE_SPECIAL         = 8;
    const _LEAVE_ADVANCE         = 9;

    /* START :: LEAVE */
    	public function _leave_listing(){
    		return $this->DatabaseModel->readArray($this->TableFieldService->Leave, $this->TableService->Leave);
    	}

    	public function _leave_detail($leave_id){
    		$leave = $this->DatabaseModel->readOneWithOptions(['id' => $leave_id], $this->TableFieldService->Leave, $this->TableService->Leave);
            if(!empty($leave)){
                $leave['full_title'] = !empty($leave['category']) ? $leave['title'].' ('.$leave['category'].')' : $leave['title'];
            }
            return $leave;
    	}

    /* START :: ALLOWANCE */
        public function _allowance_setting_detail($user_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], $this->TableFieldService->PayslipConfig_allowance, $this->TableService->PayslipConfig_allowance);
        }

}