<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class CustomerSupplierService extends MY_Service {

	function __construct(){
        parent::__construct();
    }

    public function _get_all_customer_and_supplier_with_page($doExport){
        $next           = $this->input->get('next') ? $this->input->get('next') : 50;
        $date_from      = $this->input->get('from');
        $date_to        = $this->input->get('to');
        $start          = $next - 50;
        $limit          = $next;
        $task           = [];
        
        $listedWhereClause = $unlistedWhereClause = '';

        // if(isset($_GET['type'])){
        //     if($_GET['type'] === 'verified'){
        //         $unlistedWhereClause = ' AND Jobsheet.is_verified = 1';
        //         $listedWhereClause = ' WHERE Jobsheet.is_verified = 1';
        //     } else {
        //         $unlistedWhereClause = ' AND Jobsheet.is_verified = 0';
        //         $listedWhereClause = ' WHERE Jobsheet.is_verified = 0';
        //     }
        // } else {
        //     $unlistedWhereClause = ' AND Jobsheet.is_verified = 1';
        //     $listedWhereClause = ' WHERE Jobsheet.is_verified = 1';
        // }

        $limitQuery = !$doExport ? ' LIMIT '.$start.', 50' : '';
        $customerAndSupplier = $this->UserService->_get_customer_suppliers($limitQuery);
        if(!empty($customerAndSupplier)){
            foreach ($customerAndSupplier as $k => $val) {
                if($k === 'branch_name'){
                    # change the branch name to company name so that it's easy to display without specifying the company or branch
                    $customerAndSupplier[$k]['company_name'] = $val['branch_name'];
                }
                $customerAndSupplier[$k]['control_acc'] = '3000/000';
                $customerAndSupplier[$k]['currency_code'] = '--';
            }
        }

        $userType    = $this->config->item('user_type');
        $where       = 'WHERE Company.usertype_id IN('.$userType['CUSTOMER'].', '.$userType['SUPPLIER'].')';
        $sql         = $this->UserService->_get_customer_suppliers_query($where);
        $derivedName = 'NonAndLocatedItem';
        $pages = $this->PaginationService->_get_special_pagination($start, $limit, $sql, $derivedName);

        return [
            'customerAndSupplier' => $customerAndSupplier,
            'pages' => $pages
        ];
    }

    public function generate_excel($userTypeLabel=null, $customerAndSupplier=null){
        $userType   = $this->config->item('user_type');
        $userTypeId = $userType[$userTypeLabel];

        $excelArr    = [];
        $excelHeader = [
            'Code(10)',
            'CONTROLACCOUNT(10)',
            'CompanyName(100)',
            'CURRENCYCODE(6)'
        ];

        if(!empty($customerAndSupplier)){
            $val = array_filter($customerAndSupplier, function($row) use ($userTypeId){
                return $row['usertype_id'] == $userTypeId;
            });

            $excelRow = [];
            $count = 0;
            $preExportedItemID = [];
            if(!empty($val)){
            foreach ($val as $key => $row) {
                array_push($preExportedItemID, $row['id']);
                $count++;
                $excelRow = array_merge($excelRow, [[
                    $row['acc_code'], // Code(10)
                    $row['control_acc'], // CONTROLACCOUNT(10)
                    $row['company_name'], // CompanyName(100)
                    $row['currency_code'], // CURRENCYCODE(6)
                ]]);
            }}
            $excelArr = array_merge([$excelHeader], $excelRow);
        }

        $xlsx = $this->simplexlsxgen->fromArray($excelArr);
        $fileName = $userTypeLabel === 'CUSTOMER' ? 'AR_CUSTOMER.xlsx' : 'AP_SUPPLIER.xlsx';
        return $xlsx->downloadAs($fileName);
        // if($xlsx->downloadAs($fileName)){
        //     # create batch no
        //     if(!empty($preExportedItemID)){
        //         $batchSql = 'SELECT batch_no FROM Item GROUP BY batch_no ORDER BY batch_no DESC LIMIT 1';
        //         $lastBatchNo = $this->DatabaseModel->readOneQuery($batchSql);
        //         $batchNo = batchNoGenerator(!empty($lastBatchNo) ? $lastBatchNo['batch_no'] : 0);
        //         foreach ($preExportedItemID as $itemID) {
        //             $this->DatabaseModel->updateData(['id' => $itemID], [
        //                 'batch_no' => $batchNo
        //             ], 'Item');
        //         }
        //     }
        // }
    }

}