<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class NotificationsService extends MY_Service {

	function __construct(){
        parent::__construct();
    }

    /**
     * $ref_code please refer to $config['notifications'] under application\config\custom.php
     */

    public function _notify_task_created($task_id=null, $ticketID=null, $createdByID=null, $company_codename_id=null){
        $createdBy  = $this->DatabaseModel->readOneWithOptions(['user_id' => $createdByID], 'code_name', 'Employee');
        $content    = notify_taskCreated($ticketID, $createdBy['code_name']);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'TASK_CREATED';
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        $accessCode = "NTF-TSK001";

        $toNotify = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _notify_task_assign($task_id=null, $ticketID=null){
        $content    = notify_taskAssigned($ticketID);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'TASK_CREATED';
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);

        return $notifyID;
    }

    # $userAssignedCodeNames must be a single array which contains only the user codenames
    public function _notify_user_assigned($task_id=null, $ticketID=null, $userAssignedCodeNames=[], $company_codename_id=null){
        $accessCode = "NTF-TSK003";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);

        if(!empty($userAssignedCodeNames)){
            $content    = join(", ",$userAssignedCodeNames).notify_taskHasAssigned($ticketID);
            $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
            $ref_code   = 'TASK_ASSIGNED';
            $accessCode = "NTF-TSK003";
            $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);

            $this->_notify_other_users($notifyID, $uri, $toNotify);
        }
    }

    public function _notify_js_start_attendance($task_id=null, $ticketID=null, $userCodeName=null, $company_codename_id=null){
        $content    = notify_jsStarted($ticketID, $userCodeName);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'JS_STARTED';
        $accessCode = "NTF-JS001";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _notify_js_ended($task_id=null, $ticketID=null, $userCodeName=null, $company_codename_id=null){
        $content    = notify_jsEnded($ticketID, $userCodeName);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'JS_ENDED';
        $accessCode = "NTF-JS002";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _notify_js_created($task_id=null, $ticketID=null, $userCodeName=null, $company_codename_id=null){
        $content    = notify_jsCreated($ticketID, $userCodeName);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'JS_UPDATED';
        $accessCode = "NTF-JS003";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _notify_js_updated($task_id=null, $ticketID=null, $userCodeName=null, $company_codename_id=null){
        $content    = notify_jsUpdated($ticketID, $userCodeName);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'JS_CREATED';
        $accessCode = "NTF-JS004";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _notify_task_status_updated(
        $task_id=null, 
        $ticketID=null, 
        $userCodeName=null, 
        $company_codename_id=null, 
        $status=null
    ){
        $content    = notify_taskStatusUpdate($ticketID, $status);
        $uri        = 'task/view/'.$task_id.'?tab=jobsheet';
        $ref_code   = 'TASK_UPDATE';
        $accessCode = "NTF-TSK002";
        $toNotify   = $this->_get_user_to_notify($company_codename_id, $accessCode);
        $notifyID   = $this->_create_notifications($content, $uri, $ref_code, $task_id);
        
        $this->_notify_other_users($notifyID, $uri, $toNotify);
    }

    public function _get_user_to_notify($company_codename_id=null, $accessCode=null){
        $toNotify = [];

        # notify all user registered under this customer company
        # -- CompanyBranch.branch_name, 
        # -- LEFT JOIN CompanyBranch ON CompanyBranch.company_id = Company.id
        $sql = 'SELECT 
                    User.username,
                    User.id as user_id, 
                    AccessGroup.name AS access_name, 
                    Company.company_name, 
                    CompanyCodeName.code_name,
                    CompanyCodeName.ref_id
                FROM User 
                LEFT JOIN AccessGroup ON AccessGroup.id = User.group_id
                LEFT JOIN Company ON Company.id = User.company_id
                LEFT JOIN CompanyCodeName ON CompanyCodeName.ref_id = Company.id
                WHERE CompanyCodeName.id = '.$company_codename_id.'
                -- GROUP BY Company.id';
        $usersUnderSameCompany = $this->DatabaseModel->readArrayQuery($sql);
        
        # get all user who can receive this notifications
        $sql = 'SELECT 
                    Access.id, 
                    Access.group_id, 
                    Access.access_code, 
                    AccessGroup.name AS group_name, 
                    Employee.user_id, 
                    Employee.code_name 
                FROM Access
                LEFT JOIN AccessGroup ON AccessGroup.id = Access.group_id
                LEFT JOIN User ON User.group_id = Access.group_id
                LEFT JOIN Employee ON Employee.user_id = User.id
                WHERE Access.access_code = "'.$accessCode.'"';
        $usersCanReceiveNotifications = $this->DatabaseModel->readArrayQuery($sql);

        if(!empty($usersUnderSameCompany)){
            $toNotify = array_merge($toNotify, array_column($usersUnderSameCompany, 'user_id'));
        }
        if(!empty($usersCanReceiveNotifications)){
            $toNotify = array_merge($toNotify, array_column($usersCanReceiveNotifications, 'user_id'));
        }

        # always notify ADMIN user (super admin)
        $toNotify = array_merge($toNotify, ["1"]);
        return $toNotify;
    }

    # START :: NOTIFY USERS
        # $toNotify should be a single array containing user_id value only
        public function _notify_other_users($notifyID=null, $uri=null, $toNotify=null){
            if(!empty($notifyID) && !empty($toNotify)){
                foreach ($toNotify as $k => $user_id) {
                    $this->_create_receiver_notifications($notifyID, $user_id, $uri);
                }
            }
        }

    # START:: CREATE NOTIFICATIONS
        public function _create_notifications($content=null, $uri=null, $ref_code=null, $ref_id=null){
            $notificationsData = [
                'ref_id'        => $ref_id,
                'ref_code'      => $ref_code,
                'content'       => $content,
                'created_date'  => currentTimeStamp(),
                'uri'           => $uri,
            ];
            return $this->DatabaseModel->createData($notificationsData, 'Notifications');
        }

        public function _create_receiver_notifications($notifyID=null, $user_id=null, $uri=null){
            $notificationsReceiverData = [
                'notify_id'     => $notifyID,
                'receiver_type' => 'user',
                'is_sent'       => 1,
                'created_date'  => currentTimeStamp(),
                'uri'           => $uri,
                'receiver_id'   => !empty($user_id) ? $user_id : 0
            ];
            $this->DatabaseModel->createData($notificationsReceiverData, 'NotificationsReceiver');
        }
}