<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class LeaveService extends MY_Service {

    const _LEAVE_APPROVAL = ['Pending', 'Awaiting cancellation approval', 'Cancelled', 'Declined', 'Department approved, Pending HR', 'HR approved'];

    const _LEAVE_PENDING        = 0;
    const _LEAVE_CANCEL_PENDING = 1;
    const _LEAVE_CANCELLED      = 2;
    const _LEAVE_DECLINED       = 3;
    const _LEAVE_HOD_APPROVED   = 4;
    const _LEAVE_HR_APPROVED    = 5;
    const _LEAVE_SESSION = [
        ['type' => 'morning', 'time' => '8.30 AM - 12.30 PM'],
        ['type' => 'after', 'time' => '1.30 PM - 5.30 PM']
    ];

	private $Services = [
        'hr/HrConfigService' 	=> 'HrConfigService',
        'UserService'           => 'UserService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: OPTIONS */
    	public function _employee_entitlements_listing($user_id){
    		$entitlements =  $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], $this->TableFieldService->Entitlements, 'year DESC', $this->TableService->Entitlements);
    		if(!empty($entitlements)){
    			foreach ($entitlements as $k => $val) {
    				$entitle[$k] = $val;
    				$entitle[$k]['leave'] = $this->HrConfigService->_leave_detail($val['leave_id']);
    			}
    		}
    		return isset($entitle) ? $entitle : [];
    	}

    	public function _employee_entitlements($entitlements_id){
    		$entitlements = $this->DatabaseModel->readOneWithOptions(['id' => $entitlements_id], $this->TableFieldService->Entitlements, $this->TableService->Entitlements);
            if(!empty($entitlements)){
                $entitlements['leave'] = $this->HrConfigService->_leave_detail($entitlements['leave_id']);
            }
            return $entitlements;
    	}

    /* START :: SHARED FUNCTIONS */
        public function _leave_applied_listing($user_id){
            $leaveApplied = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], $this->TableFieldService->LeaveApp, 'created_date DESC, id DESC', $this->TableService->LeaveApp);
            if(!empty($leaveApplied)){
                foreach ($leaveApplied as $k => $val) {
                    $leaveApply[$k] = $val;
                    $leaveApply[$k]['entitlements'] = $this->_employee_entitlements($val['entitlements_id']);
                    $leaveApply[$k]['approved_by']  = $this->UserService->_employee_detail($val['approvedby_id']);
                    $leaveApply[$k]['view_url']     = current_url().'/details/'.$val['id'];
                }
            }
            return isset($leaveApply) ? $leaveApply : [];
        }

        public function _request_history($user_id){
            $sql = 'SELECT '.$this->TableFieldService->LeaveApp.' FROM '.$this->TableService->LeaveApp.' WHERE from_date < CURDATE() ORDER BY from_date DESC';
            $histories = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($histories)){
                foreach ($histories as $k => $val) {
                    $history[$k] = $val;
                    $history[$k]['entitle'] = $this->_employee_entitlements($val['entitlements_id']);
                }
            }
            return isset($history) ? $history : [];
        }

        public function create_entitlements($user_id, $leave_id, $days, $date_joined){
            $current_year       = date('Y');
            $current_month      = date('n');
            $month_joined       = date('n', strtotime($date_joined));
            $year_joined        = date('Y', strtotime($date_joined));
            $annual_leave_cat1  = $this->HrConfigService->_leave_detail(HrConfigService::_LEAVE_ANNUAL_CAT_1);
            $annual_leave_days  = ($month_joined / 12) * $annual_leave_cat1['days'];
            $pre_days_given     = $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_1 || $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_2 || $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_3 ? round($annual_leave_days) : $days;

            $month_up_to_today = getEntitlementMonth($date_joined);
            $month_up_to_today = $month_up_to_today > 12 ? $month_up_to_today + 1 : $month_up_to_today;
            $daysEntitle = $days;

            if( $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_1 || 
                $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_2 || 
                $leave_id == HrConfigService::_LEAVE_ANNUAL_CAT_3)
            {
                $days_given = ($month_up_to_today / 12) * $daysEntitle;
            } else {
                $days_given = $days;
            }

            $entitlementsData = [
                'user_id'  => $user_id,
                'leave_id' => $leave_id,
                'days'     => floor($days_given),
                'balance'  => floor($days_given),
                'year'     => date('Y'),
                'current_month' => date('n'),
                'created_date' => currentTimeStamp()
            ];

            $this->DatabaseModel->createData($entitlementsData, $this->TableService->Entitlements);
        }

        public function _leave_applied_detail($user_id, $date){
            $leaveApplied = null;
            $leaveApp     = $this->_leave_applied_listing($user_id);

            if(!empty($leaveApp)){
                foreach ($leaveApp as $k => $val) {
                    if($val['from_date'] === $date){
                        $leaveApplied = $val['entitlements']['leave'];
                    }
                }
            }
            
            return $leaveApplied;
        }

    /* START :: REQUEST - SHARED FUNCTIONS */
        public function _request_component(){
            $department_id   = isset($this->profile['user']['department']['id']) ? $this->profile['user']['department']['id'] : null;
            // $role_id         = $this->session->userLogged['role_id'];
            $approval_status = null;

            if($this->uri->segment(1) === 'hr-system'){
                if($this->user_access['HR-LVE004'] || $this->user_access['HR-LVE005']){
                    # HR/admin/director permission : can see all request
                    $sql = 'SELECT LeaveApplication.*, AccessGroup.department_id, OptDepartment.title AS department_name 
                            FROM LeaveApplication
                            LEFT JOIN User ON User.id = LeaveApplication.user_id
                            LEFT JOIN AccessGroup ON AccessGroup.id = User.group_id
                            LEFT JOIN OptDepartment ON OptDepartment.id = AccessGroup.department_id
                            ORDER BY LeaveApplication.created_date DESC, LeaveApplication.id DESC';
                    $requests = $this->DatabaseModel->readArrayQuery($sql);
                } else {
                    # hod/manager permission : can see own department [HR-LVE003]
                    $sql = 'SELECT LeaveApplication.*, AccessGroup.department_id, OptDepartment.title AS department_name 
                            FROM LeaveApplication
                            LEFT JOIN User ON User.id = LeaveApplication.user_id
                            LEFT JOIN AccessGroup ON AccessGroup.id = User.group_id
                            LEFT JOIN OptDepartment ON OptDepartment.id = AccessGroup.department_id
                            WHERE AccessGroup.department_id = '.$department_id.'
                            ORDER BY LeaveApplication.created_date DESC, LeaveApplication.id DESC';
                    $requests = $this->DatabaseModel->readArrayQuery($sql);
                }

                # $approval_status is to determine what is the approval type. it decides if approved by admin/manager/director
                if($this->user_access['HR-LVE003']){
                    $approval_status = self::_LEAVE_HOD_APPROVED;
                }
                if($this->user_access['HR-LVE004'] || $this->user_access['HR-LVE005']){
                    $approval_status = self::_LEAVE_HR_APPROVED;
                }
            } else {
                $sql = 'SELECT LeaveApplication.*, AccessGroup.department_id, OptDepartment.title AS department_name 
                        FROM LeaveApplication
                        LEFT JOIN User ON User.id = LeaveApplication.user_id
                        LEFT JOIN AccessGroup ON AccessGroup.id = User.group_id
                        LEFT JOIN OptDepartment ON OptDepartment.id = AccessGroup.department_id
                        WHERE LeaveApplication.user_id = '.$this->profile['user_id'].'
                        ORDER BY LeaveApplication.created_date DESC, LeaveApplication.id DESC';
                $requests = $this->DatabaseModel->readArrayQuery($sql);
            }

            if(!empty($requests)){
                foreach ($requests as $k => $val) {
                    $rq[$k] = $val;
                    $rq[$k]['emp']          = $this->UserService->_employee_detail($val['user_id']);
                    $rq[$k]['entitlements'] = $this->_employee_entitlements($val['entitlements_id']);
                    $rq[$k]['approved_by']  = $this->UserService->_employee_detail($val['approvedby_id']);
                    $rq[$k]['view_url']     = current_url().'/details/'.$val['id'];
                    # array_search holds the key of the array
                    $leaveSession = array_search($val['session'], array_column(self::_LEAVE_SESSION, 'type'));
                    $rq[$k]['session_time'] = self::_LEAVE_SESSION[$leaveSession];
                }
            }

            return [
                'approval_status' => $approval_status,
                'rq'              => isset($rq) ? $rq : []
            ];
        }

        public function _update_status($rq_id, $management_remark, $comment, $director_remark, $director_comment){
            $status    = $this->input->post('update_approval') ? $this->input->post('update_approval') : '';
            $applyData = [
                'status'            => $status,
                'modified_date'     => getCurrentTimeStamp(),
                'approvedby_id'     => $this->session->userLogged['id']
            ];

            $applyData['management_remark'] = $management_remark;
            $applyData['comment'] = $comment;
            $applyData['director_remark'] = $director_remark;
            $applyData['director_comment'] = $director_comment;

            $this->DatabaseModel->updateData(['id' => $rq_id], $applyData, $this->TableService->LeaveApp);

            if($status == self::_LEAVE_DECLINED){
                $applicationData  = $this->DatabaseModel->readOneWithOptions(['id' => $rq_id], $this->TableFieldService->LeaveApp, $this->TableService->LeaveApp);
                $entitlement      = $this->_employee_entitlements($applicationData['entitlements_id']);
                $entitlementsData = [
                    'used'      => $entitlement['used'] - $applicationData['days'],
                    'balance'   => $entitlement['balance'] + $applicationData['days'],
                ];

                $this->DatabaseModel->updateData(['id' => $applicationData['entitlements_id']], $entitlementsData, $this->TableService->Entitlements);
            }
        }

        public function _cancel_leave($rq_id){
            $applyData = [
                'status'         => self::_LEAVE_CANCELLED,
                'modified_date'  => getCurrentTimeStamp(),
                'approvedby_id'  => $this->session->userLogged['id']
            ];

            $applicationData  = $this->DatabaseModel->readOneWithOptions(['id' => $rq_id], $this->TableFieldService->LeaveApp, $this->TableService->LeaveApp);
            $entitlement      = $this->_employee_entitlements($applicationData['entitlements_id']);

            $entitlementsData = [
                'used'      => $entitlement['used'] - $applicationData['days'],
                'balance'   => $entitlement['balance'] + $applicationData['days'],
            ];

            $this->DatabaseModel->updateData(['id' => $rq_id], $applyData, $this->TableService->LeaveApp);
            $this->DatabaseModel->updateData(['id' => $applicationData['entitlements_id']], $entitlementsData, $this->TableService->Entitlements);
        }

}