<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class ChargesService extends MY_Service {
    public $data = [];

    private $Services = [
        'task/ALT_Service'                      => 'ALT_Service',
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    public function _verify_charges($js_id=null, $status=null){
        $verifyData = [];
        switch ($status) {
            case ($status === 'draft' || $status === 'returned'):
                $verifyData = ['verification_status' => 'submitted'];
                break;
            case 'submitted':
                $verifyData = [
                    'verification_status'    => 'managerverify',
                    'last_verified_by'       => $this->profile['user_id'],
                    'last_verification_date' => currentTimeStamp()
                ];
                $verifyMsg = 'Charges has been submitted for manager verification.';
                break;
            case 'managerverify':
                $verifyData = [
                    'verification_status'    => 'adminverify',
                    'last_verified_by'       => $this->profile['user_id'],
                    'last_verification_date' => currentTimeStamp()
                ];
                $verifyMsg = 'Charges has been submitted for admin verification.';
                break;
            case 'adminverify':
                $verifyData = [
                    'verification_status'    => 'accverify',
                    'last_verified_by'       => $this->profile['user_id'],
                    'last_verification_date' => currentTimeStamp()
                ];
                $verifyMsg = 'This charges verification is completed and cannot be returned.';
                $this->_generate_charges_pdf($js_id);
                break;
            // case 'accverify':
            //     $verifyData = [
            //         'verification_status'    => 'done',
            //         'last_verified_by'       => $this->profile['user_id'],
            //         'last_verification_date' => currentTimeStamp()
            //     ];
            //     $verifyMsg = 'This charges verification is completed and cannot be returned.';
            //     $this->_generate_charges_pdf($js_id);
            //     break;
            default:
                $verifyData = ['verification_status' => 'draft'];
                break;
        }
        $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, 'Invoice_Charges');
        return $verifyMsg;
    }

    public function _show_submit_verify_btn($status=null){
        $validStatus = ['draft', 'submitted', 'returned', 'managerverify', 'adminverify'];
        $showSubmitVerifyBtn = false;
        if(in_array($status, $validStatus)){
            if ($this->user_access['CHRG-VRFY001'] || 
                $this->user_access['CHRG-VRFY002'] || 
                $this->user_access['CHRG-VRFY003']){
                # show button for higher level do the verification submission
                if($status === 'submitted'){
                    # submitted and is awaiting manager verification.
                    # at this stage, only user with manager, admin or account access can do the verification
                    $showSubmitVerifyBtn = 
                        $this->user_access['CHRG-VRFY001'] || 
                        $this->user_access['CHRG-VRFY002'] || 
                        $this->user_access['CHRG-VRFY003'] ? true : false;
                } else if($status === 'managerverify'){
                    # manager has verified and awaiting admin verification.
                    # at this stage, only user with admin or account access can do the verification
                    $showSubmitVerifyBtn = $this->user_access['CHRG-VRFY002'] || $this->user_access['CHRG-VRFY003'] ? true : false;
                } else if ($status === 'adminverify'){
                    # admin has verified and awaiting account verification.
                    # at this stage, only user with account access can do the verification
                    $showSubmitVerifyBtn = $this->user_access['CHRG-VRFY003'] ? true : false;
                } else {
                    $showSubmitVerifyBtn = in_array($status, ['draft', 'returned']) ? true : false;
                }
            } else {
                if(in_array($status, ['draft', 'returned'])){
                    # show button for tech to submit their charges
                    $showSubmitVerifyBtn = true;
                }
            }
        }
        return $showSubmitVerifyBtn;
    }

    public function _is_disable_form($status=null){
        $validStatus = ['draft', 'submitted', 'returned', 'managerverify', 'adminverify'];
        $isDisableForm = true;
        if(in_array($status, $validStatus)){
            if ($this->user_access['CHRG-VRFY001'] || 
                $this->user_access['CHRG-VRFY002'] || 
                $this->user_access['CHRG-VRFY003']){
                if($status === 'submitted'){
                    # submitted and is awaiting manager verification.
                    # at this stage, only user with manager, admin or account access can do the verification
                    $isDisableForm = 
                        $this->user_access['CHRG-VRFY001'] || 
                        $this->user_access['CHRG-VRFY002'] || 
                        $this->user_access['CHRG-VRFY003'] ? false : true;
                } else if($status === 'managerverify'){
                    # manager has verified and awaiting admin verification.
                    # at this stage, only user with admin or account access can do the verification
                    $isDisableForm = $this->user_access['CHRG-VRFY002'] || $this->user_access['CHRG-VRFY003'] ? false : true;
                } else if ($status === 'adminverify'){
                    # admin has verified and awaiting account verification.
                    # at this stage, only user with account access can do the verification
                    $isDisableForm = $this->user_access['CHRG-VRFY003'] ? false : true;
                } else {
                    $isDisableForm = in_array($status, ['draft', 'returned']) ? false : true;
                }
            } else {
                if(in_array($status, ['draft', 'returned'])){
                    $isDisableForm = false;
                }
            }
        }
        return $isDisableForm;
    }

    public function _is_verify_needed($status=null){
        $validStatus = ['submitted', 'managerverify', 'adminverify'];
        return in_array($status, $validStatus) ? true : false;
    }

    public function _get_charges_status($status=null){
        switch ($status) {
            case 'submitted':
                $statusText = $this->user_access['CHRG-VRFY'] ? 'PENDING MANAGER VERIFICATION' : 'SUBMITTED FOR VERIFICATION';
                break;
            case 'managerverify':
                # verified by manager and awaiting admin to continue the verification
                $statusText = $this->user_access['CHRG-VRFY'] ? 'MANAGER VERIFIED, PENDING ADMIN VERIFICATION' : 'VERIFICATION IN PROGRESS';
                break;
            case 'adminverify':
                # verified by admin and awaiting account to continue the verification
                $statusText = $this->user_access['CHRG-VRFY'] ? 'ADMIN VERIFIED, PENDING ACCOUNT VERIFICATION' : 'VERIFICATION IN PROGRESS';
                break;
            case 'accverify':
                # verified by account so the status should be done
                $statusText = 'DONE';
                break;
            case 'done':
                $statusText = 'DONE';
                break;
            case 'returned':
                $statusText = 'RETURNED';
                break;
            default:
                $statusText = 'DRAFT';
                break;
        }

        return $statusText;
    }

    # js_id is not required because this is for item stock creation only
    # only sales will need to be tied with js
    public function _get_invoice($js_id=null){
        $invoice = $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], '*', 'Invoice_Charges');
        if(!empty($invoice)){
            $invoice['supplier'] = $this->UserService->_supplier_details($invoice['supplier_codename_id']);
            $invoice['supplier']['addr'] = !empty($invoice['supplier']) ? $this->UserService->_full_addr(
                $invoice['supplier']['ref_id'],
                $invoice['supplier']['ref']
            ) : '';
            $invoice['location'] = $this->DatabaseModel->readOneWithOptions(['id' => $invoice['location_id']], 'location AS name', $this->TableService->ItemLocation);
            $invoice['tech'] = $this->DatabaseModel->readOneWithOptions(['user_id' => $invoice['created_by_id']], 'code_name', 'Employee');
            $invoice['agent'] = $this->DatabaseModel->readOneWithOptions(['user_id' => $invoice['agent_id']], 'code_name', 'Employee');
            $invoice['terms'] = $this->DatabaseModel->readOneWithOptions(['id' => $invoice['credit_terms_id']], 'description', 'CompanySetting_CreditTerms');
            $invoice['items'] = $this->DatabaseModel->readArrayQuery(
                'SELECT Item.*, 
                    ItemGroup.name AS group_name, 
                    ItemGroup.type AS group_type,
                    ItemSales.discount 
                FROM ItemSales 
                LEFT JOIN Item ON Item.id = ItemSales.item_id
                LEFT JOIN ItemGroup ON ItemGroup.id = Item.item_group_id
                WHERE ItemSales.invoice_charges_id = '.$invoice['id'].'
                AND Item.is_deleted = "false"'
            );

            if(!empty($invoice['items'])){
                $fallback = $this->input->get('fallback');
                foreach($invoice['items'] as $k => $val){
                    $fallback = $fallback ? '?item='.$val['id'].'&fallback='.$fallback : '?item='.$val['id'];
                    $invoice['items'][$k]['view_url']   = current_url().$fallback;
                }
            }

            $invoice['files'] = $this->DatabaseModel->readArrayWithOptions(
                ['invoice_type' => 'sales', 'invoice_id' => $invoice['id']], '*', 'Invoice_Files'
            );
            if(!empty($invoice['files'])){
                foreach($invoice['files'] as $k => $val){
                    $invoice['files'][$k]['url'] = LIB_URL.'receipt/'.$val['file_name'];
                }
            }
        }
        return $invoice;
    }

    private function _generate_charges_pdf($js_id=null){
        $seg1               = $this->uri->segment(1) && $this->uri->segment(1) === 'alt-charges' ? 'alt' : 'lst';
        $js                 = $this->JobsheetService->_jobsheet_detail($js_id);
        $otherCharge        = $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], '*', 'JobsheetOtherCharge');
        $altServiceCharge   = $this->JobsheetService->_alt_service_charge_detail($js['task_id'], $js_id, $js['created_date']);
        $invoice            = $this->_get_invoice($js_id);

        if($seg1 === 'alt'){
            $allTodayJs         = $this->ALT_Service->loadAllTodayJs($js['task_id'], $js, $js['commentby_id']);
            $otherChargeTotal   = !empty($otherCharge) ? $otherCharge['mileage_charge'] + $otherCharge['toll'] + $otherCharge['parking'] : 0;
            // $grandTotal = $invoice['net_total'] + $otherChargeTotal;

            # altServiceCharge is currently in decimal format *100 to change it to int
            $chargesGrandTotal = $otherChargeTotal + ($altServiceCharge['total']*100);
            $jsCharges = 0;
            if(!empty($allTodayJs)){
                foreach ($allTodayJs as $k => $val) {
                    $allTodayJs[$k]['jsInvoiceCharges'] = $this->DatabaseModel->readOneWithOptions(
                        ['js_id' => $val['id']], 'net_total', 'Invoice_Charges'
                    );

                    $jsCharges = $jsCharges + $allTodayJs[$k]['jsInvoiceCharges']['net_total'];
                }
            }
            $chargesGrandTotal = $chargesGrandTotal + $jsCharges;
            # update to get the latest grand total
            $this->DatabaseModel->updateData(['js_id' => $js_id], ['grand_total' => $chargesGrandTotal], 'Invoice_Charges');
        }

        $invoice = $this->_get_invoice($js_id);

        $this->data['invoice']  = $invoice;
        $this->data['otherCharge'] = $otherCharge;
        $this->data['type']     = 'FINAL';
        $this->data['js_note']  = 'This jobsheet is final.';
        $this->data['logo']     = $_SERVER["DOCUMENT_ROOT"].'/assets/images/logo/smarter-logo.jpg';
        $this->data['js']       = $js;
        $this->data['task']     = $this->TaskService->_task_detail($this->data['js']['task_id']);
        $this->data['altServiceCharge'] = $altServiceCharge;
        $this->data['formType'] = $seg1;

        $dompdf = new Dompdf\Dompdf();
        $html   = $this->load->view('v1/charges/lst/charges-pdf.tpl.php', $this->data, true);
        $dompdf->loadHtml($html);
        $dompdf->set_option('isRemoteEnabled', true);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();

        $pdf        = $dompdf->output();
        $pdfName    = uniqid().'.pdf';
        
        $upload_path = UPLOAD_PATH.'/js/'.$pdfName;
        if(file_put_contents($upload_path, $pdf)){
            $this->DatabaseModel->updateData(['js_id' => $js_id], ['pdf_name' => $pdfName], 'Invoice_Charges');

            // if(isset($this->data['task']['customer']['company']['email']) && !empty($this->data['task']['customer']['company']['email'])){
            //     // $ReceipientEmailAddr = 'testing.mael@gmail.com';
            //     $ReceipientEmailAddr = $this->data['task']['customer']['company']['email'];

            //     ob_start();
            //     $this->load->view('email/js-email.tpl.php', $this->data);
            //     $message = ob_get_clean();

            //     $this->load->library('PHPMailer_Library');
            //     $objMail = $this->phpmailer_library->load(TRUE);

            //     $objMail->setFrom('noreply@smarter.com.my', 'Smarter Computer Sdn Bhd');
            //     $objMail->addAddress($ReceipientEmailAddr, 'Smarter Computer Sdn Bhd');
            //     $objMail->addReplyTo('noreply@smarter.com.my', 'Smarter Computer Sdn Bhd');
            //     $objMail->addAttachment(UPLOAD_PATH.'/js/'.$pdfName);

            //     $objMail->isHTML(true);
            //     $objMail->Subject = 'JOBSHEET ('.$this->data['task']['ticket_id'].'-'.$this->data['js']['code'].')';
            //     $objMail->Body    = $message;
            //     $objMail->AltBody = $message;
            //     return ( $objMail->send() ? TRUE : FALSE );
            // }
        }
    }

}