<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class AccessService extends MY_Service {

    const _DB   = [ 'key'  => 1, 'code' => 'DB' ];
    const _TSK  = [ 'key'  => 2, 'code' => 'TSK' ];
    const _ATT  = [ 'key'  => 3, 'code' => 'ATT' ];
    const _CLM  = [ 'key'  => 4, 'code' => 'CLM' ];
    const _LVE  = [ 'key'  => 5, 'code' => 'LVE' ];
    const _PAY  = [ 'key'  => 6, 'code' => 'PAY' ];
    const _HR   = [ 'key'  => 7, 'code' => 'HR' ];
    const _RPT  = [ 'key'  => 8, 'code' => 'RPT' ];
    const _MGM  = [ 'key'  => 9, 'code' => 'MGM' ];
    const _CAL  = [ 'key' => 10, 'code' => 'CAL' ];
    const _SET  = [ 'key' => 11, 'code' => 'SET' ];
    const _NTF  = [ 'key' => 12, 'code' => 'NTF' ];
    const _ITEM = [ 'key' => 13, 'code' => 'ITEM' ];
    const _CHRG = [ 'key' => 14, 'code' => 'CHRG' ];
    const _XPRT = [ 'key' => 15, 'code' => 'XPRT' ];
    const _STK  = [ 'key' => 16, 'code' => 'STK' ];
    const _SLS  = [ 'key' => 17, 'code' => 'SLS' ];
    const _PWD  = [ 'key' => 18, 'code' => 'PWD' ];
    const _CHG  = [ 'key' => 19, 'code' => 'CHG' ];
    const _LSTCHG = [ 'key' => 20, 'code' => 'LSTCHG' ];
    const _PCH = [ 'key' => 21, 'code' => 'PCH' ];

    const _ACCESS_GROUP = [
        1 => 'DB',
        2 => 'TSK',
        3 => 'ATT',
        4 => 'CLM',
        5 => 'LVE',
        6 => 'PAY',
        7 => 'HR',
        8 => 'RPT',
        9 => 'MGM',
        10 => 'CAL',
        11 => 'SET',
        12 => 'NTF',
        13 => 'ITEM',
        14 => 'CHRG',
        15 => 'XPRT',
        16 => 'STK',
        17 => 'SLS',
        18 => 'PWD',
        19 => 'CHG',
        20 => 'LSTCHG',
        21 => 'PCH',
    ];

    private $Services = [
        'SettingService' => 'SettingService'
    ];

    function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: MAIN FUNCTIONS */
        public function _all_access_group(){
            $access_group = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->AccessGrp, 'name ASC', $this->TableService->AccessGrp);
            if(!empty($access_group)){
                foreach ($access_group as $k => $val) {
                    $access_group[$k]['department'] = $this->SettingService->_department_detail($val['department_id']);
                }
            }
            return $access_group;
        }

        public function _module_indexes($group_id){
            return $this->DatabaseModel->readArrayQuery(
                'SELECT group_index FROM '.$this->TableService->Access.' WHERE group_id = '.$group_id.' GROUP BY group_index'
            );
        }

        public function _user_access_listing($group_id){
            return $this->DatabaseModel->readArrayWithOptions(['group_id' => $group_id], $this->TableFieldService->Access, $this->TableService->Access);
        }

        public function _group_by_department($department_id){
            $access_group = $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id
            ], $this->TableFieldService->AccessGrp, 'name ASC', $this->TableService->AccessGrp);
            return $access_group;
        }

        public function _user_access($user_id){
            $profile     = $this->UserService->_employee_detail($user_id);
            $user_access = $this->getUserAccess($profile['user']['group_id'], $user_id);
            return $user_access;
        }

        private function getUserAccess($group_id, $user_id){
            $globalAccess = [];
            $access_code  = [];
            $access_key   = [];     // the key of all access group which is the index
            $global_access = $this->config->item('access');
            $access_group = $this->_user_access_listing($group_id);     // all list of access_code from db
            if(!empty($access_group)){
                foreach ($access_group as $val) {
                    $access_key[]  = self::_ACCESS_GROUP[$val['group_index']];
                    $access_code[] = $val['access_code'];
                }
            }

            $access_key = !empty($access_key) ? array_unique($access_key) : [];
            $access_code = array_merge($access_code, $access_key);

            if(!empty($global_access)){
                # all access key includes group index
                $globalAccess = $this->array_flatten($global_access);
            }

            if($user_id == 1){
                if(!empty($globalAccess)){
                    foreach ($globalAccess as $index => $row) {
                        $globalAccess[$index] = true;
                    }
                }
            } else {
                if(!empty($access_code) && !empty($globalAccess)){
                    foreach ($globalAccess as $key => $value) {
                        # set all key to false by default
                        $globalAccess[$key] = false;
                    }
                    foreach ($globalAccess as $index => $row) {
                        foreach ($access_code as $code) {
                            if($index == $code){
                                $globalAccess[$index] = true;
                                continue;
                            }
                        }
                    }
                }
            }

            // print_array($globalAccess); exit();
            return $globalAccess;
        }

        private function array_flatten($array) { 
          if (!is_array($array)) { 
            return FALSE; 
          } 
          $result = array(); 
          foreach ($array as $key => $value) { 
            if (is_array($value)) { 
              $result = array_merge($result, $this->array_flatten($value)); 
            } 
            else { 
              $result[$key] = $value; 
            } 
          } 
          return $result; 
        }

    /* START :: DATA FILTRATION BASED ON ACCESS */
        public function _only_user_department($department, $department_id){
            $dep = [];
            if(!empty($department)){
                foreach ($department as $k => $val) {
                    if($val['id'] == $department_id){
                        $dep[] = $val;
                        break;
                    }
                }
            }
            return $dep;
        }

        public function _only_user_group($group, $user_group_id){
            $groupArr = [];
            if(!empty($group)){
                foreach ($group as $k => $val) {
                    if($val['id'] == $user_group_id){
                        $groupArr[] = $val;
                        break;
                    }
                }
            }
            return $groupArr;
        }

        public function _only_self_user($users, $user_id){
            $userArr = [];
            if(!empty($users)){
                foreach ($users as $k => $val) {
                    if($val['id'] == $this->user_id){
                        $userArr[] = $val;
                        break;
                    }
                }
            }
            if(!empty($userArr)){
                foreach ($userArr as $k => $val) {
                    unset($userArr[$k]['profile']);
                    $userArr[$k]['profile']['code_name'] = $val['profile']['code_name'];
                }
            }
            return $userArr;
        }
}