<?php
defined('BASEPATH') OR exit('No direct script access allowed');
# OPERATION
class LST_ChargesController extends MY_Handler {
    public $pageMainTitle = 'Task / Helpdesk';
    public $task_id       = 0;
    public $js_id         = 0;
	public $role_id;

	public static $root_file 	= '';
    public static $root_parent  = '';
	public static $prefix_url   = '/task-charges/';

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'task/JobsheetService'                  => 'JobsheetService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/JobsheetService'                   => 'JobsheetService',
        'SettingService'                        => 'SettingService',
        'task/LST_Service'                      => 'LST_Service',
        'task/TaskMainService'                  => 'TaskMainService',
    ];

	function __construct() {
		parent::__construct();
		$this->load->service($this->Services);

        $this->role_id 	    = $this->session->userLogged['role_id'];
        //$this->task_id      = (int)str_replace('task-', '', $this->uri->segment(2));
        $this->task_id      = $this->uri->segment(2);
        $this->js_id        = $this->uri->segment(4);
        self::$root_file    = VERSION.'/task/jobsheet/alt-lst-charges/_component/';
        self::$root_parent  = VERSION.'/task/jobsheet/';
        self::$prefix_url   = base_url(self::$prefix_url.$this->task_id.'/lst-charges/'.$this->js_id);

		$this->data['root_file']   = self::$root_file;
        $this->data['root_parent'] = self::$root_parent;
        $this->data['prefixUrl']   = self::$prefix_url;
        $this->data['team_name']   = 'LST';

        if($this->session->userLogged['role_id'] == UserService::_STAFF){
            $js           = $this->JobsheetService->_jobsheet_detail($this->js_id);
            $commentby_id = !empty($js) ? $js['commentby_id'] : 0;
            if($commentby_id != $this->session->userLogged['id']){
                exit('Access denied.');
            }
        }
	}

    /* START :: DEFAULT */
        public function index($task_id=null, $js_id=null){
            $user_id        = $this->session->userLogged['id'];
            $task           = $this->OP_TaskService->getTaskDetail($task_id);
            $js             = $this->JobsheetService->_jobsheet_detail($js_id);
            $component      = $this->LST_Service->_load_main_component($task_id, $task, $js, $js_id);

            if($component['refresh']){ redirect(current_url(), 'refresh'); }

            $this->data['task']         = $task;
            $this->data['js']           = $component['js'];
            $this->data['js_id']        = $js_id;
            $this->data['charges']      = $component['charge'];
            $this->data['other_charge'] = $component['otherCharge'];
            $this->data['svc_charge']   = $component['svcCharge'];
            $this->data['rate']         = $component['rate'];
            $this->data['totalCharge']  = $component['totalCharge'];
            $this->data['back_url']     = url_seg_remover(current_url(), 2);
            $this->data['invoice_url']  = current_url().'/invoice';
            $this->load->views([
                self::$root_file.'lst.tpl.php', 
                self::$root_file.'../js-script.tpl.php'
            ], $this->data);
        }

    /* START :: INVOICE */
        public function invoice($task_id=null, $js_id=null){
            $component      = $this->TaskMainService->verify_platform($task_id, $this->data);
            $task           = $this->OP_TaskService->getTaskDetail($task_id);
            $js = $this->JobsheetService->_jobsheet_detail($js_id);
            $js_component      = $this->LST_Service->_load_main_component($task_id, $task, $js, $js_id);
            $user           = $component['user'];
            if(!empty($js)){
                $js['attnd'] = $this->DatabaseModel->readOneWithOptions(['id' => $js['taskattnd_id']], 'check_in, check_out', self::$tbl->TaskAttnd);
            }

            if(!empty($user)){
                $user['addr'] = $this->UserService->_addr_detail($user['id']);
            }

            $this->data['task']     = $component['task'];
            $this->data['comments'] = $component['cmtArr'];
            $this->data['user']     = $component['user'];
            $this->data['js']       = $js;
            $this->data['charges']      = $js_component['charge'];
            $this->data['other_charge'] = $js_component['otherCharge'];
            $this->data['svc_charge']   = $js_component['svcCharge'];
            $this->data['rate']         = $js_component['rate'];
            $this->data['totalCharge']  = $js_component['totalCharge'];
            $this->data['done_url'] = dirname(current_url());
            $this->load->view(self::$root_file.'invoice.tpl.php', $this->data);
        }

    /* START :: AJAX REQUEST */
        public function add_service_charge($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $svcChargeID = $this->DatabaseModel->createData([
                'task_id'       => $task_id,
                'js_id'         => $js_id,
                'created_date'  => getCurrentTimeStamp()
            ], self::$tbl->JsServiceCharge);

            echo $svcChargeID;
        }

        public function delete_service_charge($task_id=null, $js_id=null){
            $this->noDirectAccess();
            if($this->input->get('svc_chargeid')){
                $this->DatabaseModel->deleteData(['id' => $this->input->get('svc_chargeid')], self::$tbl->JsServiceCharge);
            }
        }

        public function verify_js($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $verify_type = $this->input->get('verify_type');
            $status      = $this->input->get('isVerified') === 'true' ? 1 : 0;
            $charge_id   = $this->input->get('charge_id');

            if($verify_type){
                $verifyData = ['manager_verify' => $status];

                if($verify_type === 'js'){
                    $this->DatabaseModel->updateData(['id' => $js_id], $verifyData, self::$tbl->Jobsheet);
                }
                if($verify_type === 'charge'){
                    $this->DatabaseModel->updateData(['id' => $charge_id], $verifyData, self::$tbl->JsCharge);
                }
                if($verify_type === 'othercharge'){
                    $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, self::$tbl->JsOtherCharge);
                }
            }
        }

        public function confirm_verification($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $this->DatabaseModel->updateData(['id' => $js_id], [
                'internal_verify'       => JobsheetService::_JS_MANAGER_VERIFY,
                'verification_status'   => JobsheetService::_JS_MANAGER_VERIFY
            ], self::$tbl->Jobsheet);
        }

}