<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class ALT_ChargesController extends REST_Controller {

    public $pageMainTitle = 'Task / Helpdesk';
    public $task_id       = 0;
    public $js_id         = 0;
    public $role_id;

    public static $root_file    = '';
    public static $root_parent  = '';
    public static $prefix_url   = '/task-charges/';

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'task/JobsheetService'                  => 'JobsheetService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        // 'operation/task/OP_TaskDeleteService'   => 'OP_TaskDeleteService',
        // 'operation/task/OP_TaskManagerService'  => 'OP_TaskManagerService',
        // 'operation/task/OP_TaskStaffService'    => 'OP_TaskStaffService',
        'task/JobsheetService'                   => 'JobsheetService',
        'SettingService'                        => 'SettingService',
        'task/ALT_Service'                      => 'ALT_Service',
    ];

    function __construct() {
        parent::__construct();
        $this->load->service($this->Services);
        $this->role_id      = null;
    }

    /* START :: DEFAULT */
        public function all_get($task_id=null, $js_id=null){
            $user_id        = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            $this->task_id  = $task_id;
            $this->js_id    = $js_id;
            $task           = $this->OP_TaskService->getTaskDetail($task_id, $user_id);
            $js             = $this->JobsheetService->_jobsheet_detail($js_id);
            $component      = $this->ALT_Service->_load_main_component($task_id, $task, $js, $js_id);

            $js           = $component['js'];
            $all_today_js = $component['all_today_js'];
            $first_js     = $component['first_js'];
            $last_js      = $component['last_js'];
            $charges      = $component['charge'];
            $other_charge = $component['otherCharge'];
            $svc_charge   = $component['svcCharge'];
            $rate         = $component['rate'];
            $totalCharge  = $component['totalCharge'];
            $altServiceCharge = $component['altServiceCharge'];
            $attc         = $component['attc'];

            $data_tab = [];
            $i = 0;
            if(!empty($charges)){
                foreach ($charges as $k => $val) {
                    $i++;
                    $data_tab[] = [
                        'no' => $i,
                        'ssn' => $val['ssn'],
                        'description' => $val['description'],
                        'qty' => $val['qty'],
                        'price' => $val['price'],
                        'cost' => $val['cost'],
                        'margin_profit' => $val['margin_profit'],
                        'profit_sharing' => $val['profit_sharing'],
                        'total' => $val['total'],
                        'invoice_src' => $val['invoice_src'],
                        'is_toll' => false,
                        'is_parking' => false,
                        'is_mileage' => false
                    ];
                }
            }

            // print_array($component); exit();

            if(!empty($other_charge)){
                # other charge
                $data_tab = array_merge($data_tab, [
                    [
                        'no' => '',
                        'ssn' => '',
                        'description' => 'Toll Claim',
                        'qty' => '',
                        'price' => $other_charge['toll'],
                        'cost' => '',
                        'margin_profit' => '',
                        'profit_sharing' => '',
                        'total' => $other_charge['toll'],
                        'invoice_src' => '',
                        'is_toll' => true,
                        'is_parking' => false,
                        'is_mileage' => false
                    ],
                    [
                        'no' => '',
                        'ssn' => '',
                        'description' => 'Parking Claim',
                        'qty' => '',
                        'price' => $other_charge['parking'],
                        'cost' => '',
                        'margin_profit' => '',
                        'profit_sharing' => '',
                        'total' => $other_charge['parking'],
                        'invoice_src' => '',
                        'is_toll' => false,
                        'is_parking' => true,
                        'is_mileage' => false
                    ],
                    [
                        'no' => '',
                        'ssn' => '',
                        'description' => 'Mileage (KM), 
Petrol Price: RM 1.95
SPC: 13 km per liter
Formula: mileage x (petrol price / spc)',
                        'mileage',
                        'qty' => '',
                        'price' => '',
                        'cost' => '',
                        'margin_profit' => '',
                        'profit_sharing' => '',
                        'total' => $other_charge['mileage_charge'],
                        'invoice_src' => '',
                        'is_toll' => false,
                        'is_parking' => false,
                        'is_mileage' => true
                    ]
                ]);
            }

            // print_array($data_tab); exit();

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status'        => !empty($data_tab) ? true : false,
                // 'task'         => $task,
                // 'js'           => $component['js'],
                // 'all_today_js' => $component['all_today_js'],
                // 'first_js'     => $component['first_js'],
                // 'last_js'      => $component['last_js'],
                // 'js_id'        => $js_id,
                // 'charges'      => $component['charge'],
                // 'other_charge' => $component['otherCharge'],
                // 'svc_charge'   => $component['svcCharge'],
                // 'rate'         => $component['rate'],
                // 'totalCharge'  => $component['totalCharge'],
                // 'altServiceCharge' => $component['altServiceCharge'],
                // 'attc'         => $component['attc'],
                'data_tab'     => $data_tab,
                'selling_price_total' => !empty($totalCharge) ? $totalCharge['selling_price'] : 0,
                'total_charge' => !empty($totalCharge) ? $totalCharge['total'] : 0,
            ]);
        }

    /* START :: AJAX REQUEST */
        public function total_to_alt($task_id=null, $js_id=null){
            $js               = $this->JobsheetService->_jobsheet_detail($js_id);
            $totalCharge      = $this->JobsheetService->_total_charge_detail($js_id);
            $altServiceCharge = $this->JobsheetService->_alt_service_charge_detail($task_id, $js_id, $js['created_date']);

            echo json_encode([
                'total_charge'         => $totalCharge['total'],
                'service_charge_total' => $altServiceCharge['total'],
                'grand_total'          => $totalCharge['grand_total']
            ]);
        }

        public function add_service_charge($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $svcChargeID = $this->DatabaseModel->createData([
                'task_id'       => $task_id,
                'js_id'         => $js_id,
                'created_date'  => getCurrentTimeStamp()
            ], self::$tbl->JsServiceCharge);

            echo $svcChargeID;
        }

        public function delete_service_charge($task_id=null, $js_id=null){
            $this->noDirectAccess();
            if($this->input->get('svc_chargeid')){
                $this->DatabaseModel->deleteData(['id' => $this->input->get('svc_chargeid')], self::$tbl->JsServiceCharge);
            }
        }

        public function verify_js($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $verify_type = $this->input->get('verify_type');
            $status      = $this->input->get('isVerified') === 'true' ? 1 : 0;
            $charge_id   = $this->input->get('charge_id');

            if($verify_type){
                $verifyData = ['manager_verify' => $status];

                if($verify_type === 'js'){
                    $this->DatabaseModel->updateData(['id' => $js_id], $verifyData, self::$tbl->Jobsheet);
                }
                if($verify_type === 'charge'){
                    $this->DatabaseModel->updateData(['id' => $charge_id], $verifyData, self::$tbl->JsCharge);
                }
                if($verify_type === 'othercharge'){
                    $this->DatabaseModel->updateData(['js_id' => $js_id], $verifyData, self::$tbl->JsOtherCharge);
                }
            }
        }

        public function confirm_verification($task_id=null, $js_id=null){
            $this->noDirectAccess();
            $this->DatabaseModel->updateData(['id' => $js_id], [
                'internal_verify'       => JobsheetService::_JS_MANAGER_VERIFY,
                'verification_status'   => JobsheetService::_JS_MANAGER_VERIFY
            ], self::$tbl->Jobsheet);
        }

}