<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class AttndController extends REST_Controller {

    private $Services = [
        'AttendanceService' => 'AttendanceService',
    ];

	function __construct() {
		parent::__construct();
		$this->load->service($this->Services);
	}

	public function all_get($user_id=null){
        // $nextOffset = $this->input->get('nextOffset');
        // $offset     = 0;
        // $offset     = $nextOffset ? $nextOffset : $offset;


        $next           = $this->input->get('next') ? $this->input->get('next') : 50;
        $start          = $next - 50;
        $limit          = $next;

		// $office  	= $this->SettingService->_all_office();
		$hasCheckin = $this->_check_my_attnd($user_id);
        // $company 	= $this->UserService->_all_active_company();

        $sql    = 'SELECT * FROM Attendance WHERE user_id = '.$user_id.' ORDER BY checkin DESC';
        $limitQuery  = ' LIMIT '.$start.', 50';
        $attnd  = $this->DatabaseModel->readArrayQuery($sql.$limitQuery);
        if(!empty($attnd)){
            foreach ($attnd as $k => $val) {
                $attnd[$k] = $val;
                $attnd[$k]['attndate'] = $this->AttendanceService->_attnd_date($val['attnddate_id']);
                $attnd[$k]['checkin']   = sysDateTimeFormat($val['checkin']);
				$attnd[$k]['checkout']  = sysDateTimeFormat($val['checkout']);
				$attnd[$k]['in_label']  = !isEmptyTimestamp($val['checkin']) ? $val['location_in'].' ('.$val['location_type_in'].')' : '';
				$attnd[$k]['out_label'] = !isEmptyTimestamp($val['checkout']) ? $val['location_out'].' ('.$val['location_type_out'].')' : '';
            }
        }

		// if(!empty($company)){
		// 	usort($company, function($a, $b){
		// 		return $a['company_name'] > $b['company_name'];
		// 	});
		// }

		$pages = $this->PaginationService->_get_special_pagination($start, $limit, $sql, 'AttendanceListing');
		
		$this->response([
            'status' => true,
            'attnd'  => $attnd,
            // 'office' => $office,
            // 'cust' 	 => $company,
            'hasCheckin' => $hasCheckin,
            'pages' => $pages
        ], REST_Controller::HTTP_OK);
	}

	public function last_attnd_get($user_id=null){
		$emp     = $this->UserService->_employee_detail($user_id);
		$office  = $this->SettingService->_all_office();
        $cust 	 = $this->_all_company_with_page();

        if(!empty($emp)){
			// $emp['acc'] = $this->UserService->_user_detail($user_id);
		}

		$this->response([
            'status' => true,
            'office' => $office,
            'cust' 	 => $cust['data'],
            'pages' => $cust['pages']
        ], REST_Controller::HTTP_OK);
	}

	# later on need to change to all customer ??
	public function _all_company_with_page(){
        $next           = $this->input->get('next') ? $this->input->get('next') : 50;
        $start          = $next - 50;
        $limit          = $next;

        $sql = 'SELECT CompanyCodeName.*,
                Company.usertype_id,
                Company.company_name,
                CompanyBranch.branch_name,
                CompanyBranch.company_id
                FROM CompanyCodeName 
                LEFT JOIN Company ON Company.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "company" 
                LEFT JOIN CompanyBranch ON CompanyBranch.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "branch"
                WHERE CompanyCodeName.is_active = 1
                -- AND Company.usertype_id = '.$this->config->item("user_type")["CUSTOMER"].'
                ORDER BY CompanyCodeName.code_name ASC';

        $limitQuery = ' LIMIT '.$start.', 50';

        $customers = $this->DatabaseModel->readArrayQuery($sql.$limitQuery);
        $pages = $this->PaginationService->_get_special_pagination($start, $limit, $sql, $derivedName = 'Company');

        return [
            'data'  => $customers,
            'pages' => $pages
        ];
     }

	private function _check_my_attnd($user_id){
		$hasCheckin = false;

		$attnd = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id, 'created_date' => getDateToday()], self::$field->AttndDate, self::$tbl->AttndDate);
		if(!empty($attnd)){
			$attnd = $this->DatabaseModel->readOneWithOptionsOrderBy(['attnddate_id' => $attnd['id']], self::$field->Attnd, 'id DESC', self::$tbl->Attnd);
			if(!empty($attnd)){
				$hasCheckin = isEmptyTimestamp($attnd['checkout']) ? true : false;
			} else {
				$hasCheckin = false;
			}
		} else {
			$hasCheckin = false;
		}

		return $hasCheckin;
	}

	public function submit_attnd_post($user_id=null){
		$json  = file_get_contents('php://input');
        $input = (array)json_decode($json);

		$current_timestamp 	= getCurrentTimeStamp();
		$hasCheckin 		= $this->_check_my_attnd($user_id);
		$hasCheckinRecord 	= false;

		$sql = 'SELECT Attendance.checkin, Attendance.checkout, AttendanceDate.id
	                FROM AttendanceDate 
                LEFT JOIN Attendance ON Attendance.attnddate_id = AttendanceDate.id
                WHERE AttendanceDate.user_id = '.$user_id.'
                AND AttendanceDate.created_date = "'.getDateToday().'"
                ORDER BY Attendance.checkin DESC';
        $lastAttndRecord = $this->DatabaseModel->readOneQuery($sql);

        if(!empty($lastAttndRecord)){
        	$attnddate_id = $lastAttndRecord['id'];

        	if(empty($lastAttndRecord['checkin'])){
                $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Checkin attendance attempt begin');

        		// no check in yet
        		$attndData = [
		    		'attnddate_id' 		=> $attnddate_id,
					'user_id' 	 		=> $user_id,
					'checkin' 	 		=> $current_timestamp,
					'platform' 	 		=> 'APP',
					'ip_address' 		=> $_SERVER['REMOTE_ADDR'],
					'location_in' 		=> $input['locationType'],
					'location_type_in' 	=> $input['locationType'],
					'remark_in' 		=> $input['remark'],
				];

				$attndData['location_in'] 		= $input['locationType'];
				$attndData['location_type_in'] 	= $input['locationType'];
				$attndData['remark_in'] 		= $input['remark'];

				if($input['locationType'] === 'office'){
					$attndData['office_id']   = $input['officeID'];
					$attndData['location_in'] = $input['officeName'];
				}
				if($input['locationType'] === 'site'){
					$attndData['customer_id'] = $input['customerID'];
					$attndData['location_in'] = $input['codeName'];
				}

                $this->slack_alert(currentTimeStamp().' ('.$user_id.') - attendance data '.json_encode($attndData));
				$this->DatabaseModel->createData($attndData, 'Attendance');
                $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Successful checkin');
        	} else {
        		if(empty($lastAttndRecord['checkout'])){
                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Checkout attendance attempt begin');
        			// already have check in, need check out
        			$attndData = [
		                'checkout' 	 		=> $current_timestamp,
		                'checkout_platform' => 'APP',
		                'ip_address' 		=> $_SERVER['REMOTE_ADDR'],
		                'location_out' 		=> $input['locationType'],
		                'location_type_out' => $input['locationType'],
		                'remark_out' 		=> $input['remark'],
		            ];
		            if($input['locationType'] === 'office'){
		                $attndData['office_id']    = $input['officeID'];
		                $attndData['location_out'] = $input['officeName'];
		            }
		            if($input['locationType'] === 'site'){
		                $attndData['customer_id']  = $input['customerID'];
		                $attndData['location_out'] = $input['codeName'];
		            }

                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - attendance data '.json_encode($attndData));
		            $this->DatabaseModel->updateData(['attnddate_id' => $attnddate_id], $attndData, 'Attendance');
                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Successful checkout');
        		} else {
                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Checkin attendance attempt begin');
        			// already have check out, need to check in another

        			$attndData = [
			    		'attnddate_id' 		=> $attnddate_id,
						'user_id' 	 		=> $user_id,
						'checkin' 	 		=> $current_timestamp,
						'platform' 	 		=> 'APP',
						'ip_address' 		=> $_SERVER['REMOTE_ADDR'],
						'location_in' 		=> $input['locationType'],
						'location_type_in' 	=> $input['locationType'],
						'remark_in' 		=> $input['remark'],
					];

					$attndData['location_in'] 		= $input['locationType'];
					$attndData['location_type_in'] 	= $input['locationType'];
					$attndData['remark_in'] 		= $input['remark'];

					if($input['locationType'] === 'office'){
						$attndData['office_id']   = $input['officeID'];
						$attndData['location_in'] = $input['officeName'];
					}
					if($input['locationType'] === 'site'){
						$attndData['customer_id'] = $input['customerID'];
						$attndData['location_in'] = $input['codeName'];
					}

                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - attendance data '.json_encode($attndData));
					$this->DatabaseModel->createData($attndData, 'Attendance');
                    $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Successful checkin');
        		}
        	}
        } else {
            $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Checkin attendance attempt begin');
        	// no record, need to create attendance date and do check in
        	$attnddate_id = $this->DatabaseModel->createData([
				'user_id' 	 	=> $user_id,
				'created_date' 	=> getDateToday(),
			], 'AttendanceDate');

    		$attndData = [
	    		'attnddate_id' 		=> $attnddate_id,
				'user_id' 	 		=> $user_id,
				'checkin' 	 		=> $current_timestamp,
				'platform' 	 		=> 'APP',
				'ip_address' 		=> $_SERVER['REMOTE_ADDR'],
				'location_in' 		=> $input['locationType'],
				'location_type_in' 	=> $input['locationType'],
				'remark_in' 		=> $input['remark'],
			];

			$attndData['location_in'] 		= $input['locationType'];
			$attndData['location_type_in'] 	= $input['locationType'];
			$attndData['remark_in'] 		= $input['remark'];

			if($input['locationType'] === 'office'){
				$attndData['office_id']   = $input['officeID'];
				$attndData['location_in'] = $input['officeName'];
			}
			if($input['locationType'] === 'site'){
				$attndData['customer_id'] = $input['customer_id'];
				$attndData['location_in'] = $input['codeName'];
			}

            $this->slack_alert(currentTimeStamp().' ('.$user_id.') - attendance data '.json_encode($attndData));
			$this->DatabaseModel->createData($attndData, 'Attendance');
            $this->slack_alert(currentTimeStamp().' ('.$user_id.') - Successful checkin');
        }

    	$this->response([
            'status' => true,
        ], REST_Controller::HTTP_OK);
	}

    private function slack_alert($txt) {
		$msg = array('text' => 'APP '.$txt);
		$c = curl_init(MODE === 'PRODUCTION' ? SLACK_WEBHOOK_LIVE : SLACK_WEBHOOK_TEST);
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($c, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($c, CURLOPT_POST, true);
		curl_setopt($c, CURLOPT_POSTFIELDS, array('payload' => json_encode($msg)));
		curl_exec($c);
		curl_close($c);
	}

}