<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class StockTransferController extends REST_Controller {
    
    public $user_id = null;
    public $company_id = null;
    public $profile = null;
    public $user_access = [];

    private $Services = [
        'StockService' => 'StockService'
    ];

    function __construct() {
        parent::__construct();
        $this->load->service($this->Services);

        $this->user_id  = $this->input->get('user_id');
        $this->profile  = $this->UserService->_employee_detail($this->user_id);
        $this->user_access = $this->AccessService->_user_access($this->user_id);
    }

    public function index_post(){
        $json  = file_get_contents('php://input');
        $input = (array)json_decode($json);
        $inputPost = ['location' => 'ALL'];

        $allUserItemLocations = $this->StockService->_all_user_item_location($this->user_id);
        $userFilteredItemLocation = !empty($allUserItemLocations) ? $allUserItemLocations[0]['location'] : null;
        if(!empty($allUserItemLocations) && count($allUserItemLocations) > 1){
            $inputPost = ['location' => 'ALL'];
        }

        if(isset($input['filter']) && ($input['filter'] == true)){
            $inputPost = $input;
        }

        $component  = $this->_get_item_with_page($allUserItemLocations, $inputPost);
        $queryStr   = null;
        $employeeLocation   = $this->SettingService->_all_employee_active_location();
        $custLocation       = $this->SettingService->_all_customer_active_location();
        $strUserLocations = !empty($allUserItemLocations) ? array_column($allUserItemLocations, 'location') : [];
        
        $items = $component['item'];
        if(!empty($items)){
            foreach($items as $k => $val){
                if(!isset($val['username'])){
                    $sql = 'SELECT
                            ItemTransferRecord.tx_id,
                            ItemTransferRecord.id AS transfer_id,
                            ItemTransferRecord.transfer_status,
                            ItemTransferRecord.transferred_by,
                            ItemTransferRecord.created_date,
                            User.username
                        FROM ItemTransferRecord
                        LEFT JOIN Item ON Item.id = ItemTransferRecord.item_id
                        LEFT JOIN User ON User.id = ItemTransferRecord.transferred_by
                        WHERE Item.id = '.$val['itemId'].'
                        ORDER BY ItemTransferRecord.created_date DESC LIMIT 1
                    ';

                    $transData = $this->DatabaseModel->readOneQuery($sql);
                    if(!empty($transData)){
                        $items[$k] = array_merge($items[$k], $transData);
                    } else {
                        $items[$k]['username'] = "";
                    }
                }

                $items[$k]['canAccept'] = false;
                if(
                    (array_search(
                        !empty($val['transfer_record']) 
                            ? $val['transfer_record']['to_location']
                            : null, $strUserLocations) !== false) ||
                    (array_search(
                        !empty($val['transfer_record']) 
                        ? $val['transfer_record']['from_location']
                        : null, $strUserLocations) !== false)
                ){
                    # the sender (cancel) and receiver (accept) of this item should be able to see the action button
                    $items[$k]['canAccept'] = true;
                }
            }
        }

        if(!empty($allUserItemLocations) && count($allUserItemLocations) > 1){
            $allUserItemLocations = array_merge([[
                'id' => 'ALL',
                'user_id' => 'ALL',
                'location' => 'ALL',
                'isDefault' => null,
                'description' => null,
            ]], $allUserItemLocations);
        }

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => !empty($items) ? true : false,
            'items'     => $items,
            'options'   => [
                'itemGroup' => $this->SettingService->_all_item_group(),
                'employeeLocation'  => $employeeLocation,
                'custLocation'      => $custLocation,
                'allUserItemLocations' => $allUserItemLocations,
                'userFilteredItemLocation' => $userFilteredItemLocation
            ],
            'pages'     => $component['pages'],
            'rows'      => !empty($items) ? count($items) : 0,
            'input' => $input,
            // 'offset'    => count($items) >= 20 ? $offset + 20 : $offset, # set for the next offset fetch
        ], REST_Controller::HTTP_OK);
    }

    public function next_tx_no_get(){
        $lastTx = $this->DatabaseModel->readOneQuery('SELECT 
            id, tx_no 
            FROM ItemTransferTransaction 
            ORDER BY id DESC LIMIT 1'
        );
        $nextTxNo = stockTransferTxGenerator(!empty($lastTx) ? $lastTx['tx_no'] : 0);

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => true,
            'nextTxNo'  => $nextTxNo,
        ], REST_Controller::HTTP_OK);
    }

    public function transfer_item_post(){
        $json  = file_get_contents('php://input');
        $input = (array)json_decode($json);

        $locationType   = $input['locationType'];
        $location     = $input['location'];
        $itemIds        = $input['itemIds'] ? $input['itemIds'] : [];
        $itemRemark     = $input['item_remark'] ? (array)$input['item_remark'] : [];
        $itemRemarkArr  = [];

        if($itemRemark){
            foreach($itemRemark as $k => $val){
                $itemRemarkArr[$val->id] = $val->remark;
            }
        }

        // $this->response([
        //     'http_status_code' => REST_Controller::HTTP_OK,
        //     'status'    => true,
        //     'post' => $_POST
        // ], REST_Controller::HTTP_OK);

        // exit();
        
        if($itemIds && $location){
            $users = $this->UserService->_employee_by_location($location);
            $transferTxData = [
                'description'   => $input['description'],
                'tx_no'         => $input['tx_no'],
                'tx_date'       => $input['tx_date'],
                'reason'        => $input['reason'],
                'sender_remark' => $input['remark'],
                'receiver_item_location' => $location,
                // 'receiver_id'   => !empty($user) ? $user['user_id'] : 0,
                'createdby_id'  => $this->profile['user_id'],
                'created_date'  => currentTimeStamp()
            ];
            $tx_id = $this->DatabaseModel->createData($transferTxData, 'ItemTransferTransaction');

            foreach($itemIds as $itemId){
                # 1. get the last item location
                $item = $this->DatabaseModel->readOneWithOptions(['id' => $itemId], 'location', 'Item');
                $lastItemlocation = !empty($item) ? $item['location'] : null;
                $_itemRemark = isset($itemRemarkArr[$itemId]) ? $itemRemarkArr[$itemId] : "";
                

                # 2. create a new transfer record
                $this->DatabaseModel->createData([
                    'tx_id'             => $tx_id,
                    'from_location'  => $lastItemlocation,
                    'to_location'    => $location,
                    'item_id'           => $itemId,
                    'transferred_by'    => $this->profile['user_id'],
                    'created_date'      => currentTimeStamp(),
                    'item_remark'       => $_itemRemark
                ], 'ItemTransferRecord');
            }

            if($locationType === 'customer'){
                $this->_notify_customer($items, $location, $users, $input['tx_no']);
            }
        }
        
        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => true,
        ], REST_Controller::HTTP_OK);
    }


    // ======================================================


    public function transactions_get(){
        $lastTxId   = $this->input->get('lastTxId') ? $this->input->get('lastTxId') : 0;
        $userLocations = $this->StockService->_all_user_item_location($this->user_id);
        $locations = "NULL";
        if(!empty($userLocations)){
            $locations = implodeStrArray(array_column($userLocations, 'location'));
        }

        $component  = $this->_get_tx_with_page();

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => !empty($tx) ? true : false,
            'tx'        => $component['tx'],
            'pages'     => $component['pages'],
            'rows'      => count($component['tx']),
        ], REST_Controller::HTTP_OK);
    }

    public function transaction_details_get($tx_id=null){
        $tx = $this->DatabaseModel->readOneWithOptions(['id' => $tx_id], '*', 'ItemTransferTransaction');

        if(!empty($tx)){
            $tx['sign_url'] = !empty($tx['sign']) ? SIGN_URL.$tx['sign'] : '#';
            $tx['sender'] = $this->UserService->_employee_detail($tx['createdby_id']);
        }

        $sql = 'SELECT 
                    Item.item_group_id,
                    Item.id as itemId,
                    Item.sn,
                    Item.item_type,
                    Item.item_desc,
                    Item.cust_item_desc,
                    Item.cost,
                    Item.selling_price,
                    Item.manufacturer_sn,
                    Item.created_on,
                    Item.qty,
                    Item.is_deleted,
                    Item.batch_no,
                    Item.is_exported,
                    Item.exported_times,
                    Item.sub_total,
                    Item.location AS item_location,
                    ItemSales.id AS ItemSalesId,
                    -- ItemLocation.location AS item_location,
                    ItemGroup.name AS group_name
                FROM Item
                -- LEFT JOIN ItemTransferRecord ON ItemTransferRecord.to_location = Item.location
                -- LEFT JOIN Item ON Item.id = ItemTransferRecord.item_id
                LEFT JOIN ItemTransferRecord ON ItemTransferRecord.item_id = Item.id
                LEFT JOIN ItemSales ON ItemSales.item_id = Item.id
                LEFT JOIN ItemGroup ON ItemGroup.id = Item.item_group_id
                WHERE ItemTransferRecord.tx_id = '.$tx_id;
        $items = $this->DatabaseModel->readArrayQuery($sql);

        if(!empty($items)){
            foreach ($items as $k => $val) {
                $items[$k]['desc_hdr'] = 'SALES'; //D/O or SALES : put SALES for now
                // $items[$k]['transfer_record'] = $this->_transfer_record_details($val['itemId']);
            }
        }

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => !empty($tx) ? true : false,
            'tx'        => $tx,
            'items'     => $items,
            'rows'      => count($tx),
        ], REST_Controller::HTTP_OK);
    }

    public function sign_upload($tx_id=null){
        if(isset($_POST['image_base64'])){
            $verifierData = [
                'verifier_name' => $this->input->post('verifier_name'),
                'verifier_ic'   => $this->input->post('verifier_ic'),
            ];

            $image_parts    = explode(";base64,", $_POST['image_base64']);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type     = $image_type_aux[1];
            $image_base64   = base64_decode($image_parts[1]);
            $imgName        = uniqid().'.png';
            $file           = SIGN_PATH.'/'.$imgName;
            
            $txData = [
                'verifier'      => json_encode($verifierData),
                'sign'          => $imgName
            ];

            file_put_contents($file, $image_base64);
            $this->DatabaseModel->updateData(['id' => $tx_id], $txData, 'ItemTransferTransaction');
            # to do - send pdf
            // $this->_generate_js_pdf($js_id, 'ref');
            echo true;
        }
    }

    public function entry(){
        $location = $this->session->stock_transfer_data ? $this->session->stock_transfer_data['location'] : null;
        $itemIds    = $this->session->stock_transfer_data ? $this->session->stock_transfer_data['itemIds'] : null;
        $locationType = $this->session->stock_transfer_data ? $this->session->stock_transfer_data['locationType'] : null;
        $itemIdsArr = !empty($itemIds) ? implode(',', $itemIds) : '';
        $location   = $this->SettingService->_location_by_id($location);
        $items = $this->DatabaseModel->readArrayQuery('SELECT Item.*, 
                ItemLocation.location AS from_location,
                OptProject.title AS project_name 
            FROM Item 
            LEFT JOIN ItemLocation ON ItemLocation.id = Item.location
            LEFT JOIN OptProject ON OptProject.id = Item.project_code
            WHERE Item.id IN('.$itemIdsArr.')');
        
        $availableItems = $this->DatabaseModel->readArrayQuery('SELECT Item.*, 
                ItemLocation.location AS from_location,
                OptProject.title AS project_name 
            FROM Item 
            LEFT JOIN ItemLocation ON ItemLocation.id = Item.location
            LEFT JOIN OptProject ON OptProject.id = Item.project_code
            WHERE Item.id NOT IN('.$itemIdsArr.')');
        
        $lastTx = $this->DatabaseModel->readOneQuery('SELECT 
            id, tx_no 
            FROM ItemTransferTransaction 
            ORDER BY id DESC LIMIT 1'
        );
        $nextTxNo = stockTransferTxGenerator(!empty($lastTx) ? $lastTx['tx_no'] : 0);

        $this->data['nextTxNo']     = $nextTxNo;
        $this->data['to_location']  = $location;
        $this->data['items']        = $items;
        $this->data['availableItems'] = $availableItems;
        $this->data['cancel_url']   = self::$prefix_url;
        $this->data['verifyUrl']    = current_url().'/ajax-verify';
        $this->data['create_url']   = current_url().'/create';
        $this->load->views([self::$root_file.'transfer-form.tpl.php'], $this->data);
    }

    private function _notify_customer($items=[], $location=null, $user=null, $tx_no=null){
        $this->load->library('email');

        $data = [
            'items'     => $items,
            'location'  => $location,
            'tx_no'     => $tx_no
        ];

        $message = $this->load->view(ROOT_TPL.'email/stock-transfer.email.php', $data, true);

        $this->email->initialize(sendgridConfig());
        $this->email->from('noreply@smarter.com.my', 'SSMS Automail');
        $emails = [];
        $receiverNames = [];

        if(!empty($user)){
            foreach($user as $val){
                if(!empty($val['email'])){ array_push($emails, $val['email']); }
                if(!empty($val['fullname'])){ array_push($receiverNames, $val['fullname']); }
            }
            if(!empty($emails)){ $emails = implode(',', $emails); }
            if(!empty($receiverNames)){ $receiverNames = implode(',', $receiverNames); }
        }

        if(!empty($emails) && !empty($receiverNames)){
            $toEmail = MODE === 'DEVELOPMENT' ? TESTING_EMAIL : $emails;
            $toName  = MODE === 'DEVELOPMENT' ? TESTING_NAME : $receiverNames;

            $this->email->to($toEmail, $toName);
            $this->email->subject('NEW STOCK TRANSFER RECEIVED');
            $this->email->message($message);
            $this->email->send();
        } else {
            $this->session->set_flashdata('err_msg', 'Failed to send email to the customer.');
        }
    }

    public function _get_item_with_page($allUserItemLocations=null, $inputPost=null){
        $json  = file_get_contents('php://input');
        $input = (array)json_decode($json);

        $ssnSearch      = $this->input->get('ssn') ? $this->input->get('ssn') : null;
        $lastItemId     = $this->input->get('lastItemId') ? $this->input->get('lastItemId') : null;
        $next           = $this->input->get('next') ? $this->input->get('next') : 50;
        $date_from      = $this->input->get('from');
        $date_to        = $this->input->get('to');
        // $activeTab      = $this->input->get('activeTab') ? $this->input->get('activeTab') : '';
        $activeTab      = isset($inputPost['activeScreenLabel']) 
            ? $inputPost['activeScreenLabel'] 
            : ($this->input->get('activeTab') ? $this->input->get('activeTab') : '');
        $start          = $next - 50;
        $limit          = $next;
        $task           = [];
        $itemLocationName = "";
        $searchFilter = [
            'location' => isset($inputPost['location']) ? '"'.$inputPost['location'].'"' : null,
            'itemGroupId' => isset($inputPost['itemGroupId']) ? $inputPost['itemGroupId'] : null,
            'sn' => isset($inputPost['sn']) ? $inputPost['sn'] : null
        ];

        if(!empty($allUserItemLocations)){
            if($inputPost['location'] === 'ALL'){
                $searchFilter['location'] = !empty($allUserItemLocations) ? 
                    implodeStrArray(array_column($allUserItemLocations, 'location')) : 
                    "";
            }
        } else {
            # user has empty location. not assigned to any location yet so it should be NULL
            if($this->profile['user_id'] > 1){
                $searchFilter['location'] = 'NULL';
            }
        }
        
        # select all items under current user location
        $selectQuery = '
            Item.item_group_id,
            Item.id as itemId,
            Item.sn,
            Item.item_type,
            Item.item_desc,
            Item.cust_item_desc,
            Item.cost,
            Item.selling_price,
            Item.manufacturer_sn,
            Item.created_on,
            Item.qty,
            Item.is_deleted,
            Item.batch_no,
            Item.is_exported,
            Item.exported_times,
            Item.sub_total,
            Item.location,
            ItemSales.id AS ItemSalesId,
            -- ItemLocation.location AS item_location,
            ItemGroup.name AS group_name,
            OptProject.title AS project_title
        ';
        if($activeTab === 'stock-list' || $activeTab === 'StockEntryList'){
            $sql = 'SELECT '.$selectQuery.'
                FROM Item
                LEFT JOIN ItemSales ON ItemSales.item_id = Item.id
                LEFT JOIN Invoice_Purchase ON Invoice_Purchase.id = Item.invoice_id
                LEFT JOIN ItemGroup ON ItemGroup.id = Item.item_group_id
                -- LEFT JOIN ItemLocation ON ItemLocation.location = Item.location
                LEFT JOIN CompanySetting_CreditTerms ON CompanySetting_CreditTerms.id = Invoice_Purchase.credit_terms_id
                LEFT JOIN OptProject ON OptProject.id = Item.project_code
                WHERE ItemSales.id IS NULL AND Item.item_type = "item" AND Item.is_deleted = 0';
        } else {
            $sql = 'SELECT '.$selectQuery.'
                , 
                ItemTransferRecord.tx_id,
                ItemTransferRecord.id AS transfer_id,
                ItemTransferRecord.transfer_status,
                ItemTransferRecord.transferred_by,
                ItemTransferRecord.created_date,
                ItemTransferTransaction.tx_date,
                ItemTransferTransaction.tx_no,
                User.username
                FROM ItemTransferRecord
                LEFT JOIN Item ON Item.id = ItemTransferRecord.item_id
                LEFT JOIN User ON User.id = ItemTransferRecord.transferred_by
                LEFT JOIN ItemSales ON ItemSales.item_id = Item.id
                LEFT JOIN Invoice_Purchase ON Invoice_Purchase.id = Item.invoice_id
                LEFT JOIN ItemGroup ON ItemGroup.id = Item.item_group_id
                -- LEFT JOIN ItemLocation ON ItemLocation.location = Item.location
                LEFT JOIN CompanySetting_CreditTerms ON CompanySetting_CreditTerms.id = Invoice_Purchase.credit_terms_id
                LEFT JOIN OptProject ON OptProject.id = Item.project_code
                LEFT JOIN ItemTransferTransaction ON ItemTransferTransaction.id = ItemTransferRecord.tx_id
                WHERE ItemSales.id IS NULL 
                AND Item.item_type = "item" 
                AND Item.is_deleted = 0';
            
            if(in_array($activeTab, ['MyPending', 'AllPending'])){
                $sql .= ' AND ItemTransferRecord.transfer_status = "pending"';
            }
        }

        $where_clause = "";
        if(!empty($searchFilter['location'])){
            if($this->profile['user_id'] > 1){
                # pending is also known as StockTransferRecord in app version. in web version it is known as pending
                if(in_array($activeTab, ['pending', 'MyPending', 'AllPending', 'StockTransferRecord'])){
                    if(
                        (!$this->user_access['STK003'] && !$this->user_access['STK002']) ||
                        ($this->user_access['STK003'] && !$this->user_access['STK002']) ||
                        ($activeTab === 'MyPending')
                    ){
                        # view own stock transfer record (includes transferred by current user)
                        $where_clause .= ' AND (
                            ItemTransferRecord.transferred_by = '.$this->profile['user_id'].'
                            OR ItemTransferRecord.to_location IN('.$searchFilter['location'].')
                        )';
                    }
                } else {
                    $where_clause .= ' AND Item.location IN('.$searchFilter['location'].')';
                }
            }
        }
        if(!empty($searchFilter['itemGroupId'])){
            $where_clause .= ' AND ItemGroup.id = '.$searchFilter['itemGroupId'];
        }
        if(!empty($searchFilter['sn'])){
            $where_clause .= ' AND Item.sn LIKE "%'.$searchFilter['sn'].'%"';
        }

        $orderBy = ' LIMIT '.$start.', 50';
        # pending is also known as StockTransferRecord in app version. in web version it is known as pending
        if(in_array($activeTab, ['pending', 'MyPending', 'AllPending', 'StockTransferRecord'])){
            // $sql = $sql.$where_clause;
            // # 1.replace the sql with a new query to apply the GROUP BY because it is not supported in the latest sql version
            // $sql = 'SELECT * FROM ('.$sql.') AS ItemTransfer ORDER BY ItemTransfer.created_date DESC';
            // # 2. replace the sql with the new query again to filter out the accepted status so that it will always take the last
            // # transaction instead of replacing it with the 2nd last from the first WHERE query
            // $sql = 'SELECT * FROM ('.$sql.') AS ItemTransfer2 WHERE ItemTransfer2.transfer_status IN ("pending", "cancelled")';
            // $where_clause = '';

            # updated on 2023-02-02
            $sql = $sql.$where_clause;
            # 1.replace the sql with a new query to apply the GROUP BY because it is not supported in the latest sql version
            $sql = 'SELECT * FROM ('.$sql.') AS ItemTransfer ORDER BY ItemTransfer.created_date DESC';
            $where_clause = '';
        }

        // $orderBy = ' ORDER BY created_on DESC LIMIT '.$start.', 50';
        $sqlQuery = $sql.$where_clause;
        // print_array($sqlQuery); exit();
        $item = $this->DatabaseModel->readArrayQuery($sqlQuery.$where_clause.$orderBy);

        $derivedName = 'ItemStock';
        $pages = $this->PaginationService->_get_special_pagination($start, $limit, $sqlQuery, $derivedName);

        if(!empty($item)){
            foreach ($item as $k => $val) {
                $transfer_id = isset($val['transfer_id']) ? $val['transfer_id'] : null;
                // $item[$k]['is_purchase_item'] = empty($val['ItemSalesId']) ? true : false;
                $item[$k]['desc_hdr'] = 'SALES'; //D/O or SALES : put SALES for now
                $item[$k]['transfer_record'] = $this->_transfer_record_details($val['itemId'], $transfer_id);
            }

            // usort($item, function($a, $b){ return $a['sn'] > $b['sn']; });
        }

        return [
            'item'  => $item,
            'pages' => $pages
        ];
    }

    public function _get_tx_with_page(){
        $next           = $this->input->get('next') ? $this->input->get('next') : 50;
        $date_from      = $this->input->get('from');
        $date_to        = $this->input->get('to');
        $start          = $next - 50;
        $limit          = $next;
        $task           = [];

        $sql = 'SELECT * FROM ItemTransferTransaction';
        $sqlWhere = '';

        if(
            (!$this->user_access['STK004'] && !$this->user_access['STK005']) ||
            (!$this->user_access['STK004'] && $this->user_access['STK005'])
        ){
            $sqlWhere = ' WHERE (createdby_id = '.$this->profile['user_id'].')';
            $sqlWhere .= ' OR (receiver_id = '.$this->profile['user_id'].')';
        }

        $orderBy = ' ORDER BY created_date DESC LIMIT '.$start.', 50';

        $tx = $this->DatabaseModel->readArrayQuery($sql.$sqlWhere.$orderBy);
        $derivedName = 'ItemTransferTransaction';
        $pages = $this->PaginationService->_get_special_pagination($start, $limit, $sql, $derivedName);

        if(!empty($tx)){
            foreach($tx as $k => $val){
                $tx[$k]['created_date'] = sysDateTimeFormat($val['created_date']);
            }
        }

        return [
            'tx'    => $tx,
            'pages' => $pages
        ];
    }

    public function update_status_post(){
        $json  = file_get_contents('php://input');
        $input = (array)json_decode($json);

        if(!empty($input)){
            $action      = $input['action'];
            $transfer_id = $input['transfer_id'];
            $itemId      = $input['itemId'];

            if($action === 'accept'){
                if($this->DatabaseModel->updateData(['id' => $transfer_id], [
                    'transfer_status'   => 'accepted',
                    'acceptedby_id'     => $this->user_id,
                ], 'ItemTransferRecord')){
                    $record = $this->DatabaseModel->readOneWithOptions(['id' => $transfer_id], 'to_location', 'ItemTransferRecord');
                    $this->DatabaseModel->updateData(['id' => $itemId], ['location' => $record['to_location']], 'Item');
                }
                // $this->session->set_flashdata('success_msg', updateMsg());
            }
            if($action === 'cancel'){
                $this->DatabaseModel->updateData(['id' => $transfer_id], [
                    'transfer_status'   => 'cancelled',
                    'acceptedby_id'     => $this->user_id,  // will be cancelled by if the status is cancelled
                ], 'ItemTransferRecord');
                // $this->session->set_flashdata('success_msg', updateMsg());
            }
        }

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status'    => true,
        ], REST_Controller::HTTP_OK);
    }

    private function _transfer_record_details($item_id=null, $transfer_id=null){
        $where = ['item_id' => $item_id];
        if(!empty($transfer_id)){
            $where['id'] = $transfer_id;
        }
        $transferRecord = $this->DatabaseModel->readOneWithOptionsOrderBy($where, '*', 'created_date DESC', 'ItemTransferRecord');

        if(!empty($transferRecord)){
            $transferRecord['created_date'] = sysDatetimeFormat($transferRecord['created_date']);
            $transferRecord['from'] = $this->SettingService->_location_by_name($transferRecord['from_location']);
            $transferRecord['to'] = $this->SettingService->_location_by_name($transferRecord['to_location']);
            $transferRecord['tx'] = $this->_tx_detail($transferRecord['tx_id']);
        }

        return $transferRecord;
    }

    private function _tx_detail($tx_id=null){
        return $this->DatabaseModel->readOneWithOptions(['id' => $tx_id], '*', 'ItemTransferTransaction');
    }

}