<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class AuthController extends REST_Controller {
	public $tblUser 			= 'User';
	public $tblEmployee 		= 'Employee';

	/* START :: USER ROLES - FOLLOWING ROLES FROM DB OptRole TABLE [DEPRECATED :: THIS APP IS NO LOGER VALIDATE ACCESS BY ROLE] */
    const _CUSTOMER 	= 1;
    const _STAFF       	= 2;
    const _MANAGER     	= 3;
    const _ADMIN  	   	= 4;
    const _SUPERADMIN  	= 5;
    const _SUPPLIER 	= 6;

    /* START :: PLEASE ENSURE THAT THIS ROLE ID IS SAME AS USER ROLES ABOVE !! */
    /* _ROLE only used to loop on role selection for employee. Not applicable for client (customer/supplier) */
    const _ROLE = [
    	2 => 'Staff',
    	3 => 'Manager',
    	4 => 'Admin',
    	5 => 'Super Admin'
    ];

    /* START :: DEPARTMENT */
    const DEP_OPERATION = 1;
    const DEP_HR  		= 2;

    function __construct(){
        parent::__construct();
    }

	public function login_post(){
    	$this->form_validation->set_rules('username', 'Username', 'required|trim');
		$this->form_validation->set_rules('password', 'Password', 'required|trim');

		$username = $this->input->post('username');
		$password = $this->input->post('password');

    	if($this->form_validation->run() == true){
    		$user = $this->DatabaseModel->readOneWithOptions([
    			'username' 	=> $username,
    			'is_active' => 1
            ], 'id, password', self::$tbl->User);

            if(!empty($user) && password_verify($password, $user['password']))
            {
                // $user = $this->UserService->_user_detail($user['id']);
                $profile = $this->UserService->_employee_detail($user['id']);
                
                $this->response([
                    'http_status_code' => REST_Controller::HTTP_OK,
                    'profile' => $profile,
                    'status' => true,
                ], REST_Controller::HTTP_OK);
            } else {
				$this->response([
	    			'status' => false,
	    			'msg' 	 => 'Either Username or Password is incorrect.'
	    		]);
			}
    	} else {
    		// $this->form_error_response($this->form_validation->error_array());
    		$this->response([
    			'status' => false,
    			'msg' 	 => 'Either Username or Password is incorrect.'
    		]);
    	}
    }

    private function recordAttendance($current_timestamp, $user_id){
    	$isExist = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id, 'created_date' => getDateToday()], 'id', 'AttendanceDate');
    	if(!empty($isExist)){
    		$attnddate_id = $isExist['id'];
    	} else {
    		$attnddate_id = $this->DatabaseModel->createData([
				'user_id' 	 	=> $user_id,
				'created_date' 	=> getDateToday(),
			], 'AttendanceDate');
    	}

    	$attnd = $this->DatabaseModel->readOneWithOptionsOrderBy(['attnddate_id' => $attnddate_id], 'id, checkin, checkout', 'checkout DESC', 'Attendance');
    	if(!empty($attnd)){
    		$hasCheckin = $hasCheckout = false;

    		if($attnd['checkin'] === '0000-00-00 00:00:00' || empty($attnd['checkin'])){
    			$hasCheckin = false;
    		} else {
    			$hasCheckin = true;
    		}

    		if($attnd['checkout'] === '0000-00-00 00:00:00' || empty($attnd['checkout'])){
    			$hasCheckout = false;
    		} else {
    			$hasCheckout = true;
    		}

    		if($hasCheckin){
    			if($hasCheckout){
    				// :: create a new login session
    				$this->DatabaseModel->createData([
			    		'attnddate_id' 	=> $attnddate_id,
						'user_id' 	 	=> $user_id,
						'checkin' 	 	=> $current_timestamp,
						'platform' 	 	=> 'APP',
						'ip_address' 	=> $_SERVER['REMOTE_ADDR']
					], 'Attendance');
    			} else {
    				// :: has logged but never checkout
    			}
    		} else {
    			$this->DatabaseModel->createData([
		    		'attnddate_id' 	=> $attnddate_id,
					'user_id' 	 	=> $user_id,
					'checkin' 	 	=> $current_timestamp,
					'platform' 	 	=> 'APP',
					'ip_address' 	=> $_SERVER['REMOTE_ADDR']
				], 'Attendance');
    		}
    	} else {
    		$this->DatabaseModel->createData([
	    		'attnddate_id' 	=> $attnddate_id,
				'user_id' 	 	=> $user_id,
				'checkin' 	 	=> $current_timestamp,
				'platform' 	 	=> 'APP',
				'ip_address' 	=> $_SERVER['REMOTE_ADDR']
			], 'Attendance');
    	}
	}

	public function logout_get($user_id=null){
		$isExist = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id, 'created_date' => getDateToday()], 'id', 'AttendanceDate');
    	if(!empty($isExist)){
    		$attnddate_id = $isExist['id'];
    	} else {
    		$attnddate_id = $this->DatabaseModel->createData([
				'user_id' 	 	=> $user_id,
				'created_date' 	=> getDateToday(),
			], 'AttendanceDate');
    	}

    	$attnd = $this->DatabaseModel->readOneWithOptionsOrderBy(['attnddate_id' => $attnddate_id], 'id, checkin, checkout', 'checkout DESC', 'Attendance');
    	if(!empty($attnd)){
    		$hasCheckin = $hasCheckout = false;

    		if($attnd['checkin'] === '0000-00-00 00:00:00' || empty($attnd['checkin'])){
    			$hasCheckin = false;
    		}

    		if($attnd['checkout'] === '0000-00-00 00:00:00' || empty($attnd['checkout'])){
    			$hasCheckout = false;
    		} else {
    			$hasCheckout = true;
    		}

    		// $hasCheckin  = isEmptyTimestamp($attnd['checkin']);
    		// $hasCheckout = isEmptyTimestamp($checkout);

    		//print_array($hasCheckout); exit();

			if($hasCheckout){
				// :: need to start a new login session
			} else {
				// :: has logged but never checkout
				$this->DatabaseModel->updateData(['attnddate_id' => $attnddate_id], [
					'checkout' 	 		=> getCurrentTimeStamp(),
					'checkout_platform' => 'APP',
					'ip_address' 		=> $_SERVER['REMOTE_ADDR']
				], 'Attendance');
			}
    	}

    	$this->response_success();
	}

    public function user_get($user_id=null){
        $profile = $this->UserService->_employee_detail($user_id);
        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'profile' => $profile,
            'status' => !empty($profile) ? true : false,
        ], REST_Controller::HTTP_OK);
    }

}