<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class AccessRightController extends REST_Controller {
	public $pageMainTitle 		= 'Group Access Right';
	public $access = [];
	public $user_id = null;
	private static $prefix_url 	= 'setting/group-access-right';

	function __construct() {
		parent::__construct();
        $this->access = $this->config->item('access');
	}

	/* START :: LISTING */
		public function all_get(){
			$this->user_id = $this->input->get('user_id') ? $this->input->get('user_id') : null;
			$access = $this->AccessService->_user_access($this->user_id);

			$this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => $this->user_id !== 'undefined' ? true : false,
                'access' => $access
            ]);
		}

		public function ajax_validate_form(){
			$this->form_validation->set_rules('name', $this->lang->line('lbl_name'), 'trim|required|callback_checkIsExist');
			if($this->form_validation->run() == true){
				echo json_encode(['status' => true]);
			} else {
				$this->FormService->returnFormError($this->form_validation->error_array());
			}
		}

	/* START :: CREATE */
		public function create(){
			if(isset($_POST['save'])){
				$this->form_validation->set_rules('name', $this->lang->line('lbl_name'), 'trim|required|callback_checkIsExist');

				if($this->form_validation->run() == true){
					$group_code_input  = $this->input->post('group_code') ? $this->input->post('group_code') : [];
					$access_code_input = $this->input->post('access_code') ? $this->input->post('access_code') : [];

					$group_id = $this->DatabaseModel->createData([
						'department_id' => $this->input->post('department_id'),
						'name' => $this->input->post('name'),
						'created_date' => currentTimeStamp(),
						'created_by' => $this->user_id
					], self::$tbl->AccessGrp);

					if($group_id){
						$accessData = [];
						if(!empty($access_code_input)){
							foreach ($access_code_input as $index_k => $access_code_arr) {
								foreach ($access_code_arr as $access_code) {
									$accessData[] = [
										'group_id' 		=> $group_id,
										'group_index' 	=> $index_k,
										'access_code' 	=> $access_code,
										'created_date' 	=> currentTimeStamp(),
										'created_by' 	=> $this->user_id
									];
								}
							}
							$this->DatabaseModel->createMultiData($accessData, self::$tbl->Access);
						}
					}

					redirect(self::$prefix_url);
				}
			}

			$this->data['department'] = $this->SettingService->_all_department();
			$this->data['back_url']   = self::$prefix_url;
			$this->load->views(ROOT_ACCESS_RIGHT.'create.tpl.php', $this->data);
		}

		public function checkIsExist($name=''){
			$isExist = false;
			$groups  = $this->DatabaseModel->readArray(self::$field->AccessGrp, self::$tbl->AccessGrp);
			if(!empty($groups)){
				foreach ($groups as $val) {
					if(getString($val['name']) === getString($name)){
						$isExist = true;
					}
				}
			}
			$this->form_validation->set_message('checkIsExist', $name.$this->lang->line('info_already_exist'));
			return $isExist ? false : true;
		}

	/* START :: UPDATE */
		public function update($group_id=null){
			$access 	   = $this->data['access'];
			$groupArr  	   = $this->DatabaseModel->readOneWithOptions(['id' => $group_id], self::$field->AccessGrp, self::$tbl->AccessGrp);
			$moduleIndexes = $this->_module_indexes($group_id);
			$accessArr 	   = $this->DatabaseModel->readArrayWithOptions(['group_id' => $group_id], self::$field->Access, self::$tbl->Access);

			if(isset($_POST['save'])){
				$this->form_validation->set_rules('name', $this->lang->line('lbl_name'), 'trim|required|callback_checkUpdateIsExist');

				if($this->form_validation->run() == true){
					$group_code_input  = $this->input->post('group_code') ? $this->input->post('group_code') : [];
					$access_code_input = $this->input->post('access_code') ? $this->input->post('access_code') : [];

					$this->DatabaseModel->updateData(['id' => $group_id], [
						'department_id' => $this->input->post('department_id'),
						'name' 			=> $this->input->post('name'),
						'modified_date' => currentTimeStamp()
					], self::$tbl->AccessGrp);

					$accessData = [];
					if(!empty($access_code_input)){
						$this->DatabaseModel->deleteData(['group_id' => $group_id], self::$tbl->Access);
						foreach ($access_code_input as $index_k => $access_code_arr) {
							foreach ($access_code_arr as $access_code) {
								$accessData[] = [
									'group_id' 		=> $group_id,
									'group_index' 	=> $index_k,
									'access_code' 	=> $access_code,
									'created_date' 	=> currentTimeStamp(),
									'created_by' 	=> $this->user_id
								];
							}
						}
						if(!empty($accessData)){
							$this->DatabaseModel->createMultiData($accessData, self::$tbl->Access);
						}
					}

					if(!empty($group_code_input)){
						$accessData = [];
						foreach ($group_code_input as $index_k => $access_code) {
							if($index_k == 4 || $index_k == 6){
								$accessData[] = [
									'group_id' 		=> $group_id,
									'group_index' 	=> $index_k,
									'access_code' 	=> $access_code,
									'created_date' 	=> currentTimeStamp(),
									'created_by' 	=> $this->user_id
								];
							}
						}
						if(!empty($accessData)){
							$this->DatabaseModel->createMultiData($accessData, self::$tbl->Access);
						}
					}

					redirect(self::$prefix_url);
				}
			}

			$this->data['access'] 			= $access;
			$this->data['groupArr'] 		= $groupArr;
			$this->data['module_indexes'] 	= $moduleIndexes;
			$this->data['accessArr'] 		= $accessArr;
			$this->data['department'] 		= $this->SettingService->_all_department();
			$this->data['back_url']   		= self::$prefix_url;
			$this->load->views(ROOT_ACCESS_RIGHT.'create.tpl.php', $this->data);
		}

		public function checkUpdateIsExist($name=''){
			if(getString($this->input->post('current_name')) !== getString($name)){
				$isExist = false;
				$groups  = $this->DatabaseModel->readArray(self::$field->AccessGrp, self::$tbl->AccessGrp);
				if(!empty($groups)){
					foreach ($groups as $val) {
						if(getString($val['name']) === getString($name)){
							$isExist = true;
						}
					}
				}
				$this->form_validation->set_message('checkIsExist', $name.$this->lang->line('info_already_exist'));
				return $isExist ? false : true;
			} else {
				return true;
			}
		}

	/* START :: SHARED FUNCTIONS */
	 	public function deleteGroup($group_id){
	 		$this->DatabaseModel->deleteData(['id' => $group_id], self::$tbl->AccessGrp);
			$this->DatabaseModel->deleteData(['group_id' => $group_id], self::$tbl->Access);
	 	}

	 	private function _module_indexes($group_id){
	 		return $this->DatabaseModel->readArrayQuery(
				'SELECT group_index FROM '.self::$tbl->Access.' WHERE group_id = '.$group_id.' GROUP BY group_index'
			);
	 	}

	 	private function _group_access($group_id){
	 		return $this->DatabaseModel->readArrayWithOptions(['group_id' => $group_id], self::$field->Access, self::$tbl->Access);
	 	}
}