<?php
defined('BASEPATH') OR exit('No direct script access allowed');

# ADDING IS AVAILABLE BUT NOT CHANGING THE INDEX !!!

$config['op_setting'] = [
	/*1 => [
		'sysCode' => '1',
		'title'   => 'Mileage Claim',
		'remarks' => 'Check to allow this team to submit mileage claim.',
	],*/
	2 => [
		'sysCode' => '2',
		'title'   => 'ALT / LST comments & charges',
		'remarks' => 'Do commenting and write ALT/LST charges',
		'include' => false,
	],
	3 => [
		'sysCode' => '3',
		'title'   => 'Transportation charges',
		'remarks' => 'Allow this team to claim petrol consumption.',
		'include' => false,
	],
	4 => [
		'sysCode' => '4',
		'title'   => 'Delivery charges',
		'remarks' => 'Allow this team to claim delivery.',
		'include' => false,
	],
	5 => [
		'sysCode' => '5',
		'title'   => 'Parking and toll fee',
		'remarks' => 'Allow this team to claim for parking and toll fee',
		'include' => false,
	],
	6 => [
		'sysCode' => '6',
		'title'   => 'Check In Attendance Options (Only for Smarter Staff)',
		'remarks' => 'Check to show check in attendance options from Task module.',
		'include' => false,
	],
];

# @include = false :: later change to true if this module is included in the user sidebar menu
$config['modules'] = [
	1 => [
		'title'   => 'Task',
		'code' 	  => 'TASK',
		'include' => false
	],
	2 => [
		'title'   => 'Attendance / OT',
		'code' 	  => 'ATTENDACE',
		'include' => false
	],
	3 => [
		'title'   => 'Claim',
		'code' 	  => 'CLAIM',
		'include' => false
	],
	4 => [
		'title'   => 'Leave Submission',
		'code' 	  => 'LEAVE',
		'include' => false
	],
	5 => [
		'title'   => 'Payslip',
		'code' 	  => 'PAYSLIP',
		'include' => false
	],
	6 => [
		'title'   => 'HR System',
		'code' 	  => 'HRSYSTEM',
		'include' => false
	],
	7 => [
		'title'   => 'Report',
		'code' 	  => 'REPORT',
		'include' => false
	],
	8 => [
		'title'   => 'Management',
		'code' 	  => 'MANAGEMENT',
		'include' => false
	],
	9 => [
		'title'   => 'Calendar',
		'code' 	  => 'CALENDAR',
		'include' => false
	],
	10 => [
		'title'   => 'Setting',
		'code' 	  => 'SETTING',
		'include' => false
	]
];

/***********************************************************************************************************
* IMPORTANT !!! FOR $config['access'] FOR TASK PLEASE KEEP THIS LAST ID UPDATED. ALL CODE NUMBER MUST BE INCREMENT.
* THIS IS DUE TO TASK HAS A LOT ACCESS RIGHT
* LAST ID : 67
***********************************************************************************************************/
# KEEP THESE 2 FILES UPDATED IF REQUIRED
# /setting/group-access-right/create.tpl.php
# application/services/AccessService.php

$config['access'] = [
	1 => [
		'DB' 		=> 'DASHBOARD',
		'DB001' 	=> 'PENDING TASK',
		'DB002' 	=> 'CALENDAR APPOINTMENT REMINDER',
		'DB003' 	=> 'TASK REMINDER',
		'DB004' 	=> 'VIEW CALENDAR BY DAY',
		'DB005' 	=> 'VIEW CALENDAR BY WEEK',
		'DB006' 	=> 'VIEW CALENDAR BY MONTH',
		'DB007' 	=> 'VIEW SCHEDULED CALENDAR'
	],
	2 => [
		'TSK' => 'TASK / HELPDESK',
		# use BREAK only for TASK to divide them into groups. 
		[
			'BREAK' => 'CREATE',
			'TSK001' => 'CREATE CUSTOMER TASK',
			'TSK002' => 'CREATE SMARTER TASK',
		],
		# IMPORTANT NOTE :: All access right after underscore (_) are the list of access right code to be disabled if the access right is checked
		# for example : TSK06 is checked, so TSK060 and TSK059 must be disabled so that user cannot check the checkbox
		[
			'BREAK' => 'SELECT',
			'TSK060' => 'SELECT OTHER COMPANY_ _Can create a temporary customer.',
			'TSK061' => 'SELECT ALL COMPANY AND ALL BRANCHES_TSK062,TSK059',
			'TSK062' => 'SELECT ONLY OWN COMPANY_TSK059,TSK061',
			'TSK059' => 'SELECT OWN COMPANY AND ITS BRANCHES_TSK061,TSK062_Can select only own company and all its branches.',
			'TSK003' => 'SELECT TEAM',
		],
		[
			'BREAK' => 'ASSIGN (SELECT ONLY 1)',
			'TSK004' => 'SELF ASSIGN_TSK005,TSK006,TSK007,TSK039,TSK063',
			'TSK005' => 'ASSIGN MULTIPLE USER (UNDER OWN GROUP & DEPARTMENT ONLY)_TSK004,TSK006,TSK007,TSK039,TSK063_Can assign to all user from the same group and department only.',
			'TSK006' => 'ASSIGN TO MULTIPLE GROUP (UNDER OWN DEPARTMENT ONLY)_TSK005,TSK004,TSK007,TSK039,TSK063_Can assign to all user from different groups but only from the same department.',
			'TSK007' => 'ASSIGN TO MULTIPLE DEPARTMENT (APPLY TO GROUPS & USERS)_TSK005,TSK006,TSK004,TSK039,TSK063_Can assign to everyone regardless the groups and department.',
			'TSK039' => 'ASSIGN TO ALL STAFF UNDER OWN COMPANY OR OWN BRANCH (ONLY FOR CUSTOMER)_TSK005,TSK006,TSK007,TSK004,TSK063_Can assign to all staffs from the same company or branch that the user is registerd to.',
			'TSK063' => 'ASSIGN TO ALL STAFF UNDER OWN COMPANY AND ITS BRANCHES (ONLY FOR CUSTOMER)_TSK039,TSK006,TSK007,TSK004,TSK005_Can assign to all staffs from the same company and all associated branches.',
		],
		[
			'BREAK' => 'DELETE',
			'TSK027' => 'DELETE TASK',
			'NEWLINE_1' => TRUE,

			'TSK010' => 'DELETE JOBSHEET / DO',
			'TSK038' => 'DELETE ALL JOBSHEET / DO',
			'NEWLINE_2' => TRUE,

			'TSK014' => 'DELETE CUSTOMER COMMENTS',
			'TSK016' => 'DELETE OWN INTERNAL COMMENTS',
			'TSK055' => 'DELETE OWN ALT COMMENTS',
			'TSK056' => 'DELETE OWN LST COMMENTS',
			'NEWLINE_3' => TRUE,

			'TSK049' => 'DELETE SERVICE CHARGE (ALT & LST)',
			'TSK018' => 'DELETE CHARGES ',
			'TSK021' => 'DELETE CHARGES TO CUSTOMER',
		],
		[
			'BREAK' => 'VIEW TASK (SELECT ONLY 1)',
			'TSK029' => 'VIEW ALL TASK_TSK028,TSK032,TSK033_Have access to all created task.',
			'TSK028' => 'VIEW OWN TASK_TSK029,TSK032,TSK033_Have access only on self created task and self assigned task.',
			'TSK032' => 'VIEW ALL TASK UNDER OWN COMPANY_TSK028,TSK029,TSK033_Have access to all task associated to his/her company regardless who created it and assigned to who.',
			'TSK033' => 'VIEW ONLY OWN TASK UNDER OWN COMPANY_TSK028,TSK032,TSK029_Have access only on self created task and self assigned task associated to his/her company',
			// 'NEWLINE_1' => TRUE,
		],
		[
			'BREAK' => 'VIEW JOBSHEET (SELECT ONLY 1 FOR TSK030,TSK031)',
			'TSK012' => 'VIEW  JOBSHEET / DO',
			'TSK031' => 'VIEW ALL JOBSHEET_TSK030',
			'TSK030' => 'VIEW OWN JOBSHEET_TSK031',
			// 'NEWLINE_2' => TRUE,

			// 'TSK019' => 'VIEW CHARGES ',
			// 'TSK022' => 'VIEW CHARGES TO CUSTOMER',
			// 'NEWLINE_3' => TRUE,
		],
		[
			'BREAK' => 'VIEW COMMENTS',
			'TSK034' => 'VIEW ALT COMMENTS',
			'TSK036' => 'VIEW LST COMMENTS',
			'TSK042' => 'VIEW CUSTOMER COMMENTS',
			'TSK050' => 'VIEW INTERNAL COMMENTS',
			'NEWLINE_5' => TRUE,

			// 'TSK035' => 'VIEW ALT CHARGES LISTING',
			// 'TSK037' => 'VIEW LST CHARGES LISTING',
			// 'TSK043' => 'VIEW ALT CHARGES DETAIL',
			// 'TSK045' => 'VIEW LST CHARGES DETAIL',
		],
		[
			'BREAK' => 'EDIT',
			'TSK008' => 'EDIT TASK INFO',
			'TSK066' => 'EDIT TASK CREATED DATE TIME',
			'NEWLINE_1' => TRUE,

			'TSK009' => 'EDIT JOBSHEET / DO',
			'TSK040' => 'EDIT ALL JOBSHEET / DO',
			'TSK064' => 'EDIT JOBSHEET TIME IN / OUT',
			'TSK067' => 'EDIT JOBSHEET CREATED DATE TIME',
			'TSK065' => 'EDIT JOBSHEET TECH',
			'NEWLINE_2' => TRUE,

			'TSK013' => 'EDIT CUSTOMER COMMENTS',
			'TSK015' => 'EDIT OWN INTERNAL  COMMENTS',
			'TSK057' => 'EDIT OWN ALT COMMENTS',
			'TSK058' => 'EDIT OWN LST COMMENTS',
			'NEWLINE_3' => TRUE,

			// 'TSK017' => 'EDIT CHARGES ',
			// 'TSK020' => 'EDIT CHARGES TO CUSTOMER',
			// 'TSK046' => 'EDIT ALT CHARGES',
			// 'TSK047' => 'EDIT LST CHARGES',
			
		],
		// [
		// 	'BREAK' => 'VERIFY',
		// 	'TSK011' => 'VERIFY JOBSHEET / DO (FOR MANAGER)',
		// 	'TSK053' => 'VERIFY JOBSHEET / DO (FOR ADMIN)',
		// 	'TSK054' => 'VERIFY JOBSHEET / DO (FOR ACCOUNT)',
		// ],
		[
			'BREAK' => 'OTHERS',
			'TSK023' => 'COMPLETE TASK',
			'TSK024' => 'UPDATE TO IN PROGRESS TASK',
			'TSK025' => 'CLOSE TASK',
			'TSK026' => 'REOPEN TASK',
			'TSK041' => 'WRITE CUSTOMER COMMENTS',
			'TSK048' => 'ADD SERVICE CHARGE (ALT & LST)',
			'TSK051' => 'START ASSIGNED TASK',
			'TSK052' => 'START OTHERS TASK',
		]
	],
	3 => [
		'ATT' => 'ATTENDANCE / OT',
		'ATT001' => 'CHECK IN & OUT',
		'ATT002' => 'OT REQUEST',
		'ATT003' => 'OT RECORD'
	],
	4 => [
		'CLM' => 'CLAIM'
	],
	5 => [
		'LVE' => 'LEAVE SUBMISSION',
		'LVE001' => 'CANCEL LEAVE'
	],
	6 => [
		'PAY' => 'PAYSLIP'
	],
	7 => [
		'HR' => 'HR SYSTEM',
		[
			'HR-LVE' => 'LEAVE ACCESS',
			'HR-LVE001' => 'VIEW ALL LEAVE',
			'HR-LVE002' => 'VIEW LEAVE DETAILS',
			'HR-LVE003' => 'MANAGER APPROVE LEAVE_HR-LVE004,HR-LVE005',
			'HR-LVE004' => 'ADMIN APPROVE LEAVE_HR-LVE003,HR-LVE005',
			'HR-LVE005' => 'DIRECTOR APPROVE LEAVE_HR-LVE003,HR-LVE004',
			'HR-LVE006' => 'DECLINE LEAVE',
			'HR-LVE007' => 'CANCEL LEAVE',
		],
		[
			'HR-ENT' => 'ENTITLEMENTS ACCESS',
			'HR-ENT001' => 'VIEW',
			'HR-ENT002' => 'ASSIGN ENTITLEMENTS',
			'HR-ENT003' => 'EDIT',
			'HR-ENT004' => 'DELETE',
		],
		[
			'HR-PAY' => 'PAYSLIP ACCESS',
			'HR-PAY001' => 'VIEW ALL',
			'HR-PAY002' => 'CREATE',
			'HR-PAY003' => 'DELETE',
		],
		[
			'HR-LVE-C' => 'LEAVE CONFIG ACCESS',
			'HR-LVE-C001' => 'VIEW ALL',
			'HR-LVE-C002' => 'EDIT',
		],
		[
			'HR-ALW-S' => 'ALLOWANCE SETTING ACCESS',
			'HR-ALW-S001' => 'VIEW',
			'HR-ALW-S002' => 'EDIT'
		]
	],
	8 => [
		'RPT' => 'REPORT',
		[ 
			'RPT-TSK' => 'TASK' 
		],
		[
			'RPT-ATT' => 'ATTENDANCE',
			'RPT-ATT001' => 'ALL ATTENDANCE LISTING',
			'RPT-ATT002' => 'LISTING BY DEPARTMENT',
		],
		[
			'RPT-OTRQ' => 'OT REQUEST',
			'RPT-OTRQ001' => 'VIEW ALL',
			'RPT-OTRQ002' => 'VIEW BY DEPARTMENT',
			'RPT-OTRQ003' => 'APPROVE',
			'RPT-OTRQ004' => 'DECLINE',
			'RPT-OTRQ005' => 'EDIT',
		],
		[
			'RPT-OTREC' => 'OT RECORD',
			'RPT-OTREC001' => 'VIEW ALL',
			'RPT-OTREC002' => 'VIEW BY DEPARTMENT',
		],
		[
			'RPT-ATTSUM' => 'ATTENDANCE SUMMARY',
			'RPT-ATTSUM001' => 'VIEW ALL',
			'RPT-ATTSUM002' => 'VIEW BY DEPARTMENT'
		],
		[
			'RPT-CLM' => 'CLAIM',
			'RPT-CLM001' => 'DO APPROVAL',
			'RPT-CLM002' => 'DELETE CLAIM / DELETE VOUCHER',
			'RPT-CLM003' => 'SUBMIT CLAIM',
			'RPT-CLM004' => 'ADD RECEIPT',
			'RPT-CLM005' => 'EDIT RECEIPT',
			'RPT-CLM006' => 'DELETE RECEIPT',
			'RPT-CLM007' => 'PROCEED TO EXPORT',
			'RPT-CLM008' => 'DO PAYMENT',
			'RPT-CLM009' => 'MARK AS PAID'
		]
	],
	9 => [
		'MGM' => 'MANAGEMENT',
		[
			'MGM-USR' 		=> 'USER',
			'MGM-USR001' 	=> 'VIEW ALL',
			'MGM-USR002' 	=> 'CREATE USER',
			'MGM-USR003' 	=> 'VIEW DETAILS',
			'MGM-USR004' 	=> 'EDIT',
			'MGM-USR005' 	=> 'DELETE'
		],
		[
			'MGM-CO' 		=> 'COMPANY',
			'MGM-CO001' 	=> 'VIEW ALL',
			'MGM-CO002' 	=> 'CREATE COMPANY',
			'MGM-CO003' 	=> 'VIEW DETAILS',
			'MGM-CO004' 	=> 'EDIT',
			'MGM-CO005' 	=> 'DELETE'
		],
		[
			'MGM-BRN' 		=> 'BRANCH',
			'MGM-BRN001' 	=> 'VIEW ALL',
			'MGM-BRN002' 	=> 'CREATE BRANCH',
			'MGM-BRN003' 	=> 'VIEW DETAILS',
			'MGM-BRN004' 	=> 'EDIT',
			'MGM-BRN005' 	=> 'DELETE'
		]
	],
	10 =>[
		'CAL' => 'CALENDAR',
		[
			'CAT-NAT' => 'NATION',
			'CAL-NAT001' => 'VIEW ALL',
			'CAL-NAT002' => 'VIEW BY DEPARTMENT',
			'CAL-NAT003' => 'VIEW INDIVIDUALLY',
			'CAL-NAT004' => 'EDIT',
			'CAL-NAT005' => 'DELETE',
		],
		[
			'CAL-REG' => 'REGION',
			'CAL-REG001' => 'VIEW ALL',
			'CAL-REG002' => 'VIEW BY DEPARTMENT',
			'CAL-REG003' => 'VIEW INDIVIDUALLY',
			'CAL-REG004' => 'EDIT',
			'CAL-REG005' => 'DELETE'
		]
	],
	11 => [
		'SET' => 'SETTING',
		[
			'SET-EMP' => 'EMPLOYMENT TYPES',
			'SET-EMP001' => 'VIEW',
			'SET-EMP002' => 'CREATE',
			'SET-EMP003' => 'EDIT',
			'SET-EMP004' => 'DELETE',
		],
		[
			'SET-SFT' => 'SHIFT',
			'SET-SFT001' => 'VIEW',
			'SET-SFT002' => 'CREATE',
			'SET-SFT003' => 'EDIT',
			'SET-SFT004' => 'DELETE',
		],
		[
			'SET-CLMCAT' => 'CLAIM CATEGORY',
			'SET-CLMCAT001' => 'VIEW',
			'SET-CLMCAT002' => 'CREATE ACC CODE',
			'SET-CLMCAT003' => 'EDIT ACC CODE',
			'SET-CLMCAT004' => 'DELETE ACC CODE',
			'SET-CLMCAT005' => 'CREATE CATEGORY',
			'SET-CLMCAT006' => 'EDIT CATEGORY',
			'SET-CLMCAT007' => 'DELETE CATEGORY',
		],
		[
			'SET-PRJ' => 'PROJECT',
			'SET-PRJ001' => 'VIEW',
			'SET-PRJ002' => 'CREATE',
			'SET-PRJ003' => 'EDIT',
			'SET-PRJ004' => 'DELETE',
		],
		[
			'SET-CO' => 'COMPANY ON RECEIPT',
			'SET-CO001' => 'VIEW',
			'SET-CO002' => 'CREATE',
			'SET-CO003' => 'EDIT',
			'SET-CO004' => 'DELETE',
		],
		[
			'SET-CLM' => 'CONFIG',
			'SET-CLM001' => 'VIEW',
			'SET-CLM002' => 'UPDATE',
		],
		[
			'SET-SPC' => 'SPC',
			'SET-SPC001' => 'VIEW',
			'SET-SPC002' => 'EDIT'
		],
		[
			'SET-SGN' => 'SIGN IN DEFAULT PAGE',
			'SET-SGN001' => 'INDIVIDUAL LEVEL - CAN EDIT ALL SETTING',
			'SET-SGN002' => 'TEAM LEVEL - CAN EDIT OWN TEAM SETTING ONLY',
			'SET-SGN003' => 'TEAM LEVEL - CAN EDIT ALL TEAM SETTING'
		]
    ],
    12 => [
		'NTF' => 'NOTIFICATIONS',
		[
			'NTF-TSK' => 'TASK',
			'NTF-TSK001' => 'NEW TASK CREATED_ _Get the notification everytime when a new task is created. The customer for the task will be notified by default.',
			'NTF-TSK002' => 'TASK STATUS UPDATED',
			'NTF-TSK003' => 'TASK ASSIGNED_ _Get the notification when there is any user assigned to the task. The assigned user will get the notification by default.',
        ],
        [
			'NTF-JS' => 'JOBSHEET',
			'NTF-JS001' => 'JOBSHEET STARTED',
            'NTF-JS002' => 'JOBSHEET ENDED',
			'NTF-JS003' => 'JOBSHEET UPDATED',
            'NTF-JS004' => 'JOBSHEET CREATED',
        ],
    ],
    13 => [
		'ITEM' => 'ITEM MANAGEMENT',
		[
			'ITEM-FRM' => 'ITEM FORM CREATION',
			'ITEM-FRM001' => 'PURCHASE INVOICE FORM_ _Create item / service with purchase invoice form',
			'ITEM-FRM002' => 'ALT PURCHASE INVOICE FORM_ _Create item / service with ALT form',
			'ITEM-FRM003' => 'LST PURCHASE INVOICE FORM_ _Create item / service with LST form',
        ],
        // [
		// 	'ITEM-DTL' => 'ITEM DETAILS',
		// 	'ITEM-DTL001' => 'CAN VIEW ALL ITEMS FROM DIFFERENT LOCATIONS_ _Default access if none selected',
		// 	'ITEM-DTL002' => 'CAN VIEW ITEMS FROM OWN LOCATION',
        // ],
        # the item transfer now shouldn't allow for view all
        # switched to STK001 permission group
        // [
		// 	'ITEM-TFR' => 'STOCK TRANSFER',
		// 	'ITEM-TFR001' => 'CAN VIEW ALL ITEMS FROM DIFFERENT LOCATIONS',
		// 	'ITEM-TFR002' => 'CAN VIEW ITEMS FROM OWN LOCATION_ _Default access if none selected',
        // ],
	],
	14 => [
		'CHRG' => 'ALT / LST CHARGES',
		[
			'CHRG-VRFY' 	=> 'VERIFICATION',
			'CHRG-VRFY001' 	=> 'CAN VERIFY (MANAGER LEVEL)',
			'CHRG-VRFY002' 	=> 'CAN VERIFY (ADMIN LEVEL)',
			'CHRG-VRFY003' 	=> 'CAN VERIFY (ACCOUNT LEVEL)'
		]
    ],
    15 => [
		'XPRT'      => 'SYNC TO EXCEL',
		'XPRT001' 	=> 'EXPORT ALL',
        'XPRT002' 	=> 'CUSTOMER & SUPPLIER',
        'XPRT003' 	=> 'SALES',
        'XPRT004' 	=> 'PURCHASE',
        // 'XPRT005'   => 'STOCK ITEM',
        // 'XPRT006' 	=> 'STOCK TRANSFER'
    ],
    16 => [
        'STK'      => 'STOCK',
        [
			'STK-LST' => 'STOCK LIST',
			'STK-LST001' => 'CAN VIEW ALL ITEMS FROM DIFFERENT LOCATIONS',
            'STK-LST002' => 'CAN VIEW ITEMS FROM OWN LOCATION',
			'STK-LST003' => 'EDIT STOCK',
			'STK-LST004' => 'EXPORT STOCK LIST TO EXCEL',
        ],
        [
            'STK001' 	=> 'STOCK TRANSFER',
            'STK002' 	=> 'VIEW ALL STOCK TRANSFER RECORD',
            'STK003' 	=> 'VIEW OWN STOCK TRANSFER RECORD_ _Including the stock transferred to the current user',
            'STK004' 	=> 'VIEW ALL STOCK TRANSFER TRANSACTIONS',
            'STK005' 	=> 'VIEW OWN STOCK TRANSFER TRANSACTIONS',
        ],
    ],
    17 => [
        'SLS'    => 'SALES',
        'SLS001' => 'CAN EDIT SALES INVOICE',
        'SLS003' => 'CAN MANUALLY CREATE INVOICE NO',
	],
	21 => [
        'PCH'    => 'PURCHASE',
		[
			'BREAK' => 'VIEW TAB',
			'PCH001' => 'CAN VIEW INVOICE LISTING',
        	'PCH002' => 'CAN VIEW SUPPLIER LIST',
			'PCH003' => 'CAN VIEW EXPORT',
			'PCH004' => 'CAN VIEW EXPORT BATCH HISTORY',
		],
        [
			'BREAK' => 'VIEW LISTING (SELECT ONLY 1)',
			'PCH005' => 'CAN ONLY VIEW OWN PURCHASE INVOICE_PCH006',
        	'PCH006' => 'CAN VIEW ALL PURCHASE INVOICE_PCH005',
		],
		[
			'BREAK' => 'EDIT INVOICE (SELECT ONLY 1)',
			'PCH007' => 'CAN ONLY EDIT OWN CREATED PURCHASE INVOICE INVOICE_PCH008',
        	'PCH008' => 'CAN EDIT ALL PURCHASE INVOICE_PCH007',
		],
		[
			'BREAK' => 'GENERAL SETTINGS',
			'PCH009' => 'CAN VIEW AND UPDATE PURCHASE INVOICE GENERAL SETTINGS',
		],
	],
	18 => [
		'PWD'    => 'PASSWORD MANAGEMENT',
		'PWD001' => 'CAN ACCESS PASSWORD MANAGEMENT',
		'PWD002' => 'CAN ADD PASSWORD',
		'PWD003' => 'CAN ADD / DELETE ALL ACCESS'
	],
	19 => [
		'CHG' => 'CHARGES TO SMARTER',
		[
			'CHG-MLG' => 'MILEAGE CALCULATION - TICK ONLY 1',
			'CHG-MLG001' => 'FIXED MILEAGE CALCULATION_CHG-MLG002_0.30 * MILEAGE',
			'CHG-MLG002' => 'AUTO MILEAGE CALCULATION (DEFAULT FORMULA IF NONE SELECTED)_CHG-MLG001_MILEAGE * (PETROL PRICE / SPC)',
        ],
        [
			'CHG-OTH' => 'OTHER CHARGES',
			'CHG-OTH001' => 'ENABLE THE OTHER CHARGES FIELD',
		],
		[
			'CHG-PTRL' => 'PETROL AND MAINTENANCE CALCULATION',
			'CHG-PTRL001' => 'ROUND TRIP METHOD_ _This access will allow user to enter the mileage back to origin input from the jobsheet'
        ],
	],
	20 => [
		'LSTCHG' => 'LST CHARGES',
		'LSTCHG001' => 'CAN ONLY VIEW OWN CHARGES',
		'LSTCHG002' => 'CAN VIEW ALL CHARGES',
		'LSTCHG003' => 'CAN RE-GENERATE INVOICE',
		'LSTCHG004' => 'AUTO SELECT ITS COMPANY AND CANNOT SELECT/VIEW OTHER COMPANY LISTING',
    ],
];