<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
| example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
| https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
| $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
| $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
| $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples: my-controller/index -> my_controller/index
|   my-controller/my-method -> my_controller/my_method
*/

/* START :: BUILD CODE VERSION 1 */
	$route['notifications/(:any)/(:num)'] = 'api/NotificationsController/$1/$2';
	$route['notifications/(:any)'] = 'api/NotificationsController/$1';
	$route['notifications'] = 'api/NotificationsController/index';

	$route['claim/(:any)/(:any)'] = 'api/ClaimController/$1/$2';
	$route['claim/(:any)'] = 'api/ClaimController/$1';

	$route['access/(:any)/(:num)'] = 'api/AccessRightController/$1/$2';
	$route['access/(:any)'] = 'api/AccessRightController/$1';

	$route['ot/(:any)/(:num)'] = 'api/attendance/OTController/$1/$2';
	$route['ot/(:any)'] = 'api/attendance/OTController/$1';

	$route['attnd/(:any)/(:num)'] = 'api/attendance/AttndController/$1/$2';
	$route['attnd/(:any)'] = 'api/attendance/AttndController/$1';

	$route['alt-charges/(:any)/(:num)/(:num)'] = 'api/charges/ALT_ChargesController/$1/$2/$3';
	$route['alt-charges/(:any)/(:num)'] = 'api/charges/ALT_ChargesController/$1/$2';
	$route['alt-charges/(:any)'] = 'api/charges/ALT_ChargesController/$1';

	$route['sign-upload/(:num)'] = 'api/TaskController/sign_upload/$1';
	$route['verify-js/(:num)/(:num)'] = 'api/TaskController/verify_js/$1/$2';
	$route['task/(:any)/(:num)'] = 'api/TaskController/$1/$2';
	$route['task/(:any)'] = 'api/TaskController/$1';

	$route['auth/(:any)/(:num)'] = 'api/AuthController/$1/$2';
	$route['auth/(:any)'] = 'api/AuthController/$1';

	$route['register'] = 'api/AuthController/register';
	$route['login'] = 'api/AuthController/login';
	$route['user'] = 'api/AuthController/user';

	# stock transfer
	$route['stock-transfer/transactions/(:num)'] = '/api/StockTransferController/transaction_details/$1';
	$route['stock-transfer/entry'] = '/api/StockTransferController/entry';
	$route['stock-transfer/(:any)/(:num)'] = '/api/StockTransferController/$1/$2';
    $route['stock-transfer/(:any)'] = '/api/StockTransferController/$1';
	$route['stock-transfer'] = '/api/StockTransferController';

	$route['version/(:any)'] = 'api/VersionController/$1';

	$route['test/(:any)'] = 'api/TestingController/$1';

$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = TRUE;

/*
| -------------------------------------------------------------------------
| Sample REST API Routes
| -------------------------------------------------------------------------
*/
// $route['api/example/users/(:num)'] = 'api/example/users/id/$1'; // Example 4
// $route['api/example/users/(:num)(\.)([a-zA-Z0-9_-]+)(.*)'] = 'api/example/users/id/$1/format/$3$4'; // Example 8
